/* pgmigrate-encoding: utf-8 */

update user_products
set code_family = 'mail_pro_b2c_premium50000'
where code like '%50000%';

update user_products
set code_family = 'mail_pro_b2c_premium25000'
where code like '%25000%';

with titles as (
    select *
    from (
             values ('PS_BILLING_mail_pro_b2c_premium25000_v20210813_month_subs',
                     'Яндекс 360 Премиум 25 ТБ на месяц'),
                    ('PS_BILLING_mail_pro_b2c_premium25000_discount20_v20210813_month_subs',
                     'Яндекс 360 Премиум 25 ТБ на месяц (скидка -20%)'),
                    ('PS_BILLING_mail_pro_b2c_premium25000_discount30_v20210813_month_subs',
                     'Яндекс 360 Премиум 25 ТБ на месяц (скидка -30%)'),

                    ('PS_BILLING_mail_pro_b2c_premium25000_v20210813_year_subs',
                     'Яндекс 360 Премиум 25 ТБ на год'),
                    ('PS_BILLING_mail_pro_b2c_premium25000_discount20_v20210813_year_subs',
                     'Яндекс 360 Премиум 25 ТБ на год (скидка -20%)'),
                    ('PS_BILLING_mail_pro_b2c_premium25000_discount30_v20210813_year_subs',
                     'Яндекс 360 Премиум 25 ТБ на год (скидка -30%)'),

                    ('PS_BILLING_mail_pro_b2c_premium50000_v20210813_month_subs',
                     'Яндекс 360 Премиум 50 ТБ на месяц'),
                    ('PS_BILLING_mail_pro_b2c_premium50000_discount20_v20210813_month_subs',
                     'Яндекс 360 Премиум 50 ТБ на месяц (скидка -20%)'),
                    ('PS_BILLING_mail_pro_b2c_premium50000_discount30_v20210813_month_subs',
                     'Яндекс 360 Премиум 50 ТБ на месяц (скидка -30%)'),

                    ('PS_BILLING_mail_pro_b2c_premium50000_v20210813_year_subs',
                     'Яндекс 360 Премиум 50 ТБ на год'),
                    ('PS_BILLING_mail_pro_b2c_premium50000_discount20_v20210813_year_subs',
                     'Яндекс 360 Премиум 50 ТБ на год (скидка -20%)'),
                    ('PS_BILLING_mail_pro_b2c_premium50000_discount30_v20210813_year_subs',
                     'Яндекс 360 Премиум 50 ТБ на год (скидка -30%)')
         ) s (period_code, title)
)
update user_product_periods
set trust_fiscal_title = (select title from titles where period_code = code)
where code in (select period_code from titles);

update user_product_periods set trust_fiscal_title = replace(trust_fiscal_title, '(скидка -20%)', '(скидка -30%)')
where code like '%discount30%';

update user_product_periods set trust_fiscal_title = replace(trust_fiscal_title, 'Почта 360', 'Яндекс 360')
where trust_fiscal_title like '%Почта 360%';
