/* pgmigrate-encoding: utf-8 */

with prices as (select *
                from (values ('month', null, 'mail_pro_b2c_standard100_v20210610', 1.49),
                             ('month', null, 'mail_pro_b2c_premium1000_v20210610', 2.49),
                             ('month', null, 'mail_pro_b2c_premium3000_v20210610', 5.49),
                             ('month', null, 'mail_pro_b2c_premium5000_v20210610', 7.99),
                             ('month', null, 'mail_pro_b2c_premium10000_v20210610', 13.99),
                             ('month', null, 'mail_pro_b2c_premium25000_v20210813', 33.99),
                             ('month', null, 'mail_pro_b2c_premium50000_v20210813', 67.99),

                             ('year', null, 'mail_pro_b2c_standard100_v20210610', 9.99),
                             ('year', null, 'mail_pro_b2c_premium1000_v20210610', 18.99),
                             ('year', null, 'mail_pro_b2c_premium3000_v20210610', 38.99),
                             ('year', null, 'mail_pro_b2c_premium5000_v20210610', 59.99),
                             ('year', null, 'mail_pro_b2c_premium10000_v20210610', 94.99),
                             ('year', null, 'mail_pro_b2c_premium25000_v20210813', 239.99),
                             ('year', null, 'mail_pro_b2c_premium50000_v20210813', 449.99),

                             ('month', 20, 'mail_pro_b2c_standard100_discount20_v20210610', 1.19),
                             ('month', 20, 'mail_pro_b2c_premium1000_discount20_v20210610', 1.99),
                             ('month', 20, 'mail_pro_b2c_premium3000_discount20_v20210610', 4.39),
                             ('month', 20, 'mail_pro_b2c_premium5000_discount20_v20210610', 6.39),
                             ('month', 20, 'mail_pro_b2c_premium10000_discount20_v20210610', 11.19),
                             ('month', 20, 'mail_pro_b2c_premium25000_discount20_v20210813', 27.19),
                             ('month', 20, 'mail_pro_b2c_premium50000_discount20_v20210813', 54.39),

                             ('year', 20, 'mail_pro_b2c_standard100_discount20_v20210610', 7.99),
                             ('year', 20, 'mail_pro_b2c_premium1000_discount20_v20210610', 15.19),
                             ('year', 20, 'mail_pro_b2c_premium3000_discount20_v20210610', 31.19),
                             ('year', 20, 'mail_pro_b2c_premium5000_discount20_v20210610', 47.99),
                             ('year', 20, 'mail_pro_b2c_premium10000_discount20_v20210610', 75.99),
                             ('year', 20, 'mail_pro_b2c_premium25000_discount20_v20210813', 191.99),
                             ('year', 20, 'mail_pro_b2c_premium50000_discount20_v20210813', 359.99),

                             ('month', 30, 'mail_pro_b2c_standard100_discount30_v20210610', 1.04),
                             ('month', 30, 'mail_pro_b2c_premium1000_discount30_v20210610', 1.74),
                             ('month', 30, 'mail_pro_b2c_premium3000_discount30_v20210610', 3.84),
                             ('month', 30, 'mail_pro_b2c_premium5000_discount30_v20210610', 5.59),
                             ('month', 30, 'mail_pro_b2c_premium10000_discount30_v20210610', 9.79),
                             ('month', 30, 'mail_pro_b2c_premium25000_discount30_v20210813', 23.79),
                             ('month', 30, 'mail_pro_b2c_premium50000_discount30_v20210813', 47.59),

                             ('year', 30, 'mail_pro_b2c_standard100_discount30_v20210610', 6.99),
                             ('year', 30, 'mail_pro_b2c_premium1000_discount30_v20210610', 13.29),
                             ('year', 30, 'mail_pro_b2c_premium3000_discount30_v20210610', 27.29),
                             ('year', 30, 'mail_pro_b2c_premium5000_discount30_v20210610', 41.99),
                             ('year', 30, 'mail_pro_b2c_premium10000_discount30_v20210610', 66.49),
                             ('year', 30, 'mail_pro_b2c_premium25000_discount30_v20210813', 167.99),
                             ('year', 30, 'mail_pro_b2c_premium50000_discount30_v20210813', 314.99)
                     ) s
                         (period, discount, product, price)
),
     original_prices as
         (
             select up.code_family, upp.period, dp.price
             from user_products up
                      join user_product_periods upp on up.id = upp.user_product_id
                      join user_product_prices pr on upp.id = pr.user_product_period_id
                      join prices as dp
                           on dp.product = up.code and upp.period = dp.period
                               and coalesce(pr.display_discount_percent, 0) = coalesce(dp.discount, 0)
             where pr.display_discount_percent is null
         )
insert
into user_product_prices
(created_at, region_id, price, currency, display_discount_percent, display_original_price, user_product_period_id)
select now(),
       84,
       dp.price,
       'USD',
       dp.discount,
       case when dp.discount is not null then original_prices.price end as origin_price,
       upp.id
from product_sets ps
         join product_lines pl on ps.id = pl.product_set_id
         join user_products_to_product_lines uptpl on pl.id = uptpl.product_line_id
         join user_products up on uptpl.user_product_id = up.id
         join user_product_periods upp on up.id = upp.user_product_id
         join user_product_prices pr on upp.id = pr.user_product_period_id
         join prices as dp
              on dp.product = up.code and upp.period = dp.period
                  and coalesce(pr.display_discount_percent, 0) = coalesce(dp.discount, 0)
         join original_prices on up.code_family = original_prices.code_family and original_prices.period = dp.period
where ps.key = 'mail_pro_b2c'
  and pl.selector_bean_el = 'productLineSelectorFactory.availableSelector()'



