/* pgmigrate-encoding: utf-8 */

delete
from promo_product_lines
where promo_template_id = (select id from promo_templates where code = 'september_early_mobile_promo')
  and product_line_id =
      (
          select pl.id
          from promo_templates pt
                   join promo_product_lines ppl on pt.id = ppl.promo_template_id
                   join product_lines pl on ppl.product_line_id = pl.id
                   join product_sets ps on pl.product_set_id = ps.id
          where ps.key = 'inapp_ios_disk'
            and pt.code = 'september_early_mobile_promo'
      );

insert into promo_product_lines (promo_template_id, product_line_id)
select distinct pt.id, pl.id
from promo_templates pt,
     product_sets ps
         join product_lines pl on ps.id = pl.product_set_id
         join user_products_to_product_lines uptpl on pl.id = uptpl.product_line_id
         join user_products up on uptpl.user_product_id = up.id
where key in ('inapp_ios_disk', 'inapp_ios_mail')
  and pl.order_num = 1
  and pt.code = 'september_early_mobile_promo';

update promo_templates pt
set from_date = '2021-09-07',
    to_date   = '2021-09-11'
where pt.code = 'september_early_mobile_promo';
