/* pgmigrate-encoding: utf-8 */

-- CHEMODAN-79746
--  надоело селектить лайны по косвенным параметрам - хочется иметь явный признак - например "веб линейка 20% скидка"
alter table product_lines
    add description text;
comment on column product_lines.description is 'Не участвует в логике. Нужно для более удобных миграций';

with line_codes as (
    select *
    from (values ('inapp_android', 1, 'android default line'),
                 ('inapp_android', 1001, 'android introductory line'),
                 ('inapp_ios_disk', 1, 'ios disk default line'),
                 ('inapp_ios_disk', 1001, 'ios test line'),
                 ('inapp_ios_mail', 1, 'ios mail default line'),
                 ('mail_pro_b2c', 1, 'web default line'),
                 ('mail_pro_b2c', 1001, 'web trial line'),
                 ('mail_pro_b2c', 1002, 'web 30% discount line'),
                 ('mail_pro_b2c', 1003, 'web 20% discount line')
         ) s
             (product_set, order_num, description)
)
update product_lines pl
set description= (select lc.description
                  from product_sets ps
                           join line_codes lc on lc.product_set = ps.key
                  where ps.id = pl.product_set_id
                    and lc.order_num = pl.order_num)
where description is null;

-- а теперь удобно создаем акции
-- веб
insert into promo_templates
(code, description, promo_name_tanker_key_id, from_date, to_date, application_area, application_type, duration,
 duration_measurement, activation_email_template_key, created_at)
values ('september_end_web_promo', '20% на все продукты в конце сентбря', null,
        '2021-09-20T00:00:00.000+0300' AT TIME ZONE 'UTC', '2021-10-01T00:00:00.000+0300' AT TIME ZONE 'UTC',
        'global'::promo_application_area, 'multiple_time'::promo_application_type, null, null, null, now());

insert into promo_product_lines(promo_template_id, product_line_id)
VALUES ((select id from promo_templates where code = 'september_end_web_promo'),
        (select l.id
         from product_lines l
         where l.description = 'web 20% discount line'));


-- мобилы. отдельно, потому что есть баг с датой в мобилах MOBDISK-23958
with description_key as
         (
             insert into tanker_keys (created_at, project, key_set, key)
                 values (now(), 'disk-ps-billing', 'promos', 'september_end_mobile_promo') returning id
         )
insert
into promo_templates
(code, description, promo_name_tanker_key_id, from_date, to_date, application_area, application_type, duration,
 duration_measurement, activation_email_template_key, mobile_payload, created_at)
values ('september_end_mobile_promo', '-20% для мобильных в конце сентября',
        (select id from description_key),
        '2021-09-20T00:00:00.000+0300' AT TIME ZONE 'UTC', '2021-09-30T23:59:59.000+0300' AT TIME ZONE 'UTC', -- двигаем дату на секунду назад, чтобы мобилы правильно отобразили дату конца акции
        'global'::promo_application_area, 'one_time'::promo_application_type, null, null, null,
        null, now());

insert into promo_product_lines(promo_template_id, product_line_id)
select pt.id, l.id
from promo_templates pt,
     product_lines l
where l.description in ('ios mail default line', 'android introductory line', 'ios disk default line')
  and pt.code = 'september_end_mobile_promo';
