/* pgmigrate-encoding: utf-8 */

-- https://st.yandex-team.ru/PSBTBSUP-948
-- продлеваем триал до 1 декабря
insert into group_service_price_overrides
(group_service_id, created_at, price, start_date, end_date, trial_usage_id, reason, hidden)
    (select gspo.group_service_id,
            now(),
            0,
            gspo.end_date,
            '2021-12-01T00:00:00.000+0300' AT TIME ZONE 'UTC',
            null,
            'gift',
            false
     from groups g
              join group_services gs on g.id = gs.group_id
              join group_service_price_overrides gspo on gs.id = gspo.group_service_id
              join group_products gp on gs.group_product_id = gp.id
     where g.group_external_id = '6065369'
       and gp.code = 'org_mail_pro_standard100'
    );

--включаем опять услугу
update group_services
set target            = 'enabled',
    target_updated_at = now(),
    status            = 'init',
    status_updated_at = now()
where target = 'disabled'
  and id =
      (select gs.id
       from groups g
                join group_services gs on g.id = gs.group_id
                join group_products gp on gs.group_product_id = gp.id
       where g.group_external_id = '6065369'
         and gp.code = 'org_mail_pro_standard100');

-- https://st.yandex-team.ru/CHEMODAN-79889
-- продлеваем триал до 1 ноября
update group_service_price_overrides
set end_date = '2021-11-01T00:00:00.000+0300' AT TIME ZONE 'UTC'
where id in
      (select gspo.id
       from groups g
                join group_services gs on g.id = gs.group_id
                join group_service_price_overrides gspo on gs.id = gspo.group_service_id
                join group_products gp on gs.group_product_id = gp.id
       where g.group_external_id in ('2067153', '2067120')
         and gp.code = 'org_mail_pro_standard100_trial30'
         and gspo.price = 0
         and gspo.end_date > now()
      );

-- переносим дату начала платного периода на позже
update group_service_price_overrides
set start_date = '2021-11-01T00:00:00.000+0300' AT TIME ZONE 'UTC'
where id in
      (select gspo.id
       from groups g
                join group_services gs on g.id = gs.group_id
                join group_service_price_overrides gspo on gs.id = gspo.group_service_id
                join group_products gp on gs.group_product_id = gp.id
       where g.group_external_id in ('2067153', '2067120')
         and gp.code = 'org_mail_pro_standard100_trial30'
         and gspo.price = 100
      )



