/* pgmigrate-encoding: utf-8 */

create table product_templates
(
    id         uuid      default uuid_generate_v4() not null,
    code       text                                 not null,
    created_at timestamp default now()              not null,
    primary key (id),
    constraint uniq_code unique (code)
);

insert into product_templates (code)
select distinct code_family
from user_products;


create table product_template_features
(
    id                        uuid    default uuid_generate_v4() not null,
    product_template_id       uuid                               not null,
    feature_id                uuid,
    amount                    numeric                            not null,
    created_at                timestamp                          not null,
    description_tanker_key_id uuid,
    group_tanker_key_id       uuid,
    value_tanker_key_id       uuid,
    enabled                   boolean default true,
    order_num                 numeric default 1                  not null,
    code                      text,

    primary key (id),
    constraint fk_product_template_id foreign key (product_template_id) references product_templates (id),
    constraint fk_description_tanker_key_id foreign key (description_tanker_key_id) references tanker_keys (id),
    constraint fk_group_tanker_key_id foreign key (group_tanker_key_id) references tanker_keys (id),
    constraint fk_value_tanker_key_id foreign key (value_tanker_key_id) references tanker_keys (id)
);

create index product_template_features_feature_id_idx on product_template_features (feature_id);
create index product_template_features_user_product_template_id_idx on product_template_features (product_template_id);
create index product_template_features_description_tanker_key_id_idx on product_template_features (description_tanker_key_id);
create index product_template_features_group_tanker_key_id_idx on product_template_features (group_tanker_key_id);
create index product_template_features_value_tanker_key_id_idx on product_template_features (value_tanker_key_id);


insert into product_template_features (id, product_template_id, feature_id, amount, created_at,
                                       description_tanker_key_id,
                                       group_tanker_key_id, value_tanker_key_id, enabled, order_num, code)
select pf.id,
       pt.id,
       pf.feature_id,
       pf.amount,
       pf.created_at,
       pf.description_tanker_key_id,
       pf.group_tanker_key_id,
       pf.value_tanker_key_id,
       pf.enabled,
       pf.order_num,
       pf.code
from (
         select distinct on (up.code_family) up.code_family,
                                             up.id
         from user_products as up
     ) as uniq_up
         join product_features as pf on uniq_up.id = pf.user_product_id
         join product_templates as pt on uniq_up.code_family = pt.code
where pf.enabled;


alter table user_service_features
    add column product_template_feature_id uuid null;
alter table user_service_features
    add constraint fk_product_template_feature_id foreign key (product_template_feature_id)
        references product_template_features (id);


alter table user_products
    add column product_template_id uuid null;
alter table user_products
    add constraint fk_product_template foreign key (product_template_id)
        references product_templates (id);
create index user_products_product_template_id_idx on user_products (product_template_id);

update user_products
set product_template_id = (select pt.id from product_templates as pt where pt.code = code_family)
where product_template_id is null
  and code_family is not null;


