/* pgmigrate-encoding: utf-8 */

--Table for storing environment dependent values
create table environment
(
    key   varchar(20) constraint "environment_pk" primary key,
    value varchar(50)
);

insert into environment (key, value)
values ('env', (SELECT case
                           when (select id = '6d6685f5-29ca-4b97-9268-bd21db35b0b1'
                                 from group_products
                                 where code = 'org_disk_2tb_v1')
                               then 'prod'
                           when (select id = '0465e208-5abf-4b14-adb2-cb5e1ebf715e'
                                 from group_products
                                 where code = 'org_disk_2tb_v1')
                               then 'prestable'
                           else 'test'
                           end));

--datasync_ro_no_b2c_tariff_promo feature
--datasync base_url
with datasync (base_url) as (
    select case
               when (select (select value from environment where key = 'env') in ('prod', 'prestable'))
                   then 'https://intapi.disk.yandex.net:8443/v1/personality/profile/ps/read_only/user_features/datasync_ro_no_b2c_tariff_promo'
               else 'http://api-stable.dst.yandex.net:8080/v1/personality/profile/ps/read_only/user_features/datasync_ro_no_b2c_tariff_promo'
               end
)
insert
into features(code, created_at, updated_at, system_tvm_id, type, description, system_name,
              activation_url_http_method, activation_url_template, set_amount_url_http_method,
              set_amount_url_template, deactivation_url_http_method, deactivation_url_template,
              call_set_amount_on_activation, call_set_amount_on_deactivation, activation_body_template,
              set_amount_body_template, deactivation_body_template, activation_content_type,
              deactivation_content_type, set_amount_content_type, error_processor_name)
select 'datasync_ro_no_b2c_tariff_promo',
       now(),
       now(),
       null,                                     --f.system_tvm_id,
       f.type,
       'Сокрытие промо b2c подписки (datasync)', --f.description
       'mpfs-api',                               --f.system_name,
       'PUT',                                    --f.activation_url_http_method,
       (SELECT base_url from datasync),          --f.activation_url_template,
       null,                                     --f.set_amount_url_http_method,
       null,                                     --f.set_amount_url_template,
       'DELETE',                                 --f.deactivation_url_http_method,
       (SELECT base_url from datasync),          --f.deactivation_url_template,
       false,                                    --f.call_set_amount_on_activation,
       false,                                    --f.call_set_amount_on_deactivation,
       '{"enabled":true}',                       --f.activation_body_template,
       null,                                     --f.set_amount_body_template,
       '',                                       --f.deactivation_body_template,
       'application/json',                       --f.activation_content_type,
       'application/json',                       --f.deactivation_content_type,
       null,                                     --f.set_amount_content_type,
       'default'                                 -- f.error_processor_name --TODO(!)
from features f
where f.code = 'ro_no_b2c_tariff_promo';

insert into product_features(user_product_id, feature_id, amount, created_at, description_tanker_key_id, enabled,
                             group_tanker_key_id, value_tanker_key_id, order_num, code, scope)
select pf.user_product_id,
       (select id from features where code = 'datasync_ro_no_b2c_tariff_promo'),
       1,
       now(),
       null, --description_tanker_key_id=null is the crunch for hidden by default feature
       pf.enabled,
       null,
       null,
       999,
       'datasync_ro_no_b2c_tariff_promo',
       pf.scope
from product_features pf
where code = 'ro_no_b2c_tariff_promo';

--datasync_ro_no_yandex_jobs feature
--datasync base_url
with datasync (base_url) as (
    select case
               when (select (select value from environment where key = 'env') in ('prod', 'prestable'))
                   then 'https://intapi.disk.yandex.net:8443/v1/personality/profile/ps/read_only/user_features/datasync_ro_no_yandex_jobs'
               else 'http://api-stable.dst.yandex.net:8080/v1/personality/profile/ps/read_only/user_features/datasync_ro_no_yandex_jobs'
               end
)

insert
into features(code, created_at, updated_at, system_tvm_id, type, description, system_name,
              activation_url_http_method, activation_url_template, set_amount_url_http_method,
              set_amount_url_template, deactivation_url_http_method, deactivation_url_template,
              call_set_amount_on_activation, call_set_amount_on_deactivation, activation_body_template,
              set_amount_body_template, deactivation_body_template, activation_content_type,
              deactivation_content_type, set_amount_content_type, error_processor_name)
select 'datasync_ro_no_yandex_jobs',
       now(),
       now(),
       f.system_tvm_id,
       f.type,
       'Сокрытие промо вакансий (datasync)', --f.description
       f.system_name,
       f.activation_url_http_method,
       (SELECT base_url from datasync),      --f.activation_url_template,
       f.set_amount_url_http_method,
       f.set_amount_url_template,
       f.deactivation_url_http_method,
       (SELECT base_url from datasync),      --f.deactivation_url_template,
       f.call_set_amount_on_activation,
       f.call_set_amount_on_deactivation,
       f.activation_body_template,
       f.set_amount_body_template,
       f.deactivation_body_template,
       f.activation_content_type,
       f.deactivation_content_type,
       f.set_amount_content_type,
       f.error_processor_name
from features f
where f.code = 'datasync_ro_no_b2c_tariff_promo';

insert into product_features(user_product_id, feature_id, amount, created_at, description_tanker_key_id, enabled,
                             group_tanker_key_id, value_tanker_key_id, order_num, code, scope)
select pf.user_product_id,
       (select id from features where code = 'datasync_ro_no_yandex_jobs'),
       1,
       now(),
       null, --description_tanker_key_id=null is the crunch for hidden by default feature
       pf.enabled,
       null,
       null,
       999,
       'datasync_ro_no_yandex_jobs',
       pf.scope
from product_features pf
where code = 'ro_no_yandex_jobs';


--update user_services
update user_services
set status            = 'init',
    updated_at        = now(),
    status_updated_at = now()
where target = 'enabled'
  and id in (
    select id
    from user_services
    where user_product_id in (
        select pf.user_product_id
        from product_features pf
        where code in ('datasync_ro_no_b2c_tariff_promo', 'datasync_ro_no_yandex_jobs')));
