-- fix enum value
ALTER TYPE feature_scope RENAME TO feature_scope_old;
create type feature_scope as enum ('group', 'user');

alter table product_features
    alter column scope TYPE feature_scope USING scope::text::feature_scope;


-- group_services columns = user_services columns
alter table group_services
    add column first_feature_disabled_at timestamp;
alter table group_services
    add column updated_at timestamp;


-- new table group_service_features
create table group_service_features
(
    id                          uuid default uuid_generate_v4() not null primary key,
    group_service_id            uuid                            not null references group_services,
    product_feature_id          uuid                            not null references product_features,
    product_template_feature_id uuid                            null references product_template_features,
    created_at                  timestamp                       not null,
    target                      text                            not null,
    target_updated_at           timestamp                       not null,
    status                      text                            not null,
    status_updated_at           timestamp                       not null,
    actual_enabled_at           timestamp,
    actual_disabled_at          timestamp,
    group_id                    uuid                            not null references groups,
    locked_till                 timestamp,
    lock_id                     uuid,
    next_try                    timestamp
);
create index group_service_features__group_ix
    on group_service_features (group_id);

create index group_service_features_product_feature_id_ix
    on group_service_features (product_feature_id);

create index group_service_features_product_feature_template_id_ix
    on group_service_features (product_template_feature_id);

create index group_service_features_group_service_id_ix
    on group_service_features (group_service_id);

create index group_service_features__group__target__status__ix
    on group_service_features (group_id, target, status);

create index group_service_features__not_actual_status__ix
    on group_service_features (status)
    where (status <> 'actual'::text);

create index group_service_features_lock_id_ix
    on group_service_features (lock_id)
    where (lock_id IS NOT NULL);

-- feature_callback_context for groups
alter table feature_callback_context
    add column group_id UUID references groups;

create index feature_callback_context_groups_i
    on feature_callback_context (group_id);

alter table feature_callback_context
    alter column uid drop not null;

create unique index feature_callback_context_uniq_group_ix
    on feature_callback_context (group_id, feature_id);

