/* pgmigrate-encoding: utf-8 */
--  add constraint to avoid duplicates
alter table product_features
    add constraint product_features_uk
        unique (user_product_id, feature_id, code, scope);


with fan_info (base_url, tvm_id) as (
    select case
               when (select (select value from environment where key = 'env') in ('prod', 'prestable'))
                   then 'https://fan-back.mail.yandex.net/api/organization/limit?org_id=#{groupExternalId}&value=#{amount}'
               else 'http://fan-back-test.mail.yandex.net/api/organization/limit?org_id=#{groupExternalId}&value=#{amount}'
               end,
           case
               -- https://wiki.yandex-team.ru/fan/arch/components/backend/api/#okruzhenija
               when (select (select value from environment where key = 'env') in ('prod', 'prestable'))
                   then 2026060
               else 2026062
               end
)
insert
into features(code, created_at, updated_at, system_tvm_id, type, description, system_name,
              activation_url_http_method, activation_url_template, set_amount_url_http_method,
              set_amount_url_template, deactivation_url_http_method, deactivation_url_template,
              call_set_amount_on_activation, call_set_amount_on_deactivation, activation_body_template,
              set_amount_body_template, deactivation_body_template, activation_content_type,
              deactivation_content_type, set_amount_content_type, error_processor_name)
SELECT 'fan_mail_limit',
       now(),
       now(),
       tvm_id,                                   --f.system_tvm_id,
       'additive',
       'Лимит массовой рассылки для организации',--f.description
       'fan',                                    --f.system_name,
       'PUT',                                    --f.activation_url_http_method,
       null,                                     --f.activation_url_template,
       'PUT',                                    --f.set_amount_url_http_method,
       base_url,                                 --f.set_amount_url_template,
       'PUT',                                    --f.deactivation_url_http_method,
       null,                                     --f.deactivation_url_template,
       true,                                     --f.call_set_amount_on_activation,
       true,                                     --f.call_set_amount_on_deactivation,
       '',                                       --f.activation_body_template,
       null,                                     --f.set_amount_body_template,
       '',                                       --f.deactivation_body_template,
       'application/json',                       --f.activation_content_type,
       'application/json',                       --f.deactivation_content_type,
       null,                                     --f.set_amount_content_type,
       'default'                                 --f.error_processor_name
from fan_info;

with inserted_tanker_keys as
         (
             insert into tanker_keys (created_at, project, key_set, key)
                 values (now(), 'disk-ps-billing', 'features', 'fan_mail_limit_1500'),
                        (now(), 'disk-ps-billing', 'features', 'fan_mail_limit_50000')
                 returning id, key
         ),
     tanker_keys_with_limit as
         (
             select *
             from (values (0, (select id from inserted_tanker_keys where key = 'fan_mail_limit_1500')),
                          (50000, (select id from inserted_tanker_keys where key = 'fan_mail_limit_50000'))
                  ) s (fan_limit, tanker_key_id)
         ),
     products_limit as
         (
             select *
             from (values ('org_disk_default_v1', 0),
                          ('org_mail_pro_v1', 0),
                          ('org_mail_pro_trial60_v1', 0),
                          ('org_disk_2tb_v1', 0),
                          ('org_disk_200gb_v1', 0),
                          ('org_disk_200gb_trial_v1', 0),
                          ('org_disk_200gb_trial60_v1', 0),
                          ('org_mail_pro_standard100', 0),
                          ('org_mail_pro_standard100_trial30', 0),
                          ('org_mail_pro_standard200', 0),
                          ('org_mail_pro_premium1000', 50000),
                          ('org_mail_pro_premium3000_wo_trial', 50000),
                          ('org_mail_pro_premium3000', 50000),
                          ('org_mail_pro_edu_standard100', 0),
                          ('org_mail_pro_edu_premium1000', 50000),
                          ('org_mail_pro_edu_premium3000', 50000)) s (group_product_code, fan_limit)
         )
insert
into product_features(user_product_id, feature_id, amount, created_at, description_tanker_key_id, enabled,
                      group_tanker_key_id, value_tanker_key_id, order_num, code, scope)
select distinct gp.user_product_id,
                case when pl.fan_limit > 0 then (select id from features where code = 'fan_mail_limit') end,
                pl.fan_limit,
                now(),
                itk.tanker_key_id,
                true, -- enabled
                (select id
                 from tanker_keys
                 where project = 'disk-ps-billing'
                   and key_set = 'features'
                   and key = 'mail_pro_b2c_group_disk'),
                itk.tanker_key_id,
                case
                    when pf.order_num is null then (
                        select max(pf2.order_num)
                        from group_products gp2
                                 join product_features pf2 on pf2.user_product_id = gp2.user_product_id
                        where gp2.code = gp2.code
                          and pf2.order_num < 999
                    )
                    else pf.order_num + 1
                    end as order_num,
                'fan_mail_limit',
                'group'::feature_scope
from products_limit pl
         join group_products gp on gp.code = pl.group_product_code
         left join product_features pf
                   on pf.user_product_id = gp.user_product_id and pf.code = 'mail_pro_b2c_advertise_free'
         join tanker_keys_with_limit itk on itk.fan_limit = pl.fan_limit;


-- fix order_num
update product_features pf
set order_num = pf.order_num + 1
where pf.order_num < 999
  and pf.code != 'fan_mail_limit'
  and pf.order_num >= coalesce((select pf2.order_num
                                from product_features pf2
                                where pf2.user_product_id = pf.user_product_id
                                  and pf2.code = 'fan_mail_limit'), pf.order_num + 1);
