/* pgmigrate-encoding: utf-8 */

with fan_info (base_url, tvm_id) as (
    select case
               when (select (select value from environment where key = 'env') in ('prod', 'prestable'))
                   then 'https://fan-back.mail.yandex.net//api/organization/trusty?org_id=#{groupExternalId}&value='
               else 'http://fan-back-test.mail.yandex.net/api/organization/trusty?org_id=#{groupExternalId}&value='
               end,
           case
               -- https://wiki.yandex-team.ru/fan/arch/components/backend/api/#okruzhenija
               when (select (select value from environment where key = 'env') in ('prod', 'prestable'))
                   then 2026060
               else 2026062
               end
)
insert
into features(code, created_at, updated_at, system_tvm_id, type, description, system_name,
              activation_url_http_method, activation_url_template, set_amount_url_http_method,
              set_amount_url_template, deactivation_url_http_method, deactivation_url_template,
              call_set_amount_on_activation, call_set_amount_on_deactivation, activation_body_template,
              set_amount_body_template, deactivation_body_template, activation_content_type,
              deactivation_content_type, set_amount_content_type, error_processor_name)
SELECT 'fan_trusty',
       now(),
       now(),
       tvm_id,                         --f.system_tvm_id,
       'toggleable',
       'Флаг доверенной организации.', --f.description
       'fan',                          --f.system_name,
       'PUT',                          --f.activation_url_http_method,
       base_url || 'true',             --f.activation_url_template,
       null,                           --f.set_amount_url_http_method
       null,                           --f.set_amount_url_template,
       'PUT',                          --f.deactivation_url_http_method,
       base_url || 'false',            --f.deactivation_url_template,
       false,                          --f.call_set_amount_on_activation,
       false,                          --f.call_set_amount_on_deactivation,
       '',                             --f.activation_body_template,
       null,                           --f.set_amount_body_template,
       '',                             --f.deactivation_body_template,
       'application/json',             --f.activation_content_type,
       'application/json',             --f.deactivation_content_type,
       null,                           --f.set_amount_content_type,
       'default'                       --f.error_processor_name
from fan_info;

with trusty_products as
         (
             select *
             from (values ('org_mail_pro_premium1000'),
                          ('org_mail_pro_premium3000_wo_trial'),
                          ('org_mail_pro_premium3000'),
                          ('org_mail_pro_edu_premium1000'),
                          ('org_mail_pro_edu_premium3000')) s (group_product_code)
         )
insert
into product_features(user_product_id, feature_id, amount, created_at, description_tanker_key_id, enabled,
                      group_tanker_key_id, value_tanker_key_id, order_num, code, scope)
select distinct gp.user_product_id,
                (select id from features where code = 'fan_trusty'),
                1,
                now(),
                null::uuid,
                true, -- enabled
                (select id
                 from tanker_keys
                 where project = 'disk-ps-billing'
                   and key_set = 'features'
                   and key = 'mail_pro_b2c_group_disk'),
                null::uuid,
                999,
                'fan_trusty',
                'group'::feature_scope
from trusty_products pl
         join group_products gp on gp.code = pl.group_product_code;
