/* pgmigrate-encoding: utf-8 */

insert into promo_templates
(code, description, promo_name_tanker_key_id, from_date, to_date, application_area, application_type, duration,
 duration_measurement, activation_email_template_key, created_at)
values ('october_web_promo', '20% на все продукты в октябре', null,
        '2021-10-15T00:00:00.000+0300' AT TIME ZONE 'UTC', '2021-10-19T00:00:00.000+0300' AT TIME ZONE 'UTC',
        'global'::promo_application_area, 'multiple_time'::promo_application_type, null, null, null, now());

insert into promo_product_lines(promo_template_id, product_line_id)
VALUES ((select id from promo_templates where code = 'october_web_promo'),
        (select l.id
         from product_lines l
         where l.description = 'web 20% discount line'));


-- мобилы. отдельно, потому что есть баг с датой в мобилах MOBDISK-23958
insert
into promo_templates
(code, description, promo_name_tanker_key_id, from_date, to_date, application_area, application_type, duration,
 duration_measurement, activation_email_template_key, mobile_payload, created_at)
values ('october_mobile_promo', '-20% для мобильных в октябре',
    (select id from tanker_keys where key = 'september_end_mobile_promo'),
    '2021-10-15T00:00:00.000+0300' AT TIME ZONE 'UTC', '2021-10-18T23:59:59.000+0300' AT TIME ZONE 'UTC', -- двигаем дату на секунду назад, чтобы мобилы правильно отобразили дату конца акции
    'global'::promo_application_area, 'one_time'::promo_application_type, null, null, null,
    null, now());

insert into promo_product_lines(promo_template_id, product_line_id)
select pt.id, l.id
from promo_templates pt,
     product_lines l
where l.description in ('ios mail default line', 'android introductory line', 'ios disk default line')
  and pt.code = 'october_mobile_promo';
