/* pgmigrate-encoding: utf-8 */

select copy_products('mail_pro_b2c_premium1000_discount20_v20210610', 'discount20', 'discount50');

select change_price('mail_pro_b2c_premium1000_discount50_v20210610', 'month', 99, 50, 199, 'RUB');
select change_price('mail_pro_b2c_premium1000_discount50_v20210610', 'year', 699, 50, 1399, 'RUB');

select change_price('mail_pro_b2c_premium1000_discount50_v20210610', 'month', 0.99, 50, 2.49, 'USD');
select change_price('mail_pro_b2c_premium1000_discount50_v20210610', 'year', 9.49, 50, 18.99, 'USD');


update user_product_periods set trust_fiscal_title = replace(trust_fiscal_title, '(скидка -20%)', '(скидка -50%)')
where code like '%discount50%';


update product_lines
set order_num = order_num + 1
where order_num >= 1002
  and product_set_id = (select id from product_sets where key = 'mail_pro_b2c');


-- добавляем новую скидочную линейку и добавляем в нее созданные продукты
with promo_line_id as
         (
             insert into product_lines (product_set_id, created_at, order_num, selector_bean_el, description)
                 values ((select id from product_sets where key = 'mail_pro_b2c'), now(), 1002,
                         'productLineSelectorFactory.availableSelector()', 'halloween2021_web')
                 returning id
         ),
     order_num as
         (
             select code, order_num
             from (
                      values ('%standard100\_%', 1),
                             ('%premium1000\_%', 2),
                             ('%premium3000\_%', 3),
                             ('%premium5000\_%', 4),
                             ('%premium10000\_%', 5),
                             ('%premium25000\_%', 6),
                             ('%premium50000\_%', 7)
                  ) s(code, order_num)
         )

insert
into user_products_to_product_lines (product_line_id, user_product_id, order_num)
    (
        select promo_line_id.id, up.id, order_num
        from promo_line_id,
             user_products up
                 join order_num o on up.code like o.code
        where up.code like '%discount50%'
           or (up.code like '%discount30%' and up.code not like '%premium1000%discount30%') --here is error premium10000 also filtered out. Fix in V0214__halloween_web_promo_fix.sql
    );



insert into promo_templates
(code, description, promo_name_tanker_key_id, from_date, to_date, application_area, application_type, duration,
 duration_measurement, activation_email_template_key, created_at)
values ('halloween2021_web', 'Halloween 2021 для веба', null,
        '2021-10-25T09:00:00.000+0300' AT TIME ZONE 'UTC', '2021-11-01T00:00:00.000+0300' AT TIME ZONE 'UTC',
        'global'::promo_application_area, 'multiple_time'::promo_application_type, null, null, null, now());

insert into promo_product_lines(promo_template_id, product_line_id)
VALUES ((select id from promo_templates where code = 'halloween2021_web'),
        (select l.id
         from product_lines l
         where l.description = 'halloween2021_web'));


-- мобилы. отдельно, потому что есть баг с датой в мобилах MOBDISK-23958
with description_key as
         (
             insert into tanker_keys (created_at, project, key_set, key)
                 values (now(), 'disk-ps-billing', 'promos', 'halloween_mobile_promo_50') returning id
         )
insert
into promo_templates
(code, description, promo_name_tanker_key_id, from_date, to_date, application_area, application_type, duration,
 duration_measurement, activation_email_template_key, mobile_payload, created_at)
values ('halloween2021', 'Halloween 2021 для мобильных',
        (select id from description_key),
        '2021-10-25T09:00:00.000+0300' AT TIME ZONE 'UTC', '2021-10-31T23:59:59.000+0300' AT TIME ZONE 'UTC', -- двигаем дату на секунду назад, чтобы мобилы правильно отобразили дату конца акции
        'global'::promo_application_area, 'one_time'::promo_application_type, null, null, null,
        null, now());

insert into promo_product_lines(promo_template_id, product_line_id)
select pt.id, l.id
from promo_templates pt,
     product_lines l
where l.description in ('ios mail default line', 'android introductory line', 'ios disk default line')
  and pt.code = 'halloween2021';
