/* pgmigrate-encoding: utf-8 */
--add missed 10_000 tariff into hallowen_web product_line

with promo_line_id as
         (
             select id from product_lines where description = 'halloween2021_web'
         ),
     order_num as
         (
             select code, order_num
             from (
                      values ('%premium10000\_%', 5)
                  ) s(code, order_num)
         )

insert
into user_products_to_product_lines (product_line_id, user_product_id, order_num)
    (
        select promo_line_id.id, up.id, order_num
        from promo_line_id,
             user_products up
                 join order_num o on up.code like o.code
        where up.code like '%discount50%'
           or (up.code like '%discount30%' and up.code not like '%premium1000\_%discount30%')
    );
