/* pgmigrate-encoding: utf-8 */
-- https://st.yandex-team.ru/CHEMODAN-80534
-- add payload table for all clients

create type payload_type as enum ('mobile', 'disk', 'mail', 'web');

create table promo_payload (
    id UUID not null primary key default uuid_generate_v4(),
    promo_id UUID not null references promo_templates (id) on delete cascade,
    payload_type payload_type not null,
    content text not null,
    version int not null,
    created_at timestamp not null
);

create unique index promo_payload_index on promo_payload (promo_id, payload_type, version);

insert into promo_payload
    (promo_id, payload_type, content, version, created_at)
select
   id, 'mobile'::payload_type, mobile_payload, 0, now()
from promo_templates where mobile_payload is not null;
