/* pgmigrate-encoding: utf-8 */
--remove legacy function
drop function change_price(text, text, numeric, numeric, numeric);

select copy_products('mail_pro_b2c_standard100_discount20_v20210610', 'discount20', 'discount50');
select copy_products('mail_pro_b2c_premium3000_discount20_v20210610', 'discount20', 'discount50');

select change_price('mail_pro_b2c_standard100_discount50_v20210610', 'month', 34, 50, 69, 'RUB');
select change_price('mail_pro_b2c_standard100_discount50_v20210610', 'year', 249, 50, 499, 'RUB');
select change_price('mail_pro_b2c_premium3000_discount50_v20210610', 'month', 204, 50, 409, 'RUB');
select change_price('mail_pro_b2c_premium3000_discount50_v20210610', 'year', 1449, 50, 2899, 'RUB');


select change_price('mail_pro_b2c_standard100_discount50_v20210610', 'month', 0.49, 50, 1.49, 'USD');
select change_price('mail_pro_b2c_standard100_discount50_v20210610', 'year', 4.49, 50, 9.99, 'USD');
select change_price('mail_pro_b2c_premium3000_discount50_v20210610', 'month', 2.49, 50, 5.49, 'USD');
select change_price('mail_pro_b2c_premium3000_discount50_v20210610', 'year', 19.49, 50, 38.99, 'USD');


update user_product_periods set trust_fiscal_title = replace(trust_fiscal_title, '(скидка -20%)', '(скидка -50%)')
where code like '%discount50%';


update product_lines
set order_num = order_num + 1
where order_num >= 1002
  and product_set_id = (select id from product_sets where key = 'mail_pro_b2c');


-- добавляем новую скидочную линейку и добавляем в нее созданные продукты
with promo_line_id as
         (
insert into product_lines (product_set_id, created_at, order_num, selector_bean_el, description)
values ((select id from product_sets where key = 'mail_pro_b2c'), now(), 1002,
    'productLineSelectorFactory.availableSelector()', 'black_friday_web_2021')
    returning id
    ),
    order_num as
    (
select code, order_num
from (
    values ('%standard100\_%', 1),
    ('%premium1000\_%', 2),
    ('%premium3000\_%', 3),
    ('%premium5000\_%', 4),
    ('%premium10000\_%', 5),
    ('%premium25000\_%', 6),
    ('%premium50000\_%', 7)
    ) s(code, order_num)
    )

insert
into user_products_to_product_lines (product_line_id, user_product_id, order_num)
(
    select promo_line_id.id, up.id, order_num
    from promo_line_id,
    user_products up
    join order_num o on up.code like o.code
    where up.code in (
                      'mail_pro_b2c_standard100_discount50_v20210610',
                      'mail_pro_b2c_premium1000_discount50_v20210610',
                      'mail_pro_b2c_premium3000_discount50_v20210610',
                      'mail_pro_b2c_premium5000_v20210610',
                      'mail_pro_b2c_premium10000_v20210610',
                      'mail_pro_b2c_premium25000_v20210813',
                      'mail_pro_b2c_premium50000_v20210813'
        )
);


insert into promo_templates
(code, description, promo_name_tanker_key_id, from_date, to_date, application_area, application_type, duration,
 duration_measurement, activation_email_template_key, created_at)
values ('black_friday_web_2021', 'Черная пятница 2021 для веба', null,
        '2021-11-22T09:00:00.000+0300' AT TIME ZONE 'UTC', '2021-11-30T00:00:00.000+0300' AT TIME ZONE 'UTC',
        'global'::promo_application_area, 'multiple_time'::promo_application_type, null, null, null, now());


insert into promo_product_lines(promo_template_id, product_line_id)
VALUES ((select id from promo_templates where code = 'black_friday_web_2021'),
        (select l.id
         from product_lines l
         where l.description = 'black_friday_web_2021'));


-- мобилы. отдельно, потому что есть баг с датой в мобилах MOBDISK-23958
with description_key as
         (
insert into tanker_keys (created_at, project, key_set, key)
values (now(), 'disk-ps-billing', 'promos', 'black_friday_promo') returning id
    )
insert
into promo_templates
(code, description, promo_name_tanker_key_id, from_date, to_date, application_area, application_type, duration,
 duration_measurement, activation_email_template_key, mobile_payload, created_at)
values ('black_friday_mobile_2021', 'Черная пятница 2021 для мобильных',
    (select id from description_key),
    '2021-11-22T09:00:00.000+0300' AT TIME ZONE 'UTC', '2021-11-29T23:59:59.000+0300' AT TIME ZONE 'UTC', -- двигаем дату на секунду назад, чтобы мобилы правильно отобразили дату конца акции
    'global'::promo_application_area, 'one_time'::promo_application_type, null, null, null,
    null, now());

insert into promo_product_lines(promo_template_id, product_line_id)
select pt.id, l.id
from promo_templates pt,
     product_lines l
where l.description in ('ios mail default line', 'android introductory line', 'ios disk default line')
  and pt.code = 'black_friday_mobile_2021';
