/* pgmigrate-encoding: utf-8 */

update product_lines set order_num = 500 where product_set_id = (select id from product_sets where key = 'mail_pro_b2b') and order_num = 2;
update product_lines set order_num = 400 where product_set_id = (select id from product_sets where key = 'mail_pro_b2b') and order_num = 1;

insert into tanker_keys
    (created_at, project, key_set, key)
values
    (now(), 'disk-ps-billing', 'features', 'simultaneous_editing_10'),
    (now(), 'disk-ps-billing', 'features', 'simultaneous_editing_40'),
    (now(), 'disk-ps-billing', 'features', 'unlimit_telemost_meeting');

insert into product_lines
    (product_set_id, created_at, order_num, selector_bean_el, description)
values
    ((select id from product_sets where key = 'mail_pro_b2b'), now(), 200, 'productLineSelectorFactory.prepaidSelector()', 'prepaid for b2b 360'),
    ((select id from product_sets where key = 'mail_pro_b2b'), now(), 100, 'productLineSelectorFactory.compositeAndSelector(productLineSelectorFactory.prepaidSelector(), productLineSelectorFactory.educationalGroupProductSelector())', 'edu prepaid for b2b 360');

create function pg_temp.create_product(
    a_product varchar,
    a_price int,
    a_product_order int,
    a_space bigint,
    a_space_description_tanker_key varchar,
    a_simultaneous_editing_description_tanker_key varchar,
    a_space_value_tanker_key varchar,
    a_fan_mail_limit int
) returns void as
$$
declare
    v_code varchar;
    v_edu_code varchar;
    v_user_product_id uuid;
    v_edu_user_product_id uuid;
    v_group_disk_tanker_id uuid;
    v_group_mail_tanker_id uuid;
begin
    v_code = concat('prepaid_org_mail_pro_', a_product);
    v_edu_code = concat('prepaid_org_mail_pro_edu_', a_product);

    insert into product_templates
        (code, created_at)
    values
        (v_code, now()),
        (v_edu_code, now());

    insert into tanker_keys
        (created_at, project, key_set, key)
    values
        (now(), 'disk-ps-billing', 'products', v_code),
        (now(), 'disk-ps-billing', 'products', v_edu_code);

    insert into user_products
        (code, created_at, updated_at, title_tanker_key_id, product_owner_id, available_from, billing_type, trust_subs_retry_charging_limit, trust_subs_retry_charging_delay, trust_subs_grace_period, trust_service_id, trial_definition_id, code_family, product_template_id)
    values
        (v_code, now(), now(), (select id from tanker_keys where project = 'disk-ps-billing' and key_set = 'products' and key = v_code), (select id from product_owners where code = 'yandex_mail'), null, 'group', null, null, null, null, null, v_code, (select id from product_templates where code = v_code)),
        (v_edu_code, now(), now(), (select id from tanker_keys where project = 'disk-ps-billing' and key_set = 'products' and key = v_edu_code), (select id from product_owners where code = 'yandex_mail'), null, 'group', null, null, null, null, null, v_edu_code, (select id from product_templates where code = v_edu_code));

    insert into group_products
        (code, created_at, updated_at, user_product_id, balance_product_name, price, currency, singleton, trial_definition_id, available_to, title_tanker_key_id, payment_type)
    values
        (v_code, now(), now(), (select id from user_products where code = v_code), 'mail_b2b', a_price, 'RUB', True, null, null, (select id from tanker_keys where project = 'disk-ps-billing' and key_set = 'products' and key = v_code), 'prepaid'::payment_type),
        (v_edu_code, now(), now(), (select id from user_products where code = v_edu_code), 'mail_b2b', a_price / 2, 'RUB', True, null, null, (select id from tanker_keys where project = 'disk-ps-billing' and key_set = 'products' and key = v_edu_code), 'prepaid'::payment_type);

    insert into bucket_content
        (bucket_code, group_product_id, updated_at)
    values
        ('group1', (select id from group_products where code = v_code), now()),
        ('group1', (select id from group_products where code = v_edu_code), now()),
        ('group2', (select id from group_products where code = v_code), now()),
        ('group2', (select id from group_products where code = v_edu_code), now());

    insert into group_products_to_product_lines
        (product_line_id, group_product_id, order_num)
    values
        ((select id from product_lines where description = 'prepaid for b2b 360'), (select id from group_products where code = v_code), a_product_order),
        ((select id from product_lines where description = 'edu prepaid for b2b 360'), (select id from group_products where code = v_edu_code), a_product_order);

    v_user_product_id = (select id from user_products where code = v_code);
    v_edu_user_product_id = (select id from user_products where code = v_edu_code);

    v_group_disk_tanker_id = (select id from tanker_keys where project = 'disk-ps-billing' and key_set = 'features' and key = 'mail_pro_b2c_group_disk');
    v_group_mail_tanker_id = (select id from tanker_keys where project = 'disk-ps-billing' and key_set = 'features' and key = 'mail_pro_b2c_group_mail_service');

    insert into product_features
        (user_product_id, feature_id, amount, created_at, description_tanker_key_id, group_tanker_key_id, value_tanker_key_id, enabled, order_num, code, scope)
    values
        -- место на диске
        (v_user_product_id,      (select id from features where code = 'mpfs_disk_space_for_b2b_mail_360'), a_space, now(),  (select id from tanker_keys where project = 'sarah' and key_set = 'products' and key = a_space_description_tanker_key), v_group_disk_tanker_id, (select id from tanker_keys where project = 'disk-ps-billing' and key_set = 'features' and key = a_space_value_tanker_key), True, 10, 'mpfs_disk_space_for_b2b_mail_360', 'user'),
        (v_edu_user_product_id,  (select id from features where code = 'mpfs_disk_space_for_b2b_mail_360'), a_space, now(),  (select id from tanker_keys where project = 'sarah' and key_set = 'products' and key = a_space_description_tanker_key), v_group_disk_tanker_id, (select id from tanker_keys where project = 'disk-ps-billing' and key_set = 'features' and key = a_space_value_tanker_key), True, 10, 'mpfs_disk_space_for_b2b_mail_360', 'user'),

        -- одновременное редактирование документов
        (v_user_product_id,      null, 1, now(), (select id from tanker_keys where project = 'disk-ps-billing' and key_set = 'features' and key = a_simultaneous_editing_description_tanker_key), v_group_disk_tanker_id, null, True, 20, 'simultaneous_editing', 'user'),
        (v_edu_user_product_id,  null, 1, now(), (select id from tanker_keys where project = 'disk-ps-billing' and key_set = 'features' and key = a_simultaneous_editing_description_tanker_key), v_group_disk_tanker_id, null, True, 20, 'simultaneous_editing', 'user'),

        -- максимальное количество участников в телемосте
        (v_user_product_id,      null, 1, now(), (select id from tanker_keys where project = 'disk-ps-billing' and key_set = 'features' and key = 'unlimit_telemost_meeting'), v_group_disk_tanker_id, null, True, 30, 'unlimit_telemost_meeting', 'user'),
        (v_edu_user_product_id,  null, 1, now(), (select id from tanker_keys where project = 'disk-ps-billing' and key_set = 'features' and key = 'unlimit_telemost_meeting'), v_group_disk_tanker_id, null, True, 30, 'unlimit_telemost_meeting', 'user'),

        -- без рекламы
        (v_user_product_id,      (select id from features where code = 'mail_ad_disabled'), 1, now(), (select id from tanker_keys where project = 'disk-ps-billing' and key_set = 'features' and key = 'mail_pro_b2c_advertise_free'), v_group_mail_tanker_id, null, True, 40, 'mail_ad_disabled', 'user'),
        (v_edu_user_product_id,  (select id from features where code = 'mail_ad_disabled'), 1, now(), (select id from tanker_keys where project = 'disk-ps-billing' and key_set = 'features' and key = 'mail_pro_b2c_advertise_free'), v_group_mail_tanker_id, null, True, 40, 'mail_ad_disabled', 'user'),

        -- приоритетная поддержка
        (v_user_product_id,      (select id from features where code = 'mail_priority_support'), 1, now(), (select id from tanker_keys where project = 'disk-ps-billing' and key_set = 'features' and key = 'priority_support'), v_group_disk_tanker_id, null, True, 50, 'mail_priority_support', 'user'),
        (v_edu_user_product_id,  (select id from features where code = 'mail_priority_support'), 1, now(), (select id from tanker_keys where project = 'disk-ps-billing' and key_set = 'features' and key = 'priority_support'), v_group_disk_tanker_id, null, True, 50, 'mail_priority_support', 'user'),

        -- общие для b2b
        (v_user_product_id,      (select id from features where code = 'datasync_ro_no_b2c_tariff_promo'), 1, now(), null, null, null, True, 999, 'datasync_ro_no_b2c_tariff_promo', 'user'),
        (v_edu_user_product_id,  (select id from features where code = 'datasync_ro_no_b2c_tariff_promo'), 1, now(), null, null, null, True, 999, 'datasync_ro_no_b2c_tariff_promo', 'user'),
        (v_user_product_id,      (select id from features where code = 'ro_no_b2c_tariff_promo'), 1, now(), null, null, null, True, 999, 'ro_no_b2c_tariff_promo', 'user'),
        (v_edu_user_product_id,  (select id from features where code = 'ro_no_b2c_tariff_promo'), 1, now(), null, null, null, True, 999, 'ro_no_b2c_tariff_promo', 'user'),
        (v_user_product_id,      (select id from features where code = 'datasync_ro_no_yandex_jobs'), 1, now(), null, null, null, True, 999, 'datasync_ro_no_yandex_jobs', 'user'),
        (v_edu_user_product_id,  (select id from features where code = 'datasync_ro_no_yandex_jobs'), 1, now(), null, null, null, True, 999, 'datasync_ro_no_yandex_jobs', 'user'),
        (v_user_product_id,      (select id from features where code = 'ro_no_yandex_jobs'), 1, now(), null, null, null, True, 999, 'ro_no_yandex_jobs', 'user'),
        (v_edu_user_product_id,  (select id from features where code = 'ro_no_yandex_jobs'), 1, now(), null, null, null, True, 999, 'ro_no_yandex_jobs', 'user'),
        (v_user_product_id,      (select id from features where code = 'mail_smart_enabled'), 1, now(), null, null, null, True, 999, 'mail_smart_enabled', 'user'),
        (v_edu_user_product_id,  (select id from features where code = 'mail_smart_enabled'), 1, now(), null, null, null, True, 999, 'mail_smart_enabled', 'user'),
        (v_user_product_id,      (select id from features where code = 'only_office_enabled'), 1, now(), null, null, null, True, 999, 'only_office_enabled', 'user'),
        (v_edu_user_product_id,  (select id from features where code = 'only_office_enabled'), 1, now(), null, null, null, True, 999, 'only_office_enabled', 'user'),
        (v_user_product_id,      (select id from features where code = 'sid_122'), 1, now(), null, null, null, True, 999, 'sid_122', 'user'),
        (v_edu_user_product_id,  (select id from features where code = 'sid_122'), 1, now(), null, null, null, True, 999, 'sid_122', 'user'),
        (v_user_product_id,      (select id from features where code = 'sid_123'), 1, now(), null, null, null, True, 999, 'sid_123', 'user'),
        (v_edu_user_product_id,  (select id from features where code = 'sid_123'), 1, now(), null, null, null, True, 999, 'sid_123', 'user');

    if a_fan_mail_limit != 1500 then
        insert into product_features
            (user_product_id, feature_id, amount, created_at, description_tanker_key_id, group_tanker_key_id, value_tanker_key_id, enabled, order_num, code, scope)
        values
            (v_user_product_id,      (select id from features where code = 'fan_mail_limit'), a_fan_mail_limit, now(), null, null, null, True, 999, 'fan_mail_limit', 'group'),
            (v_edu_user_product_id,  (select id from features where code = 'fan_mail_limit'), a_fan_mail_limit, now(), null, null, null, True, 999, 'fan_mail_limit', 'group'),
            (v_user_product_id,      (select id from features where code = 'fan_trusty'), 1, now(), null, null, null, True, 999, 'fan_trusty', 'group'),
            (v_edu_user_product_id,  (select id from features where code = 'fan_trusty'), 1, now(), null, null, null, True, 999, 'fan_trusty', 'group');
    end if;

end $$ language plpgsql;

select pg_temp.create_product(
    'standard100',
    150,
    1,
    107374182400, -- 100gb
    'features-100gb-disk-title',
    'simultaneous_editing_10',
    'mail_pro_add_100gb',
    1500
);
select pg_temp.create_product(
    'optimal1000',
    300,
    1,
    1099511627776, -- 1tb
    'features-1tb-disk-title',
    'simultaneous_editing_40',
    'mail_pro_add_3tb',
    50000
);
select pg_temp.create_product(
    'advanced3000',
    800,
    1,
    3298534883328, -- 3tb
    'features-3tb-disk-title',
    'simultaneous_editing_40',
    'mail_pro_add_3tb',
    50000
);
