/* pgmigrate-encoding: utf-8 */

alter table user_product_prices
    add start_period_price numeric;

create type duration_measurement as enum ('year',
    'month',
    'week',
    'day',
    'hour',
    '10minutes', --for_test_purposes_only
    'minute',
    'second'
    );

alter table user_product_periods
    add start_period_discount_duration_measurement duration_measurement,
    add start_period_discount_duration_length      numeric,
    add start_period_count                         numeric;



--helper function to setup start period discount
create or replace FUNCTION setup_start_discount(product_code text, period_code text, currencyVal text,
                                                start_period_duration_unit duration_measurement,
                                                start_period_length numeric, start_period_countVal numeric,
                                                start_price numeric)
    RETURNS int
    LANGUAGE plpgsql AS
$function$
BEGIN
    update user_product_periods upp
    set start_period_count                         = start_period_countVal,
        start_period_discount_duration_length      = start_period_length,
        start_period_discount_duration_measurement = start_period_duration_unit
    where id in (
        select upp.id
        from user_products up
                 join user_product_periods upp on up.id = upp.user_product_id
                 join user_product_prices u on upp.id = u.user_product_period_id
        where up.code = product_code
          and upp.period = period_code
    );
    update user_product_prices
    set start_period_price = start_price
    where id = (select u.id
                from user_products up
                         join user_product_periods upp on up.id = upp.user_product_id
                         join user_product_prices u on upp.id = u.user_product_period_id
                where up.code = product_code
                  and upp.period = period_code
                  and u.currency = currencyVal);
    RETURN 0;
END
$function$;

--update copy products for correct work with start period discount
CREATE OR REPLACE FUNCTION copy_products(where_clause text, code_replace_from text, code_replace_to text)
    RETURNS int
    LANGUAGE plpgsql AS
$function$
BEGIN
    create table product_map
    (
        old_id   uuid,
        old_code text,
        new_id   uuid,
        new_code text
    );

    insert into product_map (old_id, old_code, new_id, new_code)
    select distinct up.id                                                as old_id,
                    up.code                                              as old_code,
                    null::uuid                                           as new_id,
                    replace(up.code, code_replace_from, code_replace_to) as new_code
    from user_products up
    where up.code like where_clause;

-- копируем продукты
    insert
    into user_products(code, code_family, created_at, updated_at, title_tanker_key_id, is_best_offer, product_owner_id,
                       available_from, billing_type, allow_auto_prolong, trust_subs_retry_charging_limit,
                       trust_subs_retry_charging_delay, trust_subs_grace_period, singleton, trust_service_id,
                       trial_definition_id, product_template_id)
    select distinct pm.new_code,
                    up.code_family,
                    now(),
                    now(),
                    up.title_tanker_key_id,
                    up.is_best_offer,
                    up.product_owner_id,
                    up.available_from,
                    up.billing_type,
                    up.allow_auto_prolong,
                    up.trust_subs_retry_charging_limit,
                    up.trust_subs_retry_charging_delay,
                    up.trust_subs_grace_period,
                    up.singleton,
                    up.trust_service_id,
                    up.trial_definition_id,
                    up.product_template_id
    from user_products up
             join product_map pm on pm.old_id = up.id;

    -- обновляем айди продуктов в мапе
-- noinspection SqlWithoutWhere
    update product_map
    set new_id = (select id from user_products up where up.code = new_code);

-- копируем фичи продуков
    insert into product_features (user_product_id, feature_id, amount, created_at, description_tanker_key_id,
                                  group_tanker_key_id,
                                  value_tanker_key_id, enabled, order_num, code, scope)
    select pm.new_id,
           feature_id,
           amount,
           now(),
           description_tanker_key_id,
           group_tanker_key_id,
           value_tanker_key_id,
           enabled,
           order_num,
           code,
           scope
    from product_features pf
             join product_map pm on pm.old_id = pf.user_product_id;

-- копируем периоды
    insert
    into user_product_periods (user_product_id, period, code, trust_fiscal_title, created_at, package_name,
                               start_period_discount_duration_measurement, start_period_count,
                               start_period_discount_duration_length)
    select pm.new_id,
           upp.period,
           replace(upp.code, pm.old_code, pm.new_code),
           upp.trust_fiscal_title,
           now(),
           upp.package_name,
           start_period_discount_duration_measurement,
           start_period_count,
           start_period_discount_duration_length
    from user_product_periods upp
             join product_map pm on pm.old_id = upp.user_product_id;

-- копируем цены
    insert
    into user_product_prices (created_at, region_id, price, currency, display_discount_percent, display_original_price,
                              user_product_period_id, start_period_price)

    select now(),
           upp.region_id,
           upp.price,
           upp.currency,
           upp.display_discount_percent,
           upp.display_original_price,
           newp.id,
           upp.start_period_price
    from user_product_prices upp
             join user_product_periods p on upp.user_product_period_id = p.id
             join product_map pm on pm.old_id = p.user_product_id
             join user_product_periods newp on newp.user_product_id = pm.new_id and newp.period = p.period;

    drop table product_map;
    RETURN 0;
END
$function$;


select copy_products('mail_pro_b2c_premium1000_v20210610', 'mail_pro_b2c_premium1000_v20210610', 'stat_period_test'),
       setup_start_discount('stat_period_test', 'month', 'RUB', 'month', 1, 1, 10),
       setup_start_discount('stat_period_test', 'month', 'USD', 'month', 1, 1, 0.15),
       setup_start_discount('stat_period_test', 'year', 'RUB', 'year', 1, 1, 100),
       setup_start_discount('stat_period_test', 'year', 'USD', 'year', 1, 1, 1.5)
where exists(SELECT *
             from environment
             where key = 'env'
               and value in ('test', 'prestable'));

insert into user_products_to_product_lines
    (product_line_id, order_num, user_product_id)
    (select product_line_id,
            max(order_num) + 1                                             as order_num,
            (select id from user_products where code = 'stat_period_test') as user_product_id
     from user_products_to_product_lines
     where product_line_id = (
         select product_line_id
         from user_products_to_product_lines
         where user_product_id = (select id from user_products where code = 'mail_pro_b2c_premium1000_v20210610')
     )
       and exists(SELECT *
                  from environment
                  where key = 'env'
                    and value in ('test', 'prestable'))
     group by product_line_id
    );

select copy_products('mail_pro_b2c_premium1000_v20210610', 'mail_pro_b2c_premium1000_v20210610',
                     'stat_period_test_1_5'),
       setup_start_discount('stat_period_test_1_5', 'month', 'RUB', 'month', 1, 5, 10),
       setup_start_discount('stat_period_test_1_5', 'year', 'RUB', 'year', 1, 5, 100),
       setup_start_discount('stat_period_test_1_5', 'month', 'USD', 'month', 1, 5, 0.15),
       setup_start_discount('stat_period_test_1_5', 'year', 'USD', 'year', 1, 5, 1.5)
where exists(SELECT *
             from environment
             where key = 'env'
               and value in ('test', 'prestable'));

select copy_products('mail_pro_b2c_premium1000_v20210610', 'mail_pro_b2c_premium1000_v20210610',
                     'stat_period_test_4_1' ||
                     ''),
       setup_start_discount('stat_period_test_4_1', 'month', 'RUB', 'month', 4, 1, 10),
       setup_start_discount('stat_period_test_4_1', 'year', 'RUB', 'year', 4, 1, 100),
       setup_start_discount('stat_period_test_4_1', 'month', 'USD', 'month', 4, 1, 0.15),
       setup_start_discount('stat_period_test_4_1', 'year', 'USD', 'year', 4, 1, 1.5)
where exists(SELECT *
             from environment
             where key = 'env'
               and value in ('test', 'prestable'));

insert into user_products_to_product_lines
(product_line_id, order_num, user_product_id)
    (select product_line_id,
            max(order_num) + 1                                                 as order_num,
            (select id from user_products where code = 'stat_period_test_1_5') as user_product_id
     from user_products_to_product_lines
     where product_line_id = (
         select product_line_id
         from user_products_to_product_lines
         where user_product_id = (select id from user_products where code = 'mail_pro_b2c_premium1000_v20210610')
     )
       and exists(SELECT *
                  from environment
                  where key = 'env'
                    and value in ('test', 'prestable'))
     group by product_line_id
    );

insert into user_products_to_product_lines
(product_line_id, order_num, user_product_id)
    (select product_line_id,
            max(order_num) + 1                                                 as order_num,
            (select id from user_products where code = 'stat_period_test_4_1') as user_product_id
     from user_products_to_product_lines
     where product_line_id = (
         select product_line_id
         from user_products_to_product_lines
         where user_product_id = (select id from user_products where code = 'mail_pro_b2c_premium1000_v20210610')
     )
       and exists(SELECT *
                  from environment
                  where key = 'env'
                    and value in ('test', 'prestable'))
     group by product_line_id
    );

