/* pgmigrate-encoding: utf-8 */

insert into promo_templates
(code, description, promo_name_tanker_key_id, from_date, to_date, application_area, application_type, duration,
 duration_measurement, activation_email_template_key, created_at)
values ('new_year_web_2022', '30% на все продукты новый год 2022', null,
        '2021-12-20T00:00:00.000+0300' AT TIME ZONE 'UTC', '2022-01-10T00:00:00.000+0300' AT TIME ZONE 'UTC',
        'global'::promo_application_area, 'multiple_time'::promo_application_type, null, null, null, now());

insert into promo_product_lines(promo_template_id, product_line_id)
VALUES ((select id from promo_templates where code = 'new_year_web_2022'),
        (select l.id
         from product_lines l
         where l.description = 'web 30% discount line'));

insert into promo_payload (promo_id, payload_type, version, created_at, content)
select id, 'web'::payload_type, 0, now(), '
{
 "text_tanker": { "tanker_project": "front-ps-tuning", "tanker_key_set": "new-year-2022", "tanker_key": "promo-title" },
 "background": "https://yastatic.net/s3/disk/promo/new-year-2022/tuning/background-image.jpg",
 "illustration": "https://yastatic.net/s3/disk/promo/new-year-2022/tuning/grid-promo.png",
 "theme": "dark",
 "link": "https://360x2022.yandex?from=tuning"
}
'
 from promo_templates where code = 'new_year_web_2022';

insert into promo_payload (promo_id, payload_type, version, created_at, content)
select id, 'disk'::payload_type, 0, now(), '
{
 "info_space_block": {
   "text_tanker": { "tanker_project": "yandex_disk_web", "tanker_key_set": "view-ads", "tanker_key": "ufo_ads__new_year_2022_discount_text" },
   "background": "https://yastatic.net/s3/disk/promo/new-year-2022/disk/info-space-block/background-image.png",
   "imgSmallUrl": "https://yastatic.net/s3/disk/promo/new-year-2022/disk/info-space-block/small-image.png",
   "imgUrl": "https://yastatic.net/s3/disk/promo/new-year-2022/disk/info-space-block/main-image.png"
 },
 "tooltip": {
  "text_field_tanker": { "tanker_project": "yandex_disk_web", "tanker_key_set": "view-subscription-onboarding", "tanker_key": "ufo_subscription_new_year_2022_tooltip" },
  "img": "https://yastatic.net/s3/disk/promo/new-year-2022/disk/discount-tooltip/illustration.png",
  "width": "90",
  "height": "90",
  "leftOffset": "-50",
  "bottomOffset": "-36"
 },
 "onboarding": {
     "title_tanker": { "tanker_project": "yandex_disk_web", "tanker_key_set": "view-subscription-onboarding", "tanker_key": "ufo_subscription_onboarding_heading_NY2022" },
     "benefits": [
                    {
                        "text_tanker": { "tanker_project": "yandex_disk_web", "tanker_key_set": "view-subscription-onboarding", "tanker_key": "ufo_subscription_onboarding_benefit_mobileVideo_NY2022" },
                        "type": "mobileVideo"
                    },
                    {
                        "text_tanker": { "tanker_project": "yandex_disk_web", "tanker_key_set": "view-subscription-onboarding", "tanker_key": "ufo_subscription_onboarding_benefit_ads_NY2022" },
                        "type": "ads"
                    },
                    {
                        "text_tanker": { "tanker_project": "yandex_disk_web", "tanker_key_set": "view-subscription-onboarding", "tanker_key": "ufo_subscription_onboarding_benefit_domain_BF" },
                        "type": "domain"
                    }
                ],
       "background": "https://yastatic.net/s3/disk/promo/new-year-2022/disk/onboarding/background-image.jpg",
       "illustration": "https://yastatic.net/s3/disk/promo/new-year-2022/disk/onboarding/illustration-image.png"
  }
}
'
from promo_templates where code = 'new_year_web_2022';

-- мобилы. отдельно, потому что есть баг с датой в мобилах MOBDISK-23958
with description_key as
         (
             insert into tanker_keys (created_at, project, key_set, key)
                 values (now(), 'disk-ps-billing', 'promos', 'december_mobile_promo') returning id
         )

insert
into promo_templates
(code, description, promo_name_tanker_key_id, from_date, to_date, application_area, application_type, duration,
 duration_measurement, activation_email_template_key, mobile_payload, created_at)
values ('new_year_mobile_2022', '30% на мобилы новый год 2022',
        (select id from description_key),
        '2021-12-20T00:00:00.000+0300' AT TIME ZONE 'UTC', '2022-01-09T23:59:59.000+0300' AT TIME ZONE 'UTC', -- двигаем дату на секунду назад, чтобы мобилы правильно отобразили дату конца акции
        'global'::promo_application_area, 'one_time'::promo_application_type, null, null, null,
        null, now());

insert into promo_product_lines(promo_template_id, product_line_id)
select pt.id, l.id
from promo_templates pt,
     product_lines l
where l.description in ('ios mail default line', 'android introductory line', 'ios disk default line')
  and pt.code = 'new_year_mobile_2022';

insert into promo_payload (promo_id, payload_type, version, created_at, content)
select id, 'mobile'::payload_type, 0, now(), '
[
  {
    "version": 1,
    "currency": "rub",
    "platform": "*",
    "owner": "disk",
    "disk_space_block": {
      "tooltip_text_tanker": {
        "tanker_project": "disk-ps-billing",
        "tanker_key_set": "promos",
        "tanker_key": "disk_mobile_tooltip_rub"
      }
    },
    "promo_page": {
      "title_tanker": {
        "tanker_project": "disk-ps-billing",
        "tanker_key_set": "promos",
        "tanker_key": "disk_mobile_purchases_title_rub"
      }
    },
    "onboarding": {
      "first": {
        "title_tanker": {
          "tanker_project": "disk-ps-billing",
          "tanker_key_set": "promos",
          "tanker_key": "disk_mobile_onboarding_title_rub"
        },
        "description_tanker": {
          "tanker_project": "disk-ps-billing",
          "tanker_key_set": "promos",
          "tanker_key": "disk_mobile_onboarding_text_rub"
        },
        "button_text_tanker": {
          "tanker_project": "disk-ps-billing",
          "tanker_key_set": "promos",
          "tanker_key": "disk_mobile_onboarding_button_rub"
        }
      }
    }
  },
  {
    "version": 1,
    "currency": "rub",
    "platform": "*",
    "owner": "mail",
    "promo_page": {
      "title_tanker": {
        "tanker_project": "disk-ps-billing",
        "tanker_key_set": "promos",
        "tanker_key": "mail_mobile_purchases_title_rub"
      }
    },
    "onboarding": {
      "first": {
        "title_tanker": {
          "tanker_project": "disk-ps-billing",
          "tanker_key_set": "promos",
          "tanker_key": "mail_mobile_onboarding_title_rub"
        },
        "description_tanker": {
          "tanker_project": "disk-ps-billing",
          "tanker_key_set": "promos",
          "tanker_key": "mail_mobile_onboarding_text_rub"
        },
        "button_text_tanker": {
          "tanker_project": "disk-ps-billing",
          "tanker_key_set": "promos",
          "tanker_key": "mail_mobile_onboarding_button_rub"
        }
      }
    }
  },
  {
    "version": 1,
    "currency": "*",
    "platform": "*",
    "owner": "disk",
    "disk_space_block": {
      "tooltip_text_tanker": {
        "tanker_project": "disk-ps-billing",
        "tanker_key_set": "promos",
        "tanker_key": "disk_mobile_tooltip_default"
      }
    },
    "promo_page": {
      "title_tanker": {
        "tanker_project": "disk-ps-billing",
        "tanker_key_set": "promos",
        "tanker_key": "disk_mobile_purchases_title_default"
      }
    },
    "onboarding": {
      "first": {
        "title_tanker": {
          "tanker_project": "disk-ps-billing",
          "tanker_key_set": "promos",
          "tanker_key": "disk_mobile_onboarding_title_default"
        },
        "description_tanker": {
          "tanker_project": "disk-ps-billing",
          "tanker_key_set": "promos",
          "tanker_key": "disk_mobile_onboarding_text_default"
        },
        "button_text_tanker": {
          "tanker_project": "disk-ps-billing",
          "tanker_key_set": "promos",
          "tanker_key": "disk_mobile_onboarding_button_default"
        }
      }
    }
  },
  {
    "version": 1,
    "currency": "*",
    "platform": "*",
    "owner": "mail",
    "promo_page": {
      "title_tanker": {
        "tanker_project": "disk-ps-billing",
        "tanker_key_set": "promos",
        "tanker_key": "mail_mobile_purchases_title_default"
      }
    },
    "onboarding": {
      "first": {
        "title_tanker": {
          "tanker_project": "disk-ps-billing",
          "tanker_key_set": "promos",
          "tanker_key": "mail_mobile_onboarding_title_default"
        },
        "description_tanker": {
          "tanker_project": "disk-ps-billing",
          "tanker_key_set": "promos",
          "tanker_key": "mail_mobile_onboarding_text_default"
        },
        "button_text_tanker": {
          "tanker_project": "disk-ps-billing",
          "tanker_key_set": "promos",
          "tanker_key": "mail_mobile_onboarding_button_default"
        }
      }
    }
  }
]
'
from promo_templates where code = 'new_year_mobile_2022';
