-- https://st.yandex-team.ru/PSBTBSUP-1143 add trial to org 5963687

with lost_trial_period as (
    select gspo.end_date - gs.target_updated_at as timespan
    from groups g
             join group_services gs on g.id = gs.group_id
             join group_service_price_overrides gspo on gs.id = gspo.group_service_id
    where 1 = 1
      and g.group_external_id = '5963687'
      and gs.id = 'fdc2c59d-6afa-4db4-b197-499fbc855abf'
)
insert
into group_service_price_overrides
(group_service_id, created_at, price, start_date, end_date, trial_usage_id, reason, hidden)
select gs.id                                            as group_service_id,
       now()                                            as created_at,
       0                                                as price,
       now()                                            as start_date,
       now() + (select timespan from lost_trial_period) as end_date,
       null                                             as trial_usage_id,
       'gift'                                           as reason,
       false                                            as hidden
from group_services gs,
     environment env
where id = '0dd9a76c-d013-4b6a-8e68-825e0013fea5'
  and env.key = 'env'
  and env.value = 'prod'
