/* pgmigrate-encoding: utf-8 */

-- копируем продукты, выставляем параметры скидки
select copy_products('mail_pro_b2c_standard100_v20210610','mail_pro_b2c_standard100_v20210610','mail_pro_b2c_standard100_start_discount_3m');
select setup_start_discount('mail_pro_b2c_standard100_start_discount_3m', 'year', 'RUB', 'month', 3, 1, 49);
select setup_start_discount('mail_pro_b2c_standard100_start_discount_3m', 'year', 'USD', 'month', 3, 1, 0.99);

select copy_products('mail_pro_b2c_premium1000_v20210610','mail_pro_b2c_premium1000_v20210610','mail_pro_b2c_premium1000_start_discount_3m');
select setup_start_discount('mail_pro_b2c_premium1000_start_discount_3m', 'year', 'RUB', 'month', 3, 1, 129);
select setup_start_discount('mail_pro_b2c_premium1000_start_discount_3m', 'year', 'USD', 'month', 3, 1, 1.99);

select copy_products('mail_pro_b2c_premium3000_v20210610','mail_pro_b2c_premium3000_v20210610','mail_pro_b2c_premium3000_start_discount_3m');
select setup_start_discount('mail_pro_b2c_premium3000_start_discount_3m', 'year', 'RUB', 'month', 3, 1, 269);
select setup_start_discount('mail_pro_b2c_premium3000_start_discount_3m', 'year', 'USD', 'month', 3, 1, 3.99);

-- на время акции best offer - 100 ГБ
update user_products
set is_best_offer = true
where code = 'mail_pro_b2c_standard100_start_discount_3m';

update user_products
set is_best_offer = false
where code = 'mail_pro_b2c_premium1000_start_discount_3m';

-- двигаем остальные скидочные линейки
update product_lines
set order_num = order_num + 1
where order_num >= 1002
  and product_set_id = (select id from product_sets where key = 'mail_pro_b2c');

-- добавляем новую скидочную линейку и добавляем в нее созданные продукты
-- остальные продукты копируем из линейки 'web default line'
with promo_line_id as
         (
             insert into product_lines (product_set_id, created_at, order_num, selector_bean_el, description)
                 values ((select id from product_sets where key = 'mail_pro_b2c'), now(), 1002,
                         'productLineSelectorFactory.availableSelector()', 'web start discount 3 months')
                 returning id
         ),
     order_num as
         (
             select code, order_num
             from (
                      values ('%standard100\_%', 1),
                             ('%premium1000\_%', 2),
                             ('%premium3000\_%', 3),
                             ('%premium5000\_%', 4),
                             ('%premium10000\_%', 5),
                             ('%premium25000\_%', 6),
                             ('%premium50000\_%', 7)
                  ) s(code, order_num)
         )
insert into user_products_to_product_lines
    (product_line_id, user_product_id, order_num)
    (
        select promo_line_id.id, up.id, order_num
        from promo_line_id,
             user_products up
                 join order_num o on up.code like o.code
        where up.code like '%start_discount_3m%'
           or (up.code in (select up.code from user_products up,
                                              user_products_to_product_lines up_to_pl,
                                              product_lines pl
                          where pl.description = 'web default line'
                            and up_to_pl.product_line_id = pl.id
                            and up.id = up_to_pl.user_product_id)
               and up.code not like '%standard100\_%'
               and up.code not like '%premium1000\_%'
               and up.code not like '%premium3000\_%')
    );


-- промо для веба
insert into promo_templates
(code, description, promo_name_tanker_key_id, from_date, to_date, application_area, application_type, duration,
 duration_measurement, activation_email_template_key, created_at)
values ('14_february_web_2022', '14 февраля 2022 для веба', null,
        '2022-02-14T00:00:00.000+0300' AT TIME ZONE 'UTC', '2022-02-22T00:00:00.000+0300' AT TIME ZONE 'UTC',
        'global'::promo_application_area, 'multiple_time'::promo_application_type, null, null, null, now());

insert into promo_product_lines(promo_template_id, product_line_id)
VALUES ((select id from promo_templates where code = '14_february_web_2022'),
        (select l.id
         from product_lines l
         where l.description = 'web start discount 3 months'));

insert into promo_payload (promo_id, payload_type, version, created_at, content)
select id, 'web'::payload_type, 0, now(), '
{
 "text_tanker": { "tanker_project": "front-ps-tuning", "tanker_key_set": "new-year-2022", "tanker_key": "promo-title" },
 "background": "https://yastatic.net/s3/disk/promo/new-year-2022/tuning/background-image.jpg",
 "illustration": "https://yastatic.net/s3/disk/promo/new-year-2022/tuning/grid-promo.png",
 "theme": "dark",
 "link": "https://360x2022.yandex?from=tuning"
}
'
from promo_templates where code = '14_february_web_2022';

insert into promo_payload (promo_id, payload_type, version, created_at, content)
select id, 'disk'::payload_type, 0, now(), '
{
 "info_space_block": {
   "text_tanker": { "tanker_project": "yandex_disk_web", "tanker_key_set": "view-ads", "tanker_key": "ufo_ads__new_year_2022_discount_text" },
   "background": "https://yastatic.net/s3/disk/promo/new-year-2022/disk/info-space-block/background-image.png",
   "imgSmallUrl": "https://yastatic.net/s3/disk/promo/new-year-2022/disk/info-space-block/small-image.png",
   "imgUrl": "https://yastatic.net/s3/disk/promo/new-year-2022/disk/info-space-block/main-image.png"
 },
 "tooltip": {
  "text_field_tanker": { "tanker_project": "yandex_disk_web", "tanker_key_set": "view-subscription-onboarding", "tanker_key": "ufo_subscription_new_year_2022_tooltip" },
  "img": "https://yastatic.net/s3/disk/promo/new-year-2022/disk/discount-tooltip/illustration.png",
  "width": "90",
  "height": "90",
  "leftOffset": "-50",
  "bottomOffset": "-36"
 },
 "onboarding": {
     "title_tanker": { "tanker_project": "yandex_disk_web", "tanker_key_set": "view-subscription-onboarding", "tanker_key": "ufo_subscription_onboarding_heading_NY2022" },
     "benefits": [
                    {
                        "text_tanker": { "tanker_project": "yandex_disk_web", "tanker_key_set": "view-subscription-onboarding", "tanker_key": "ufo_subscription_onboarding_benefit_mobileVideo_NY2022" },
                        "type": "mobileVideo"
                    },
                    {
                        "text_tanker": { "tanker_project": "yandex_disk_web", "tanker_key_set": "view-subscription-onboarding", "tanker_key": "ufo_subscription_onboarding_benefit_ads_NY2022" },
                        "type": "ads"
                    },
                    {
                        "text_tanker": { "tanker_project": "yandex_disk_web", "tanker_key_set": "view-subscription-onboarding", "tanker_key": "ufo_subscription_onboarding_benefit_domain_BF" },
                        "type": "domain"
                    }
                ],
       "background": "https://yastatic.net/s3/disk/promo/new-year-2022/disk/onboarding/background-image.jpg",
       "illustration": "https://yastatic.net/s3/disk/promo/new-year-2022/disk/onboarding/illustration-image.png"
  }
}
'
from promo_templates where code = '14_february_web_2022';

-- мобилы. отдельно, потому что есть баг с датой в мобилах MOBDISK-23958
with description_key as
         (
             insert into tanker_keys (created_at, project, key_set, key)
                 values (now(), 'disk-ps-billing', 'promos', '14_february_mobile_promo') returning id
         )

insert
into promo_templates
(code, description, promo_name_tanker_key_id, from_date, to_date, application_area, application_type, duration,
 duration_measurement, activation_email_template_key, mobile_payload, created_at)
values ('14_february_mobile_2022', '14 февраля 2022 для мобильных',
        (select id from description_key),
        '2022-02-14T00:00:00.000+0300' AT TIME ZONE 'UTC', '2022-02-21T23:59:59.000+0300' AT TIME ZONE 'UTC', -- двигаем дату на секунду назад, чтобы мобилы правильно отобразили дату конца акции
        'global'::promo_application_area, 'one_time'::promo_application_type, null, null, null,
        null, now());

insert into promo_product_lines(promo_template_id, product_line_id)
select pt.id, l.id
from promo_templates pt,
     product_lines l
where l.description in ('ios mail default line', 'android introductory line', 'ios disk default line')
  and pt.code = '14_february_mobile_2022';

insert into promo_payload (promo_id, payload_type, version, created_at, content)
select id, 'mobile'::payload_type, 0, now(), '
[
  {
    "version": 1,
    "currency": "rub",
    "platform": "*",
    "owner": "disk",
    "disk_space_block": {
      "tooltip_text_tanker": {
        "tanker_project": "disk-ps-billing",
        "tanker_key_set": "promos",
        "tanker_key": "disk_mobile_tooltip_rub"
      }
    },
    "promo_page": {
      "title_tanker": {
        "tanker_project": "disk-ps-billing",
        "tanker_key_set": "promos",
        "tanker_key": "disk_mobile_purchases_title_rub"
      }
    },
    "onboarding": {
      "first": {
        "title_tanker": {
          "tanker_project": "disk-ps-billing",
          "tanker_key_set": "promos",
          "tanker_key": "disk_mobile_onboarding_title_rub"
        },
        "description_tanker": {
          "tanker_project": "disk-ps-billing",
          "tanker_key_set": "promos",
          "tanker_key": "disk_mobile_onboarding_text_rub"
        },
        "button_text_tanker": {
          "tanker_project": "disk-ps-billing",
          "tanker_key_set": "promos",
          "tanker_key": "disk_mobile_onboarding_button_rub"
        }
      }
    }
  },
  {
    "version": 1,
    "currency": "rub",
    "platform": "*",
    "owner": "mail",
    "promo_page": {
      "title_tanker": {
        "tanker_project": "disk-ps-billing",
        "tanker_key_set": "promos",
        "tanker_key": "mail_mobile_purchases_title_rub"
      }
    },
    "onboarding": {
      "first": {
        "title_tanker": {
          "tanker_project": "disk-ps-billing",
          "tanker_key_set": "promos",
          "tanker_key": "mail_mobile_onboarding_title_rub"
        },
        "description_tanker": {
          "tanker_project": "disk-ps-billing",
          "tanker_key_set": "promos",
          "tanker_key": "mail_mobile_onboarding_text_rub"
        },
        "button_text_tanker": {
          "tanker_project": "disk-ps-billing",
          "tanker_key_set": "promos",
          "tanker_key": "mail_mobile_onboarding_button_rub"
        }
      }
    }
  },
  {
    "version": 1,
    "currency": "*",
    "platform": "*",
    "owner": "disk",
    "disk_space_block": {
      "tooltip_text_tanker": {
        "tanker_project": "disk-ps-billing",
        "tanker_key_set": "promos",
        "tanker_key": "disk_mobile_tooltip_default"
      }
    },
    "promo_page": {
      "title_tanker": {
        "tanker_project": "disk-ps-billing",
        "tanker_key_set": "promos",
        "tanker_key": "disk_mobile_purchases_title_default"
      }
    },
    "onboarding": {
      "first": {
        "title_tanker": {
          "tanker_project": "disk-ps-billing",
          "tanker_key_set": "promos",
          "tanker_key": "disk_mobile_onboarding_title_default"
        },
        "description_tanker": {
          "tanker_project": "disk-ps-billing",
          "tanker_key_set": "promos",
          "tanker_key": "disk_mobile_onboarding_text_default"
        },
        "button_text_tanker": {
          "tanker_project": "disk-ps-billing",
          "tanker_key_set": "promos",
          "tanker_key": "disk_mobile_onboarding_button_default"
        }
      }
    }
  },
  {
    "version": 1,
    "currency": "*",
    "platform": "*",
    "owner": "mail",
    "promo_page": {
      "title_tanker": {
        "tanker_project": "disk-ps-billing",
        "tanker_key_set": "promos",
        "tanker_key": "mail_mobile_purchases_title_default"
      }
    },
    "onboarding": {
      "first": {
        "title_tanker": {
          "tanker_project": "disk-ps-billing",
          "tanker_key_set": "promos",
          "tanker_key": "mail_mobile_onboarding_title_default"
        },
        "description_tanker": {
          "tanker_project": "disk-ps-billing",
          "tanker_key_set": "promos",
          "tanker_key": "mail_mobile_onboarding_text_default"
        },
        "button_text_tanker": {
          "tanker_project": "disk-ps-billing",
          "tanker_key_set": "promos",
          "tanker_key": "mail_mobile_onboarding_button_default"
        }
      }
    }
  }
]
'
from promo_templates where code = '14_february_mobile_2022';

-- payload v1
insert into promo_payload (promo_id, payload_type, version, created_at, content)
select id, 'mobile'::payload_type, 1, now(), '
{
    "strings": [
        {
            "version": 1,
            "currency": "rub",
            "platform": "*",
            "owner": "disk",
            "disk_space_block": {
                "tooltip_text_tanker": {
                    "tanker_project": "disk-ps-billing",
                    "tanker_key_set": "promos",
                    "tanker_key": "disk_mobile_tooltip_rub"
                }
            },
            "promo_page": {
                "title_tanker": {
                    "tanker_project": "disk-ps-billing",
                    "tanker_key_set": "promos",
                    "tanker_key": "disk_mobile_purchases_title_rub"
                }
            },
            "onboarding": {
                "first": {
                    "title_tanker": {
                        "tanker_project": "disk-ps-billing",
                        "tanker_key_set": "promos",
                        "tanker_key": "disk_mobile_onboarding_title_rub"
                    },
                    "description_tanker": {
                        "tanker_project": "disk-ps-billing",
                        "tanker_key_set": "promos",
                        "tanker_key": "disk_mobile_onboarding_text_rub"
                    },
                    "button_text_tanker": {
                        "tanker_project": "disk-ps-billing",
                        "tanker_key_set": "promos",
                        "tanker_key": "disk_mobile_onboarding_button_rub"
                    }
                }
            }
        },
        {
            "version": 1,
            "currency": "rub",
            "platform": "*",
            "owner": "mail",
            "promo_page": {
                "title_tanker": {
                    "tanker_project": "disk-ps-billing",
                    "tanker_key_set": "promos",
                    "tanker_key": "mail_mobile_purchases_title_rub"
                }
            },
            "onboarding": {
                "first": {
                    "title_tanker": {
                        "tanker_project": "disk-ps-billing",
                        "tanker_key_set": "promos",
                        "tanker_key": "mail_mobile_onboarding_title_rub"
                    },
                    "description_tanker": {
                        "tanker_project": "disk-ps-billing",
                        "tanker_key_set": "promos",
                        "tanker_key": "mail_mobile_onboarding_text_rub"
                    },
                    "button_text_tanker": {
                        "tanker_project": "disk-ps-billing",
                        "tanker_key_set": "promos",
                        "tanker_key": "mail_mobile_onboarding_button_rub"
                    }
                }
            }
        },
        {
            "version": 1,
            "currency": "*",
            "platform": "*",
            "owner": "disk",
            "disk_space_block": {
                "tooltip_text_tanker": {
                    "tanker_project": "disk-ps-billing",
                    "tanker_key_set": "promos",
                    "tanker_key": "disk_mobile_tooltip_default"
                }
            },
            "promo_page": {
                "title_tanker": {
                    "tanker_project": "disk-ps-billing",
                    "tanker_key_set": "promos",
                    "tanker_key": "disk_mobile_purchases_title_default"
                }
            },
            "onboarding": {
                "first": {
                    "title_tanker": {
                        "tanker_project": "disk-ps-billing",
                        "tanker_key_set": "promos",
                        "tanker_key": "disk_mobile_onboarding_title_default"
                    },
                    "description_tanker": {
                        "tanker_project": "disk-ps-billing",
                        "tanker_key_set": "promos",
                        "tanker_key": "disk_mobile_onboarding_text_default"
                    },
                    "button_text_tanker": {
                        "tanker_project": "disk-ps-billing",
                        "tanker_key_set": "promos",
                        "tanker_key": "disk_mobile_onboarding_button_default"
                    }
                }
            }
        },
        {
            "version": 1,
            "currency": "*",
            "platform": "*",
            "owner": "mail",
            "promo_page": {
                "title_tanker": {
                    "tanker_project": "disk-ps-billing",
                    "tanker_key_set": "promos",
                    "tanker_key": "mail_mobile_purchases_title_default"
                }
            },
            "onboarding": {
                "first": {
                    "title_tanker": {
                        "tanker_project": "disk-ps-billing",
                        "tanker_key_set": "promos",
                        "tanker_key": "mail_mobile_onboarding_title_default"
                    },
                    "description_tanker": {
                        "tanker_project": "disk-ps-billing",
                        "tanker_key_set": "promos",
                        "tanker_key": "mail_mobile_onboarding_text_default"
                    },
                    "button_text_tanker": {
                        "tanker_project": "disk-ps-billing",
                        "tanker_key_set": "promos",
                        "tanker_key": "mail_mobile_onboarding_button_default"
                    }
                }
            }
        }
    ],
    "images": [
        {
            "device": "phone",
            "platform": "android",
            "owner": "disk",
            "background": {
                "light": "https://yastatic.net/s3/disk/promo/new-year-2022/disk/onboarding/background-image.jpg",
                "dark": "https://yastatic.net/s3/disk/promo/new-year-2022/disk/onboarding/background-image.jpg"
            },
            "onboarding_image": {
                "light": "https://yastatic.net/s3/disk/promo/new-year-2022/disk/onboarding/illustration-image.png",
                "dark": "https://yastatic.net/s3/disk/promo/new-year-2022/disk/onboarding/illustration-image.png"
            },
            "onboarding_background": {
                "light": "https://yastatic.net/s3/disk/promo/new-year-2022/disk/onboarding/background-image.jpg",
                "dark": "https://yastatic.net/s3/disk/promo/new-year-2022/disk/onboarding/background-image.jpg"
            }
        },
        {
            "device": "tablet",
            "platform": "android",
            "owner": "disk",
            "background": {
                "light": "https://yastatic.net/s3/disk/promo/new-year-2022/disk/onboarding/background-image.jpg",
                "dark": "https://yastatic.net/s3/disk/promo/new-year-2022/disk/onboarding/background-image.jpg"
            },
            "onboarding_image": {
                "light": "https://yastatic.net/s3/disk/promo/new-year-2022/disk/onboarding/illustration-image.png",
                "dark": "https://yastatic.net/s3/disk/promo/new-year-2022/disk/onboarding/illustration-image.png"
            },
            "onboarding_background": {
                "light": "https://yastatic.net/s3/disk/promo/new-year-2022/disk/onboarding/background-image.jpg",
                "dark": "https://yastatic.net/s3/disk/promo/new-year-2022/disk/onboarding/background-image.jpg"
            }
        },
        {
            "device": "phone",
            "platform": "ios",
            "owner": "disk",
            "background": {
                "light": "https://yastatic.net/s3/disk/promo/new-year-2022/disk/onboarding/background-image.jpg",
                "dark": "https://yastatic.net/s3/disk/promo/new-year-2022/disk/onboarding/background-image.jpg"
            },
            "onboarding_image": {
                "light": "https://yastatic.net/s3/disk/promo/new-year-2022/disk/onboarding/illustration-image.png",
                "dark": "https://yastatic.net/s3/disk/promo/new-year-2022/disk/onboarding/illustration-image.png"
            },
            "onboarding_background": {
                "light": "https://yastatic.net/s3/disk/promo/new-year-2022/disk/onboarding/background-image.jpg",
                "dark": "https://yastatic.net/s3/disk/promo/new-year-2022/disk/onboarding/background-image.jpg"
            }
        },
        {
            "device": "tablet",
            "platform": "ios",
            "owner": "disk",
            "background": {
                "light": "https://yastatic.net/s3/disk/promo/new-year-2022/disk/onboarding/background-image.jpg",
                "dark": "https://yastatic.net/s3/disk/promo/new-year-2022/disk/onboarding/background-image.jpg"
            },
            "onboarding_image": {
                "light": "https://yastatic.net/s3/disk/promo/new-year-2022/disk/onboarding/illustration-image.png",
                "dark": "https://yastatic.net/s3/disk/promo/new-year-2022/disk/onboarding/illustration-image.png"
            },
            "onboarding_background": {
                "light": "https://yastatic.net/s3/disk/promo/new-year-2022/disk/onboarding/background-image.jpg",
                "dark": "https://yastatic.net/s3/disk/promo/new-year-2022/disk/onboarding/background-image.jpg"
            }
        },
        {
            "device": "phone",
            "platform": "android",
            "owner": "mail",
            "background": {
                "light": "https://yastatic.net/s3/disk/promo/new-year-2022/disk/onboarding/background-image.jpg",
                "dark": "https://yastatic.net/s3/disk/promo/new-year-2022/disk/onboarding/background-image.jpg"
            },
            "onboarding_image": {
                "light": "https://yastatic.net/s3/disk/promo/new-year-2022/disk/onboarding/illustration-image.png",
                "dark": "https://yastatic.net/s3/disk/promo/new-year-2022/disk/onboarding/illustration-image.png"
            },
            "onboarding_background": {
                "light": "https://yastatic.net/s3/disk/promo/new-year-2022/disk/onboarding/background-image.jpg",
                "dark": "https://yastatic.net/s3/disk/promo/new-year-2022/disk/onboarding/background-image.jpg"
            }
        },
        {
            "device": "tablet",
            "platform": "android",
            "owner": "mail",
            "background": {
                "light": "https://yastatic.net/s3/disk/promo/new-year-2022/disk/onboarding/background-image.jpg",
                "dark": "https://yastatic.net/s3/disk/promo/new-year-2022/disk/onboarding/background-image.jpg"
            },
            "onboarding_image": {
                "light": "https://yastatic.net/s3/disk/promo/new-year-2022/disk/onboarding/illustration-image.png",
                "dark": "https://yastatic.net/s3/disk/promo/new-year-2022/disk/onboarding/illustration-image.png"
            },
            "onboarding_background": {
                "light": "https://yastatic.net/s3/disk/promo/new-year-2022/disk/onboarding/background-image.jpg",
                "dark": "https://yastatic.net/s3/disk/promo/new-year-2022/disk/onboarding/background-image.jpg"
            }
        },
        {
            "device": "phone",
            "platform": "ios",
            "owner": "mail",
            "background": {
                "light": "https://yastatic.net/s3/disk/promo/new-year-2022/disk/onboarding/background-image.jpg",
                "dark": "https://yastatic.net/s3/disk/promo/new-year-2022/disk/onboarding/background-image.jpg"
            },
            "onboarding_image": {
                "light": "https://yastatic.net/s3/disk/promo/new-year-2022/disk/onboarding/illustration-image.png",
                "dark": "https://yastatic.net/s3/disk/promo/new-year-2022/disk/onboarding/illustration-image.png"
            },
            "onboarding_background": {
                "light": "https://yastatic.net/s3/disk/promo/new-year-2022/disk/onboarding/background-image.jpg",
                "dark": "https://yastatic.net/s3/disk/promo/new-year-2022/disk/onboarding/background-image.jpg"
            }
        },
        {
            "device": "tablet",
            "platform": "ios",
            "owner": "mail",
            "background": {
                "light": "https://yastatic.net/s3/disk/promo/new-year-2022/disk/onboarding/background-image.jpg",
                "dark": "https://yastatic.net/s3/disk/promo/new-year-2022/disk/onboarding/background-image.jpg"
            },
            "onboarding_image": {
                "light": "https://yastatic.net/s3/disk/promo/new-year-2022/disk/onboarding/illustration-image.png",
                "dark": "https://yastatic.net/s3/disk/promo/new-year-2022/disk/onboarding/illustration-image.png"
            },
            "onboarding_background": {
                "light": "https://yastatic.net/s3/disk/promo/new-year-2022/disk/onboarding/background-image.jpg",
                "dark": "https://yastatic.net/s3/disk/promo/new-year-2022/disk/onboarding/background-image.jpg"
            }
        }
    ]
}
'
from promo_templates where code = '14_february_mobile_2022';
