/* pgmigrate-encoding: utf-8 */

-- копируем продукты из линейки 'web 20% discount line'
select copy_products('mail_pro_b2c_standard100_discount20_v20210610','mail_pro_b2c_standard100_discount20_v20210610','mail_pro_b2c_standard100_start_discount20');
select copy_products('mail_pro_b2c_premium1000_discount20_v20210610','mail_pro_b2c_premium1000_discount20_v20210610','mail_pro_b2c_premium1000_start_discount20');
select copy_products('mail_pro_b2c_premium3000_discount20_v20210610','mail_pro_b2c_premium3000_discount20_v20210610','mail_pro_b2c_premium3000_start_discount20');
select copy_products('mail_pro_b2c_premium5000_discount20_v20210610','mail_pro_b2c_premium5000_discount20_v20210610','mail_pro_b2c_premium5000_start_discount20');
select copy_products('mail_pro_b2c_premium10000_discount20_v20210610','mail_pro_b2c_premium10000_discount20_v20210610','mail_pro_b2c_premium10000_start_discount20');
select copy_products('mail_pro_b2c_premium25000_discount20_v20210813','mail_pro_b2c_premium25000_discount20_v20210813','mail_pro_b2c_premium25000_start_discount20');
select copy_products('mail_pro_b2c_premium50000_discount20_v20210813','mail_pro_b2c_premium50000_discount20_v20210813','mail_pro_b2c_premium50000_start_discount20');


-- выставляем параметры скидки для месячных тарифов
update user_product_periods upp
    set start_period_count                         = 5,
        start_period_discount_duration_length      = 1,
        start_period_discount_duration_measurement = 'month',
        trust_fiscal_title = replace(trust_fiscal_title, ' (скидка -20%)', '')
    where id in (select upp.id
                 from user_products up
                     join user_product_periods upp on up.id = upp.user_product_id
                     join user_product_prices u on upp.id = u.user_product_period_id
                 where upp.period = 'month'
                   and up.code in ('mail_pro_b2c_standard100_start_discount20', 'mail_pro_b2c_premium1000_start_discount20',
                                   'mail_pro_b2c_premium3000_start_discount20', 'mail_pro_b2c_premium5000_start_discount20',
                                   'mail_pro_b2c_premium10000_start_discount20', 'mail_pro_b2c_premium25000_start_discount20',
                                   'mail_pro_b2c_premium50000_start_discount20')
    );

-- выставляем параметры скидки для годовых тарифов
update user_product_periods upp
    set start_period_count                         = 1,
        start_period_discount_duration_length      = 1,
        start_period_discount_duration_measurement = 'year',
        trust_fiscal_title = replace(trust_fiscal_title, ' (скидка -20%)', '')
    where id in (select upp.id
                 from user_products up
                     join user_product_periods upp on up.id = upp.user_product_id
                     join user_product_prices u on upp.id = u.user_product_period_id
                 where upp.period = 'year'
                 and up.code in ('mail_pro_b2c_standard100_start_discount20', 'mail_pro_b2c_premium1000_start_discount20',
                                 'mail_pro_b2c_premium3000_start_discount20', 'mail_pro_b2c_premium5000_start_discount20',
                                 'mail_pro_b2c_premium10000_start_discount20', 'mail_pro_b2c_premium25000_start_discount20',
                                 'mail_pro_b2c_premium50000_start_discount20')
    );

-- обновляем цены с учётом start_period_price
update user_product_prices upprices
set start_period_price = upprices.price, price = upprices.display_original_price, display_original_price = NULL, display_discount_percent = NULL
where id in (select u.id
             from user_products up
                 join user_product_periods upp on up.id = upp.user_product_id
                 join user_product_prices u on upp.id = u.user_product_period_id
             where up.code in ('mail_pro_b2c_standard100_start_discount20', 'mail_pro_b2c_premium1000_start_discount20',
                               'mail_pro_b2c_premium3000_start_discount20', 'mail_pro_b2c_premium5000_start_discount20',
                               'mail_pro_b2c_premium10000_start_discount20', 'mail_pro_b2c_premium25000_start_discount20',
                               'mail_pro_b2c_premium50000_start_discount20')
);


-- двигаем скидочные линейки, начиная с 'web 20% discount line'
update product_lines
set order_num = order_num + 1
where order_num >= 1006
  and product_set_id = (select id from product_sets where key = 'mail_pro_b2c');

-- добавляем новую скидочную линейку и добавляем в нее созданные продукты
with promo_line_id as
         (
             insert into product_lines (product_set_id, created_at, order_num, selector_bean_el, description)
                 values ((select id from product_sets where key = 'mail_pro_b2c'), now(), 1006,
                         'productLineSelectorFactory.availableSelector()', 'web start discount 20')
                 returning id
         ),
     order_num as
         (
             select code, order_num
             from (
                      values ('%standard100\_%', 1),
                             ('%premium1000\_%', 2),
                             ('%premium3000\_%', 3),
                             ('%premium5000\_%', 4),
                             ('%premium10000\_%', 5),
                             ('%premium25000\_%', 6),
                             ('%premium50000\_%', 7)
                  ) s(code, order_num)
         )
insert into user_products_to_product_lines
    (product_line_id, user_product_id, order_num)
    (
        select promo_line_id.id, up.id, order_num
        from promo_line_id,
             user_products up
                 join order_num o on up.code like o.code
        where up.code like '%start_discount20%'
    );

-- перевешаем промо догоняющих скидок и новичка на новую линейку
update promo_product_lines
set product_line_id = (select id from product_lines where description = 'web start discount 20')
where promo_template_id in (select id from promo_templates where code = 'newbie' or code = 'please_come_back_promo_product_set_request');

-- добавляем новый promo payload для догоняющих скидок и новичка
insert into promo_payload (promo_id, payload_type, version, created_at, content)
select id, 'web_disk'::payload_type, 0, now(), '{ "discountPercent": 20 }'
from promo_templates where code = 'newbie' or code = 'please_come_back_promo_product_set_request';
