/* pgmigrate-encoding: utf-8 */

-- добавляем новые значения в enum через создание нового типа
alter type payload_type rename to payload_type_old;

create type payload_type as enum ('mobile', 'disk', 'mail', 'web', 'web_disk', 'web_mail', 'web_tuning', 'mobile_disk', 'mobile_mail');

alter table promo_payload
    alter column payload_type 
        type payload_type 
        using payload_type::text::payload_type;

drop type payload_type_old;

-- обновляем существующие payload'ы
update promo_payload
set content = '
[
    {
        "version": 1,
        "currency": "rub",
        "platform": "*",
        "owner": "disk",
        "disk_space_block": {
            "tooltip_text_tanker": {
                "tanker_project": "disk-ps-billing",
                "tanker_key_set": "promos",
                "tanker_key": "disk_mobile_tooltip_rub"
            }
        },
        "promo_page": {
            "title_tanker": {
                "tanker_project": "disk-ps-billing",
                "tanker_key_set": "promos",
                "tanker_key": "disk_mobile_purchases_title_rub"
            }
        },
        "onboarding": {
            "first": {
                "title_tanker": {
                    "tanker_project": "disk-ps-billing",
                    "tanker_key_set": "promos",
                    "tanker_key": "disk_mobile_onboarding_title_rub"
                },
                "description_tanker": {
                    "tanker_project": "disk-ps-billing",
                    "tanker_key_set": "promos",
                    "tanker_key": "disk_mobile_onboarding_text_rub"
                },
                "button_text_tanker": {
                    "tanker_project": "disk-ps-billing",
                    "tanker_key_set": "promos",
                    "tanker_key": "disk_mobile_onboarding_button_rub"
                }
            }
        }
    },
    {
        "version": 1,
        "currency": "*",
        "platform": "*",
        "owner": "disk",
        "disk_space_block": {
            "tooltip_text_tanker": {
                "tanker_project": "disk-ps-billing",
                "tanker_key_set": "promos",
                "tanker_key": "disk_mobile_tooltip_default"
            }
        },
        "promo_page": {
            "title_tanker": {
                "tanker_project": "disk-ps-billing",
                "tanker_key_set": "promos",
                "tanker_key": "disk_mobile_purchases_title_default"
            }
        },
        "onboarding": {
            "first": {
                "title_tanker": {
                    "tanker_project": "disk-ps-billing",
                    "tanker_key_set": "promos",
                    "tanker_key": "disk_mobile_onboarding_title_default"
                },
                "description_tanker": {
                    "tanker_project": "disk-ps-billing",
                    "tanker_key_set": "promos",
                    "tanker_key": "disk_mobile_onboarding_text_default"
                },
                "button_text_tanker": {
                    "tanker_project": "disk-ps-billing",
                    "tanker_key_set": "promos",
                    "tanker_key": "disk_mobile_onboarding_button_default"
                }
            }
        }
    },
    {
        "version": 1,
        "currency": "rub",
        "platform": "*",
        "owner": "mail",
        "promo_page": {
            "title_tanker": {
                "tanker_project": "disk-ps-billing",
                "tanker_key_set": "promos",
                "tanker_key": "mail_mobile_purchases_title_rub"
            }
        },
        "onboarding": {
            "first": {
                "title_tanker": {
                    "tanker_project": "disk-ps-billing",
                    "tanker_key_set": "promos",
                    "tanker_key": "mail_mobile_onboarding_title_rub"
                },
                "description_tanker": {
                    "tanker_project": "disk-ps-billing",
                    "tanker_key_set": "promos",
                    "tanker_key": "mail_mobile_onboarding_text_rub"
                },
                "button_text_tanker": {
                    "tanker_project": "disk-ps-billing",
                    "tanker_key_set": "promos",
                    "tanker_key": "mail_mobile_onboarding_button_rub"
                }
            }
        }
    },
    {
        "version": 1,
        "currency": "*",
        "platform": "*",
        "owner": "mail",
        "promo_page": {
            "title_tanker": {
                "tanker_project": "disk-ps-billing",
                "tanker_key_set": "promos",
                "tanker_key": "mail_mobile_purchases_title_default"
            }
        },
        "onboarding": {
            "first": {
                "title_tanker": {
                    "tanker_project": "disk-ps-billing",
                    "tanker_key_set": "promos",
                    "tanker_key": "mail_mobile_onboarding_title_default"
                },
                "description_tanker": {
                    "tanker_project": "disk-ps-billing",
                    "tanker_key_set": "promos",
                    "tanker_key": "mail_mobile_onboarding_text_default"
                },
                "button_text_tanker": {
                    "tanker_project": "disk-ps-billing",
                    "tanker_key_set": "promos",
                    "tanker_key": "mail_mobile_onboarding_button_default"
                }
            }
        }
    }
]
'
where promo_id = (select id from promo_templates where code = '14_february_mobile_2022')
  and payload_type = 'mobile'::payload_type
  and version = 0;

update promo_payload
set content = '
{
    "strings": [
        {
            "version": 1,
            "currency": "rub",
            "platform": "*",
            "owner": "disk",
            "disk_space_block": {
                "tooltip_text_tanker": {
                    "tanker_project": "disk-ps-billing",
                    "tanker_key_set": "promos",
                    "tanker_key": "disk_mobile_tooltip_rub"
                }
            },
            "promo_page": {
                "title_tanker": {
                    "tanker_project": "disk-ps-billing",
                    "tanker_key_set": "promos",
                    "tanker_key": "disk_mobile_purchases_title_rub"
                }
            },
            "onboarding": {
                "first": {
                    "title_tanker": {
                        "tanker_project": "disk-ps-billing",
                        "tanker_key_set": "promos",
                        "tanker_key": "disk_mobile_onboarding_title_rub"
                    },
                    "description_tanker": {
                        "tanker_project": "disk-ps-billing",
                        "tanker_key_set": "promos",
                        "tanker_key": "disk_mobile_onboarding_text_rub"
                    },
                    "button_text_tanker": {
                        "tanker_project": "disk-ps-billing",
                        "tanker_key_set": "promos",
                        "tanker_key": "disk_mobile_onboarding_button_rub"
                    }
                }
            }
        },
        {
            "version": 1,
            "currency": "*",
            "platform": "*",
            "owner": "disk",
            "disk_space_block": {
                "tooltip_text_tanker": {
                    "tanker_project": "disk-ps-billing",
                    "tanker_key_set": "promos",
                    "tanker_key": "disk_mobile_tooltip_default"
                }
            },
            "promo_page": {
                "title_tanker": {
                    "tanker_project": "disk-ps-billing",
                    "tanker_key_set": "promos",
                    "tanker_key": "disk_mobile_purchases_title_default"
                }
            },
            "onboarding": {
                "first": {
                    "title_tanker": {
                        "tanker_project": "disk-ps-billing",
                        "tanker_key_set": "promos",
                        "tanker_key": "disk_mobile_onboarding_title_default"
                    },
                    "description_tanker": {
                        "tanker_project": "disk-ps-billing",
                        "tanker_key_set": "promos",
                        "tanker_key": "disk_mobile_onboarding_text_default"
                    },
                    "button_text_tanker": {
                        "tanker_project": "disk-ps-billing",
                        "tanker_key_set": "promos",
                        "tanker_key": "disk_mobile_onboarding_button_default"
                    }
                }
            }
        },
        {
            "version": 1,
            "currency": "rub",
            "platform": "*",
            "owner": "mail",
            "promo_page": {
                "title_tanker": {
                    "tanker_project": "disk-ps-billing",
                    "tanker_key_set": "promos",
                    "tanker_key": "mail_mobile_purchases_title_rub"
                }
            },
            "onboarding": {
                "first": {
                    "title_tanker": {
                        "tanker_project": "disk-ps-billing",
                        "tanker_key_set": "promos",
                        "tanker_key": "mail_mobile_onboarding_title_rub"
                    },
                    "description_tanker": {
                        "tanker_project": "disk-ps-billing",
                        "tanker_key_set": "promos",
                        "tanker_key": "mail_mobile_onboarding_text_rub"
                    },
                    "button_text_tanker": {
                        "tanker_project": "disk-ps-billing",
                        "tanker_key_set": "promos",
                        "tanker_key": "mail_mobile_onboarding_button_rub"
                    }
                }
            }
        },
        {
            "version": 1,
            "currency": "*",
            "platform": "*",
            "owner": "mail",
            "promo_page": {
                "title_tanker": {
                    "tanker_project": "disk-ps-billing",
                    "tanker_key_set": "promos",
                    "tanker_key": "mail_mobile_purchases_title_default"
                }
            },
            "onboarding": {
                "first": {
                    "title_tanker": {
                        "tanker_project": "disk-ps-billing",
                        "tanker_key_set": "promos",
                        "tanker_key": "mail_mobile_onboarding_title_default"
                    },
                    "description_tanker": {
                        "tanker_project": "disk-ps-billing",
                        "tanker_key_set": "promos",
                        "tanker_key": "mail_mobile_onboarding_text_default"
                    },
                    "button_text_tanker": {
                        "tanker_project": "disk-ps-billing",
                        "tanker_key_set": "promos",
                        "tanker_key": "mail_mobile_onboarding_button_default"
                    }
                }
            }
        }
    ],
    "images": [
        {
            "device": "phone",
            "platform": "android",
            "owner": "disk",
            "background": {
                "light": "https://yastatic.net/s3/disk/promo/february-14-2022/disk-android/phone/purchases/background-light.jpg",
                "dark": "https://yastatic.net/s3/disk/promo/february-14-2022/disk-android/phone/purchases/background-dark.jpg"
            },
            "onboarding_image": {
                "light": "https://yastatic.net/s3/disk/promo/february-14-2022/disk-android/phone/onboarding/image-light.png",
                "dark": "https://yastatic.net/s3/disk/promo/february-14-2022/disk-android/phone/onboarding/image-dark.png"
            },
            "onboarding_background": {
                "light": "https://yastatic.net/s3/disk/promo/february-14-2022/disk-android/phone/onboarding/background-light.jpg",
                "dark": "https://yastatic.net/s3/disk/promo/february-14-2022/disk-android/phone/onboarding/background-dark.jpg"
            }
        },
        {
            "device": "tablet",
            "platform": "android",
            "owner": "disk",
            "background": {
                "light": "https://yastatic.net/s3/disk/promo/february-14-2022/disk-android/tablet/purchases/background-light.jpg",
                "dark": "https://yastatic.net/s3/disk/promo/february-14-2022/disk-android/tablet/purchases/background-dark.jpg"
            },
            "onboarding_image": {
                "light": "https://yastatic.net/s3/disk/promo/february-14-2022/disk-android/tablet/onboarding/image-light.png",
                "dark": "https://yastatic.net/s3/disk/promo/february-14-2022/disk-android/tablet/onboarding/image-dark.png"
            },
            "onboarding_background": {
                "light": "https://yastatic.net/s3/disk/promo/february-14-2022/disk-android/tablet/onboarding/background-light.jpg",
                "dark": "https://yastatic.net/s3/disk/promo/february-14-2022/disk-android/tablet/onboarding/background-dark.jpg"
            }
        },
        {
            "device": "*",
            "platform": "ios",
            "owner": "disk",
            "background": {
                "light": "https://yastatic.net/s3/disk/promo/february-14-2022/disk-ios/purchases/background-light.jpg",
                "dark": "https://yastatic.net/s3/disk/promo/february-14-2022/disk-ios/purchases/background-dark.jpg"
            },
            "onboarding_image": {
                "light": "https://yastatic.net/s3/disk/promo/february-14-2022/disk-ios/onboarding/image-light.png",
                "dark": "https://yastatic.net/s3/disk/promo/february-14-2022/disk-ios/onboarding/image-dark.png"
            },
            "onboarding_background": {
                "light": "https://yastatic.net/s3/disk/promo/february-14-2022/disk-ios/onboarding/background-light.jpg",
                "dark": "https://yastatic.net/s3/disk/promo/february-14-2022/disk-ios/onboarding/background-dark.jpg"
            }
        }
    ]
}
'
where promo_id = (select id from promo_templates where code = '14_february_mobile_2022')
  and payload_type = 'mobile'::payload_type
  and version = 1;

-- добавляем новые payload'ы
insert into promo_payload (promo_id, payload_type, content, version, created_at)
values ((select id from promo_templates where code = '14_february_mobile_2022'),
        'mobile_disk'::payload_type,
        '
{
    "strings": [
        {
            "version": 1,
            "currency": "rub",
            "platform": "*",
            "owner": "disk",
            "disk_space_block": {
                "tooltip_text_tanker": {
                    "tanker_project": "disk-ps-billing",
                    "tanker_key_set": "promos",
                    "tanker_key": "disk_mobile_tooltip_rub"
                }
            },
            "promo_page": {
                "title_tanker": {
                    "tanker_project": "disk-ps-billing",
                    "tanker_key_set": "promos",
                    "tanker_key": "disk_mobile_purchases_title_rub"
                }
            },
            "onboarding": {
                "first": {
                    "title_tanker": {
                        "tanker_project": "disk-ps-billing",
                        "tanker_key_set": "promos",
                        "tanker_key": "disk_mobile_onboarding_title_rub"
                    },
                    "description_tanker": {
                        "tanker_project": "disk-ps-billing",
                        "tanker_key_set": "promos",
                        "tanker_key": "disk_mobile_onboarding_text_rub"
                    },
                    "button_text_tanker": {
                        "tanker_project": "disk-ps-billing",
                        "tanker_key_set": "promos",
                        "tanker_key": "disk_mobile_onboarding_button_rub"
                    }
                }
            }
        },
        {
            "version": 1,
            "currency": "*",
            "platform": "*",
            "owner": "disk",
            "disk_space_block": {
                "tooltip_text_tanker": {
                    "tanker_project": "disk-ps-billing",
                    "tanker_key_set": "promos",
                    "tanker_key": "disk_mobile_tooltip_default"
                }
            },
            "promo_page": {
                "title_tanker": {
                    "tanker_project": "disk-ps-billing",
                    "tanker_key_set": "promos",
                    "tanker_key": "disk_mobile_purchases_title_default"
                }
            },
            "onboarding": {
                "first": {
                    "title_tanker": {
                        "tanker_project": "disk-ps-billing",
                        "tanker_key_set": "promos",
                        "tanker_key": "disk_mobile_onboarding_title_default"
                    },
                    "description_tanker": {
                        "tanker_project": "disk-ps-billing",
                        "tanker_key_set": "promos",
                        "tanker_key": "disk_mobile_onboarding_text_default"
                    },
                    "button_text_tanker": {
                        "tanker_project": "disk-ps-billing",
                        "tanker_key_set": "promos",
                        "tanker_key": "disk_mobile_onboarding_button_default"
                    }
                }
            }
        }
    ],
    "images": [
        {
            "device": "phone",
            "platform": "android",
            "owner": "disk",
            "background": {
                "light": "https://yastatic.net/s3/disk/promo/february-14-2022/disk-android/phone/purchases/background-light.jpg",
                "dark": "https://yastatic.net/s3/disk/promo/february-14-2022/disk-android/phone/purchases/background-dark.jpg"
            },
            "onboarding_image": {
                "light": "https://yastatic.net/s3/disk/promo/february-14-2022/disk-android/phone/onboarding/image-light.png",
                "dark": "https://yastatic.net/s3/disk/promo/february-14-2022/disk-android/phone/onboarding/image-dark.png"
            },
            "onboarding_background": {
                "light": "https://yastatic.net/s3/disk/promo/february-14-2022/disk-android/phone/onboarding/background-light.jpg",
                "dark": "https://yastatic.net/s3/disk/promo/february-14-2022/disk-android/phone/onboarding/background-dark.jpg"
            }
        },
        {
            "device": "tablet",
            "platform": "android",
            "owner": "disk",
            "background": {
                "light": "https://yastatic.net/s3/disk/promo/february-14-2022/disk-android/tablet/purchases/background-light.jpg",
                "dark": "https://yastatic.net/s3/disk/promo/february-14-2022/disk-android/tablet/purchases/background-dark.jpg"
            },
            "onboarding_image": {
                "light": "https://yastatic.net/s3/disk/promo/february-14-2022/disk-android/tablet/onboarding/image-light.png",
                "dark": "https://yastatic.net/s3/disk/promo/february-14-2022/disk-android/tablet/onboarding/image-dark.png"
            },
            "onboarding_background": {
                "light": "https://yastatic.net/s3/disk/promo/february-14-2022/disk-android/tablet/onboarding/background-light.jpg",
                "dark": "https://yastatic.net/s3/disk/promo/february-14-2022/disk-android/tablet/onboarding/background-dark.jpg"
            }
        },
        {
            "device": "*",
            "platform": "ios",
            "owner": "disk",
            "background": {
                "light": "https://yastatic.net/s3/disk/promo/february-14-2022/disk-ios/purchases/background-light.jpg",
                "dark": "https://yastatic.net/s3/disk/promo/february-14-2022/disk-ios/purchases/background-dark.jpg"
            },
            "onboarding_image": {
                "light": "https://yastatic.net/s3/disk/promo/february-14-2022/disk-ios/onboarding/image-light.png",
                "dark": "https://yastatic.net/s3/disk/promo/february-14-2022/disk-ios/onboarding/image-dark.png"
            },
            "onboarding_background": {
                "light": "https://yastatic.net/s3/disk/promo/february-14-2022/disk-ios/onboarding/background-light.jpg",
                "dark": "https://yastatic.net/s3/disk/promo/february-14-2022/disk-ios/onboarding/background-dark.jpg"
            }
        }
    ]
}
', 1, now()),
       ((select id from promo_templates where code = '14_february_mobile_2022'),
        'mobile_mail'::payload_type,
        '
{
    "strings": [
        {
            "version": 1,
            "currency": "rub",
            "platform": "*",
            "owner": "mail",
            "promo_page": {
                "title_tanker": {
                    "tanker_project": "disk-ps-billing",
                    "tanker_key_set": "promos",
                    "tanker_key": "mail_mobile_purchases_title_rub"
                }
            },
            "onboarding": {
                "first": {
                    "title_tanker": {
                        "tanker_project": "disk-ps-billing",
                        "tanker_key_set": "promos",
                        "tanker_key": "mail_mobile_onboarding_title_rub"
                    },
                    "description_tanker": {
                        "tanker_project": "disk-ps-billing",
                        "tanker_key_set": "promos",
                        "tanker_key": "mail_mobile_onboarding_text_rub"
                    },
                    "button_text_tanker": {
                        "tanker_project": "disk-ps-billing",
                        "tanker_key_set": "promos",
                        "tanker_key": "mail_mobile_onboarding_button_rub"
                    }
                }
            }
        },
        {
            "version": 1,
            "currency": "*",
            "platform": "*",
            "owner": "mail",
            "promo_page": {
                "title_tanker": {
                    "tanker_project": "disk-ps-billing",
                    "tanker_key_set": "promos",
                    "tanker_key": "mail_mobile_purchases_title_default"
                }
            },
            "onboarding": {
                "first": {
                    "title_tanker": {
                        "tanker_project": "disk-ps-billing",
                        "tanker_key_set": "promos",
                        "tanker_key": "mail_mobile_onboarding_title_default"
                    },
                    "description_tanker": {
                        "tanker_project": "disk-ps-billing",
                        "tanker_key_set": "promos",
                        "tanker_key": "mail_mobile_onboarding_text_default"
                    },
                    "button_text_tanker": {
                        "tanker_project": "disk-ps-billing",
                        "tanker_key_set": "promos",
                        "tanker_key": "mail_mobile_onboarding_button_default"
                    }
                }
            }
        }
    ],
    "images": []
}', 1, now());
