/* pgmigrate-encoding: utf-8 */
-- CHEMODAN-81537
-- add_optional_letters_archive

-- добавляем фичу доступности тайничка (ходит в тайничок с group_id)

with host as (
    select case
    when (select (select value from environment where key = 'env') in ('prod', 'prestable'))
    then 'https://spaniel.mail.yandex.net'
    else 'https://spaniel-test.mail.yandex.net'
    end
)
insert into features(code, created_at, updated_at, system_tvm_id, type, description, system_name,
                     activation_url_http_method, activation_url_template, set_amount_url_http_method,
                     set_amount_url_template, deactivation_url_http_method, deactivation_url_template,
                     call_set_amount_on_activation, call_set_amount_on_deactivation, activation_body_template,
                     set_amount_body_template, deactivation_body_template, activation_content_type,
                     deactivation_content_type, set_amount_content_type, error_processor_name)
values ('mail_b2b_can_use_letters_archive',
       now(),
       now(),
       null,
       'toggleable',
       'Фича "Тайничок" в Яндекс.Почте',
       'spaniel',
       'POST',
       concat((select * from host), '/v1/organization/enable?org_id=#{groupExternalId}'),
       null,
       null,
       'POST',
       concat((select * from host), '/v1/organization/disable?org_id=#{groupExternalId}'),
       false,
       false,
       null,
       null,
       null,
       null,
       null,
       null,
       'default');

update product_features pf
set order_num = pf.order_num + 1
where
  pf.order_num > 2
  and pf.order_num < 999
  and pf.user_product_id in (
    select user_product_id
    from group_products
    where price > 0 and balance_product_name = 'mail_b2b');

insert into product_features(user_product_id, feature_id, amount, created_at, description_tanker_key_id, enabled,
                             group_tanker_key_id, value_tanker_key_id, order_num, code, scope)
select p.id,
       f.id,
       1,
       now(),
       null,
       false,
       null,
       null,
       3,
       f.code,
       'group'
from user_products p, features f
where p.id in (
    select user_product_id
    from group_products
    where price > 0 and balance_product_name = 'mail_b2b'
) and f.code = 'mail_b2b_can_use_letters_archive';

-- добавляем бесплатный груповый продукт активации тайничка

insert into product_templates
    (code, created_at)
values
    ('letters_archive', now());

insert into user_products(code, created_at, updated_at, title_tanker_key_id, product_owner_id, available_from,
                          billing_type, trust_subs_retry_charging_limit, trust_subs_retry_charging_delay,
                          trust_subs_grace_period, trust_service_id, trial_definition_id, code_family, product_template_id)
values ('letters_archive',
        now(),
        now(),
        null,
        (select id from product_owners where code = 'yandex_mail'),
        null,
        'group',
        null,
        null,
        null,
        null,
        null,
        'letters_archive',
        (select id from product_templates where code = 'letters_archive'));

insert into group_products(code, created_at, updated_at, user_product_id, balance_product_name, price, currency,
                           singleton, skip_transactions_export, trial_definition_id, available_to, hidden,
                           title_tanker_key_id, payment_type)
values
    ('letters_archive',
     now(),
     now(),
     (select id from user_products where code = 'letters_archive'),
     'mail_b2b',
     0,
     'RUB',
     true,
     true,
     null,
     null,
     true,
     null,
     'postpaid'::payment_type);

-- добавляем фичу активации тайничка (ходит в тайничок с user_id)

with host as (
    select case
    when (select (select value from environment where key = 'env') in ('prod', 'prestable'))
        then 'https://spaniel.mail.yandex.net'
    else 'https://spaniel-test.mail.yandex.net'
    end
)
insert into features(code, created_at, updated_at, system_tvm_id, type, description, system_name,
                     activation_url_http_method, activation_url_template, set_amount_url_http_method,
                     set_amount_url_template, deactivation_url_http_method, deactivation_url_template,
                     call_set_amount_on_activation, call_set_amount_on_deactivation, activation_body_template,
                     set_amount_body_template, deactivation_body_template, activation_content_type,
                     deactivation_content_type, set_amount_content_type, error_processor_name)
values ('mail_b2b_letters_archive',
        now(),
        now(),
        null,
        'toggleable',
        'Активация "Тайничка"',
        'spaniel',
        'POST',
        concat((select * from host), '/v1/user/enable?uid=#{uid}'),
        null,
        null,
        'POST',
        concat((select * from host), '/v1/user/disable?uid=#{uid}'),
        false,
        false,
        null,
        null,
        null,
        null,
        null,
        null,
        'default');

insert into product_features(user_product_id, feature_id, amount, created_at, description_tanker_key_id, enabled,
                             group_tanker_key_id, value_tanker_key_id, order_num, code, scope)
values (
       (select id from user_products where code = 'letters_archive'),
       (select id from features where code = 'mail_b2b_letters_archive'),
       1,
       now(),
       null,
       true,
       null,
       null,
       999,
       'mail_b2b_letters_archive',
       'user');
