/* pgmigrate-encoding: utf-8 */

create type card_purpose as enum ('b2b_primary', 'b2b', 'b2c', 'unknown');
create type card_status as enum ('active', 'expired', 'disabled');

create table cards
(
    id          UUID              not null primary key default uuid_generate_v4(),
    uid         text              not null,
    purpose     card_purpose      not null,
    external_id text              not null,
    currency    text              not null,
    created_at  timestamp         not null,
    status      card_status       not null,
    updated_at  timestamp         not null
);
create unique index cards_uid_external_id_currency_idx on cards (uid, external_id, currency);
create index cards_uid_purpose_currency_id_idx on cards (uid, purpose, currency);

alter table group_trust_payment_requests
    add constraint fk_cards foreign key (card_id)
    references cards (id);

create index group_trust_payment_requests_card_id_idx ON group_trust_payment_requests (card_id);
