/* pgmigrate-encoding: utf-8 */

-- получаем список продуктов, в которые добавится красивый адрес
create table affected_products(
    code text,
    product_line_id uuid
);

insert into affected_products
select up.code, product_line_id
from user_products_to_product_lines uptpl
     join user_products up   on uptpl.user_product_id = up.id
     join product_lines pl on uptpl.product_line_id = pl.id
     join product_sets ps on pl.product_set_id = ps.id
where up.code_family like '%standard%' and ps.key = 'mail_pro_b2c';

-- копируем продукты
select
   copy_products(apc.code, apc.code, concat(apc.code, '_beauty_address'))
from (select distinct code from affected_products) as apc;

create table new_products(
    code text
);

insert into new_products
select code from user_products
where code like '%_beauty_address';

-- передвигаем order_num
update product_features
set order_num = order_num + 1
where order_num <> 999
    and order_num >= 3
    and user_product_id in (
        select id from user_products
        where code in (select * from new_products)
    );

-- долбавляем фичу красивого адреса в новые продукты
insert into product_features(user_product_id, feature_id, amount, created_at, description_tanker_key_id, enabled,
                             group_tanker_key_id, value_tanker_key_id, order_num, code, scope)
select p.id,
       f.id,
       1,
       now(),
       null,
       true,
       (select id
        from tanker_keys
        where project = 'disk-ps-billing'
          and key_set = 'features'
          and key = 'mail_pro_b2c_group_mail'
       ),
       null,
       3,
       'mail_b2c_domain_enabled',
       'user'
from user_products p join features f on f.code = 'mail_b2c_domain_enabled'
where p.code in (select * from new_products);

-- добавляем новые линейки
DO
$do$
declare affected_line record;
begin
    for affected_line IN
    select * from product_lines where id in (select product_line_id from affected_products)
        LOOP
        update product_lines shifted_line set order_num = order_num + 1
        where affected_line.order_num <= shifted_line.order_num;

        insert into product_lines (product_set_id, created_at, order_num, selector_bean_el, description)
        values (
            affected_line.product_set_id,
            now(),
            affected_line.order_num,
            'productLineSelectorFactory.experimentIsActiveSelector("mail_360_beautiful_address_standard_exp")',
            concat(affected_line.description, ' (beauty address exp)'));
    END LOOP;
end
$do$;

-- добавляем новые продукты в новые линейки
insert into user_products_to_product_lines(product_line_id, user_product_id, order_num)
select (
    select id from product_lines
    where description = (
        select concat(description, ' (beauty address exp)') from product_lines
        where id = ap.product_line_id
    )
),
(select id from user_products where code = concat(ap.code, '_beauty_address')),
(select order_num from product_lines where id = ap.product_line_id)
from affected_products ap;

-- чистим временные таблицы
drop table affected_products;
drop table new_products;
