/* pgmigrate-encoding: utf-8 */

do $$
begin
-- если необходимые продукты уже есть, значит мы в тестинге/престейбле и еще раз катить миграцию не надо
perform from user_products where code like '%edu_optimal1000_trial_1y';
if not found then
-- копируем продукт 'prepaid_org_mail_pro_edu_optimal1000' -> 'prepaid_org_mail_pro_edu_optimal1000_trial_1y'
perform copy_products(
           'prepaid_org_mail_pro_edu_optimal1000',
           'prepaid_org_mail_pro_edu_optimal1000',
           'prepaid_org_mail_pro_edu_optimal1000_trial_1y');

-- добавляем групповой продукт с годовым триалом
with trial_def as (
    insert into trial_definitions (created_at, type, end_date, duration, duration_measurement, price, hidden,
                                   single_usage_comparison_key)
        values (now(), 'constant_period', null, 1, 'year', 0, false, 'mail_pro_b2b_trial_key')
        returning *
)
insert into group_products(code, created_at, updated_at, user_product_id, balance_product_name,
                           price, currency, singleton, trial_definition_id, available_to,
                           title_tanker_key_id)
select 'prepaid_org_mail_pro_edu_optimal1000_trial_1y',
       now(),
       now(),
       (select id from user_products where code = 'prepaid_org_mail_pro_edu_optimal1000_trial_1y'),
       g.balance_product_name,
       g.price,
       g.currency,
       g.singleton,
       (select id from trial_def),
       g.available_to,
       g.title_tanker_key_id
from group_products g
where g.code = 'prepaid_org_mail_pro_edu_optimal1000';

-- заменяем продукт в линейке
update group_products_to_product_lines
set group_product_id=(select id from group_products where code = 'prepaid_org_mail_pro_edu_optimal1000_trial_1y')
where group_product_id=(select id from group_products where code = 'prepaid_org_mail_pro_edu_optimal1000');

-- добавляем новые танкерные ключи, чтобы заменить 'сотрудников' на 'пользователей'
-- в фиче 'mpfs_disk_space_for_b2b_mail_360' для тарифов образования
insert into tanker_keys (created_at, project, key_set, key)
values (now(), 'sarah', 'products', 'features-100gb-disk-edu-title');

update product_features pf
set description_tanker_key_id = (select id from tanker_keys where key='features-100gb-disk-edu-title')
where pf.user_product_id in (
    select id from user_products
    where code = 'mail_pro_b2b_edu_standard100'
       or code = 'prepaid_org_mail_pro_edu_standard100'
) and pf.code = 'mpfs_disk_space_for_b2b_mail_360';

insert into tanker_keys (created_at, project, key_set, key)
values (now(), 'sarah', 'products', 'features-1tb-disk-edu-title');

update product_features pf
set description_tanker_key_id = (select id from tanker_keys where key='features-1tb-disk-edu-title')
where pf.user_product_id in (
    select id from user_products
    where code = 'mail_pro_b2b_edu_premium1000'
       or code = 'prepaid_org_mail_pro_edu_optimal1000'
       or code = 'prepaid_org_mail_pro_edu_optimal1000_trial_1y'
) and pf.code = 'mpfs_disk_space_for_b2b_mail_360';

insert into tanker_keys (created_at, project, key_set, key)
values (now(), 'sarah', 'products', 'features-3tb-disk-edu-title');

update product_features pf
set description_tanker_key_id = (select id from tanker_keys where key='features-3tb-disk-edu-title')
where pf.user_product_id in (
    select id from user_products
    where code = 'mail_pro_b2b_edu_premium3000'
       or code = 'prepaid_org_mail_pro_edu_advanced3000'
) and pf.code = 'mpfs_disk_space_for_b2b_mail_360';

end if;
return;
end $$;

update group_products set payment_type = 'prepaid'::payment_type
where code = 'prepaid_org_mail_pro_edu_optimal1000_trial_1y';
