create or replace function copy_group_product(code_from text, code_to text)
    RETURNS int
    LANGUAGE plpgsql AS
$function$
BEGIN
    perform copy_products(code_from, code_from, code_to);
    insert
    into group_products(code, created_at, updated_at, user_product_id, balance_product_name,
                        price, currency, singleton, trial_definition_id, available_to,
                        title_tanker_key_id)
    select code_to,
           now(),
           now(),
           (select id from user_products where code = code_to),
           g.balance_product_name,
           g.price,
           g.currency,
           g.singleton,
           g.trial_definition_id,
           g.available_to,
           g.title_tanker_key_id
    from group_products g
    where g.code = code_from;
    RETURN 0;
END
$function$;

select copy_group_product('prepaid_org_mail_pro_standard100', 'prepaid_org_mail_pro_standard100_trial30');
select copy_group_product('prepaid_org_mail_pro_optimal1000', 'prepaid_org_mail_pro_optimal1000_trial30');
select copy_group_product('prepaid_org_mail_pro_advanced3000', 'prepaid_org_mail_pro_advanced3000_trial30');

with trial_def as (
    insert into trial_definitions (created_at, type, end_date, duration, duration_measurement, price, hidden,
                                   single_usage_comparison_key)
        values (now(), 'constant_period', null, 1, 'month', 0, false, 'mail_pro_b2b_trial_key')
        returning *
)
update group_products g
set trial_definition_id = (select id from trial_def)
where g.code in ('prepaid_org_mail_pro_standard100_trial30',
                 'prepaid_org_mail_pro_optimal1000_trial30',
                 'prepaid_org_mail_pro_advanced3000_trial30');


update product_lines
set order_num = 251
where description = 'prepaid for b2b 360';

insert
into product_lines
    (product_set_id, created_at, order_num, selector_bean_el, description)
values ((select id from product_sets where key = 'mail_pro_b2b'), now(), 211,
        'productLineSelectorFactory.compositeAndSelector('
            'productLineSelectorFactory.availableUntilSelector("2022-09-01", '
            || 'productLineSelectorFactory.prepaidSelector()), '
            || 'productLineSelectorFactory.experimentIsActiveSelector("auto_pay_standard_trial"))',
        'prepaid for b2b 360 (standard trial)'),
       ((select id from product_sets where key = 'mail_pro_b2b'), now(), 211,
        'productLineSelectorFactory.compositeAndSelector('
            'productLineSelectorFactory.availableUntilSelector("2022-09-01", '
            || 'productLineSelectorFactory.prepaidSelector()), '
            || 'productLineSelectorFactory.experimentIsActiveSelector("auto_pay_optimal_trial"))',
        'prepaid for b2b 360 (optimal trial)'),
       ((select id from product_sets where key = 'mail_pro_b2b'), now(), 211,
        'productLineSelectorFactory.compositeAndSelector('
            'productLineSelectorFactory.availableUntilSelector("2022-09-01", '
            || 'productLineSelectorFactory.prepaidSelector()), '
            || 'productLineSelectorFactory.experimentIsActiveSelector("auto_pay_advanced_trial"))',
        'prepaid for b2b 360 (advanced trial)');

with products as
         (
             select 'prepaid_org_mail_pro_standard100_trial30' as code, 1 as order_num
             union all
             select 'prepaid_org_mail_pro_optimal1000' as code, 2
             union all
             select 'prepaid_org_mail_pro_advanced3000' as code, 3
         )
insert
into group_products_to_product_lines
    (product_line_id, group_product_id, order_num)
select pl.id, gp.id, p.order_num
from products p
         join group_products gp on gp.code = p.code,
     product_lines pl
where pl.description = 'prepaid for b2b 360 (standard trial)';


with products as
         (
             select 'prepaid_org_mail_pro_standard100' as code, 1 as order_num
             union all
             select 'prepaid_org_mail_pro_optimal1000_trial30' as code, 2
             union all
             select 'prepaid_org_mail_pro_advanced3000' as code, 3
         )
insert
into group_products_to_product_lines
    (product_line_id, group_product_id, order_num)
select pl.id, gp.id, p.order_num
from products p
         join group_products gp on gp.code = p.code,
     product_lines pl
where pl.description = 'prepaid for b2b 360 (optimal trial)';

with products as
         (
             select 'prepaid_org_mail_pro_standard100' as code, 1 as order_num
             union all
             select 'prepaid_org_mail_pro_optimal1000' as code, 2
             union all
             select 'prepaid_org_mail_pro_advanced3000_trial30' as code, 3
         )
insert
into group_products_to_product_lines
    (product_line_id, group_product_id, order_num)
select pl.id, gp.id, p.order_num
from products p
         join group_products gp on gp.code = p.code,
     product_lines pl
where pl.description = 'prepaid for b2b 360 (advanced trial)';
