/* pgmigrate-encoding: utf-8 */

insert into tanker_keys
(created_at, project, key_set, key)
values
    (now(), 'disk-ps-billing', 'features', 'sso');


with host as (
    select case
    when (select (select value from environment where key = 'env') in ('prod', 'prestable'))
    then 'https://api-internal.directory.ws.yandex.net'
    else 'https://api-internal-test.directory.ws.yandex.net'
    end
)
insert into features(code, created_at, updated_at, system_tvm_id, type, description, system_name,
                     activation_url_http_method, activation_url_template, set_amount_url_http_method,
                     set_amount_url_template, deactivation_url_http_method, deactivation_url_template,
                     call_set_amount_on_activation, call_set_amount_on_deactivation, activation_body_template,
                     set_amount_body_template, deactivation_body_template, activation_content_type,
                     deactivation_content_type, set_amount_content_type, error_processor_name)
values ('sso',
       now(),
       now(),
       null,
       'toggleable',
       'Доступность SSO',
       'sso',
       'POST',
       concat((select * from host), '/v11/organizations/#{groupExternalId}/features/sso_available/enable/'),
       null,
       null,
       'POST',
       concat((select * from host), '/v11/organizations/#{groupExternalId}/features/sso_available/disable/'),
       false,
       false,
       null,
       null,
       null,
       null,
       null,
       null,
       'default');

insert into product_features(user_product_id, feature_id, amount, created_at, description_tanker_key_id, enabled,
                             group_tanker_key_id, value_tanker_key_id, order_num, code, scope)
select p.id,
       f.id,
       1,
       now(),
       (select id from tanker_keys where project = 'disk-ps-billing' and key_set = 'features' and key = 'sso'),
       false,
      (select id from tanker_keys where project = 'disk-ps-billing' and key_set = 'features' and key = 'mail_pro_b2c_group_disk'),
       null,
       38,
       f.code,
       'group'
from user_products p, features f
where p.code in (
    'prepaid_org_mail_pro_optimal1000_trial30',
    'prepaid_org_mail_pro_advanced3000_trial30',
    'prepaid_org_mail_pro_optimal1000',
    'prepaid_org_mail_pro_edu_optimal1000',
    'prepaid_org_mail_pro_advanced3000',
    'prepaid_org_mail_pro_edu_advanced3000'
) and f.code = 'sso';
