/* pgmigrate-encoding: utf-8 */

-- двигаем остальные скидочные линейки
update product_lines
set order_num = order_num + 2
where order_num >= 1002
  and product_set_id = (select id from product_sets where key = 'mail_pro_b2c');

-- копируем продукты, выставляем параметры скидки
select copy_products('mail_pro_b2c_standard100_v20210610','mail_pro_b2c_standard100_v20210610','mail_pro_b2c_standard100_start_discount_50_2m_1y');
select setup_start_discount('mail_pro_b2c_standard100_start_discount_50_2m_1y', 'month', 'RUB', 'month', 1, 2, 34);
select setup_start_discount('mail_pro_b2c_standard100_start_discount_50_2m_1y', 'month', 'USD', 'month', 1, 2, 0.99);
select setup_start_discount('mail_pro_b2c_standard100_start_discount_50_2m_1y', 'year', 'RUB', 'year', 1, 1, 249);
select setup_start_discount('mail_pro_b2c_standard100_start_discount_50_2m_1y', 'year', 'USD', 'year', 1, 1, 4.99);

select copy_products('mail_pro_b2c_premium1000_v20210610','mail_pro_b2c_premium1000_v20210610','mail_pro_b2c_premium1000_start_discount_50_2m_1y');
select setup_start_discount('mail_pro_b2c_premium1000_start_discount_50_2m_1y', 'month', 'RUB', 'month', 1, 2, 99);
select setup_start_discount('mail_pro_b2c_premium1000_start_discount_50_2m_1y', 'month', 'USD', 'month', 1, 2, 1.24);
select setup_start_discount('mail_pro_b2c_premium1000_start_discount_50_2m_1y', 'year', 'RUB', 'year', 1, 1, 699);
select setup_start_discount('mail_pro_b2c_premium1000_start_discount_50_2m_1y', 'year', 'USD', 'year', 1, 1, 9.49);

select copy_products('mail_pro_b2c_premium3000_v20210610','mail_pro_b2c_premium3000_v20210610','mail_pro_b2c_premium3000_start_discount_50_2m_1y');
select setup_start_discount('mail_pro_b2c_premium3000_start_discount_50_2m_1y', 'month', 'RUB', 'month', 1, 2, 204);
select setup_start_discount('mail_pro_b2c_premium3000_start_discount_50_2m_1y', 'month', 'USD', 'month', 1, 2, 2.49);
select setup_start_discount('mail_pro_b2c_premium3000_start_discount_50_2m_1y', 'year', 'RUB', 'year', 1, 1, 1449);
select setup_start_discount('mail_pro_b2c_premium3000_start_discount_50_2m_1y', 'year', 'USD', 'year', 1, 1, 19.49);

-- добавляем новую скидочную линейку и добавляем в нее созданные продукты
-- остальные продукты копируем из линейки 'web default line'
with promo_line_id as
         (
             insert into product_lines (product_set_id, created_at, order_num, selector_bean_el, description)
                 values ((select id from product_sets where key = 'mail_pro_b2c'), now(), 1003,
                         (select selector_bean_el from product_lines where description = 'web default line'),
                         'web start discount 50')
                 returning id
         ),
     order_num as
         (
             select code, order_num
             from (
                      values ('%standard100\_%', 1),
                             ('%premium1000\_%', 2),
                             ('%premium3000\_%', 3),
                             ('%premium5000\_%', 4),
                             ('%premium10000\_%', 5),
                             ('%premium25000\_%', 6),
                             ('%premium50000\_%', 7)
                  ) s(code, order_num)
         )
insert into user_products_to_product_lines
    (product_line_id, user_product_id, order_num)
    (
        select promo_line_id.id, up.id, order_num
        from promo_line_id, user_products up
                 join order_num o on up.code like o.code
        where up.code like '%start_discount_50_2m_1y%'
           or (up.code in (select distinct up_inner.code from product_lines pl
                                    join user_products_to_product_lines uptpl on pl.id = uptpl.product_line_id
                                    join user_products up_inner on uptpl.user_product_id = up_inner.id
                           where pl.description = 'web default line'
                             and up_inner.code not like '%standard100\_%'
                             and up_inner.code not like '%premium1000\_%'
                             and up_inner.code not like '%premium3000\_%'))
    );


-- копируем standard продукт с экспериментом с красивым адресом, добавляем скидку
select copy_products('mail_pro_b2c_standard100_v20210610_beauty_address','mail_pro_b2c_standard100_v20210610_beauty_address','mail_pro_b2c_standard100_start_discount_50_2m_1y_beauty_address');
select setup_start_discount('mail_pro_b2c_standard100_start_discount_50_2m_1y_beauty_address', 'month', 'RUB', 'month', 1, 2, 34);
select setup_start_discount('mail_pro_b2c_standard100_start_discount_50_2m_1y_beauty_address', 'month', 'USD', 'month', 1, 2, 0.99);
select setup_start_discount('mail_pro_b2c_standard100_start_discount_50_2m_1y_beauty_address', 'year', 'RUB', 'year', 1, 1, 249);
select setup_start_discount('mail_pro_b2c_standard100_start_discount_50_2m_1y_beauty_address', 'year', 'USD', 'year', 1, 1, 4.99);

-- добавляем новую скидочную линейку с экспериментом с красивым адресом и добавляем в нее созданный продукт
-- остальные продукты копируем из ранее созданной линейки 'web start discount 50'
with promo_line_id as
         (
             insert into product_lines (product_set_id, created_at, order_num, selector_bean_el, description)
                 values ((select id from product_sets where key = 'mail_pro_b2c'), now(), 1002,
                         (select selector_bean_el from product_lines where description = 'web default line (beauty address exp)'),
                         'web start discount 50 (beauty address exp)')
                 returning id
         ),
     order_num as
         (
             select code, order_num
             from (
                      values ('%standard100\_%', 1),
                             ('%premium1000\_%', 2),
                             ('%premium3000\_%', 3),
                             ('%premium5000\_%', 4),
                             ('%premium10000\_%', 5),
                             ('%premium25000\_%', 6),
                             ('%premium50000\_%', 7)
                  ) s(code, order_num)
         )
insert into user_products_to_product_lines
(product_line_id, user_product_id, order_num)
    (
        select promo_line_id.id, up.id, order_num
        from promo_line_id, user_products up
                join order_num o on up.code like o.code
        where up.code like '%start_discount_50_2m_1y_beauty_address%'
           or (up.code in (select distinct up_inner.code from product_lines pl
                                    join user_products_to_product_lines uptpl on pl.id = uptpl.product_line_id
                                    join user_products up_inner on uptpl.user_product_id = up_inner.id
                           where pl.description = 'web start discount 50'
                             and up_inner.code not like '%standard100\_%'))
    );

-- промо для веба
insert into promo_templates
(code, description, promo_name_tanker_key_id, from_date, to_date, application_area, application_type, duration,
 duration_measurement, activation_email_template_key, created_at)
values ('march_web_2022', 'Мартовская акция 2022 для веба', null,
        '2022-03-09T00:00:00.000+0300' AT TIME ZONE 'UTC', '2022-03-22T00:00:00.000+0300' AT TIME ZONE 'UTC',
        'global'::promo_application_area, 'multiple_time'::promo_application_type, null, null, null, now());

insert into promo_product_lines(promo_template_id, product_line_id)
values ((select id from promo_templates where code = 'march_web_2022'),
        (select l.id from product_lines l
         where l.description = 'web start discount 50')),
       ((select id from promo_templates where code = 'march_web_2022'),
        (select l.id from product_lines l
         where l.description = 'web start discount 50 (beauty address exp)'));

-- payload'ы для веба
insert into tanker_keys (created_at, project, key_set, key)
values (now(), 'yandex_disk_web', 'view-subscription-onboarding', 'ufo_subscription_onboarding_M082022_heading');
insert into tanker_keys (created_at, project, key_set, key)
values (now(), 'yandex_disk_web', 'view-subscription-onboarding', 'ufo_subscription_onboarding_M082022_benefit_space_size');
insert into tanker_keys (created_at, project, key_set, key)
values (now(), 'yandex_disk_web', 'view-subscription-onboarding', 'ufo_subscription_onboarding_M082022_benefit_unlimit_video');
insert into tanker_keys (created_at, project, key_set, key)
values (now(), 'yandex_disk_web', 'view-subscription-onboarding', 'ufo_subscription_onboarding_M082022_benefit_no_ads');
insert into tanker_keys (created_at, project, key_set, key)
values (now(), 'yandex_disk_web', 'view-subscription-onboarding', 'ufo_subscription_onboarding_M082022_benefit_other');
insert into tanker_keys (created_at, project, key_set, key)
values (now(), 'yandex_disk_web', 'view-ads', 'ufo_ads__march_8_2022_discount_text');
insert into tanker_keys (created_at, project, key_set, key)
values (now(), 'yandex_disk_web', 'view-subscription-onboarding', 'ufo_subscription_onboarding_M082022_tooltip');
insert into tanker_keys (created_at, project, key_set, key)
values (now(), 'front-ps-tuning', 'custom-promo', 'promo-2022-march-8-title');
insert into tanker_keys (created_at, project, key_set, key)
values (now(), 'front-ps-tuning', 'custom-promo', 'promo-2022-march-8-description');
insert into tanker_keys (created_at, project, key_set, key)
values (now(), 'mail-liza', 'custom-promo', '2022_March_8_Onboarding_Header');
insert into tanker_keys (created_at, project, key_set, key)
values (now(), 'mail-liza', 'custom-promo', '2022_March_8_Onboarding_Benefit_Email');
insert into tanker_keys (created_at, project, key_set, key)
values (now(), 'mail-liza', 'custom-promo', '2022_March_8_Onboarding_Benefit_Optin');
insert into tanker_keys (created_at, project, key_set, key)
values (now(), 'mail-liza', 'custom-promo', '2022_March_8_Tooltip_Text');

insert into promo_payload (promo_id, payload_type, version, created_at, content)
select id, 'web_disk'::payload_type, 0, now(), '
{
  "onboarding": {
    "title_tanker": {
      "tanker_project": "yandex_disk_web",
      "tanker_key_set": "view-subscription-onboarding",
      "tanker_key": "ufo_subscription_onboarding_M082022_heading"
    },
    "background": "https://yastatic.net/s3/disk/promo/march-8-2022/web-disk/onboarding/bg.jpg",
    "illustration": "https://yastatic.net/s3/disk/promo/march-8-2022/web-disk/onboarding/pic.png",
    "benefits": [
      {
        "text_tanker": {
          "tanker_project": "yandex_disk_web",
          "tanker_key_set": "view-subscription-onboarding",
          "tanker_key": "ufo_subscription_onboarding_M082022_benefit_space_size"
        },
        "type": "other",
        "url": "https://yastatic.net/s3/disk/promo/march-8-2022/web-disk/onboarding/cloud.svg"
      },
      {
        "text_tanker": {
          "tanker_project": "yandex_disk_web",
          "tanker_key_set": "view-subscription-onboarding",
          "tanker_key": "ufo_subscription_onboarding_M082022_benefit_unlimit_video"
        },
        "type": "mobileVideo"
      },
      {
        "text_tanker": {
          "tanker_project": "yandex_disk_web",
          "tanker_key_set": "view-subscription-onboarding",
          "tanker_key": "ufo_subscription_onboarding_M082022_benefit_no_ads"
        },
        "type": "ads"
      },
      {
        "text_tanker": {
          "tanker_project": "yandex_disk_web",
          "tanker_key_set": "view-subscription-onboarding",
          "tanker_key": "ufo_subscription_onboarding_M082022_benefit_other"
        },
        "type": "other"
      }
    ]
  },
  "infoSpaceBlock": {
    "text_tanker": {
      "tanker_project": "yandex_disk_web",
      "tanker_key_set": "view-ads",
      "tanker_key": "ufo_ads__march_8_2022_discount_text"
    },
    "background": "https://yastatic.net/s3/disk/promo/march-8-2022/web-disk/info-space-block/bg.jpg",
    "imgUrl": "https://yastatic.net/s3/disk/promo/march-8-2022/web-disk/info-space-block/image.png",
    "imgSmallUrl": "https://yastatic.net/s3/disk/promo/march-8-2022/web-disk/info-space-block/mini.png"
  },
  "tooltip": {
    "text_tanker": {
      "tanker_project": "yandex_disk_web",
      "tanker_key_set": "view-subscription-onboarding",
      "tanker_key": "ufo_subscription_onboarding_M082022_tooltip"
    },
    "img": "https://yastatic.net/s3/disk/promo/march-8-2022/web-disk/discount-tooltip/img.png",
    "background": "https://yastatic.net/s3/disk/promo/march-8-2022/web-disk/discount-tooltip/bg.jpg",
    "width": 90,
    "height": 90,
    "leftOffset": -52,
    "bottomOffset": -40,
    "opaque": true
  }
}
'
from promo_templates where code = 'march_web_2022';

insert into promo_payload (promo_id, payload_type, version, created_at, content)
select id, 'web_tuning'::payload_type, 0, now(), '
{
  "text_tanker": { "tanker_project": "front-ps-tuning", "tanker_key_set": "custom-promo", "tanker_key": "promo-2022-march-8-title" },
  "description_tanker": { "tanker_project": "front-ps-tuning", "tanker_key_set": "custom-promo", "tanker_key": "promo-2022-march-8-description" },
  "background": "https://yastatic.net/s3/disk/promo/march-8-2022/web-tuning/bg.png",
  "illustration": "https://yastatic.net/s3/disk/promo/march-8-2022/web-tuning/grid-promo.png",
  "theme": "dark",
  "withSubtitle": false
}
'
from promo_templates where code = 'march_web_2022';

insert into promo_payload (promo_id, payload_type, version, created_at, content)
select id, 'web_mail'::payload_type, 0, now(), '
{
  "onboarding": {
    "title_tanker": {
      "tanker_project": "mail-liza",
      "tanker_key_set": "custom-promo",
      "tanker_key": "2022_March_8_Onboarding_Header"
    },
    "background": "https://yastatic.net/s3/disk/promo/march-8-2022/web-disk/onboarding/bg.jpg",
    "illustration": "https://yastatic.net/s3/disk/promo/march-8-2022/web-disk/onboarding/pic.png",
    "benefits": [
      {
        "text_tanker": {
          "tanker_project": "mail-liza",
          "tanker_key_set": "custom-promo",
          "tanker_key": "2022_March_8_Onboarding_Benefit_Email"
        },
        "type": "domain"
      },
      {
        "text_tanker": {
          "tanker_project": "mail-liza",
          "tanker_key_set": "custom-promo",
          "tanker_key": "2022_March_8_Onboarding_Benefit_Optin"
        },
        "type": "other",
        "url": "https://yastatic.net/s3/disk/promo/march-8-2022/web-disk/onboarding/optin.svg"
      },
      {
        "text_tanker": {
          "tanker_project": "yandex_disk_web",
          "tanker_key_set": "view-subscription-onboarding",
          "tanker_key": "ufo_subscription_onboarding_M082022_benefit_no_ads"
        },
        "type": "ads"
      },
      {
        "text_tanker": {
          "tanker_project": "yandex_disk_web",
          "tanker_key_set": "view-subscription-onboarding",
          "tanker_key": "ufo_subscription_onboarding_M082022_benefit_space_size"
        },
        "type": "other",
        "url": "https://yastatic.net/s3/disk/promo/march-8-2022/web-disk/onboarding/cloud.svg"
      }
    ]
  },
  "tooltip": {
    "text_tanker": {
      "tanker_project": "mail-liza",
      "tanker_key_set": "custom-promo",
      "tanker_key": "2022_March_8_Tooltip_Text"
    },
    "img": "https://yastatic.net/s3/disk/promo/march-8-2022/web-disk/discount-tooltip/img.png",
    "background": "https://yastatic.net/s3/disk/promo/march-8-2022/web-disk/discount-tooltip/bg.jpg",
    "width": 90,
    "height": 90,
    "leftOffset": -52,
    "bottomOffset": -40,
    "opaque": true
  }
}
'
from promo_templates where code = 'march_web_2022';

-- мобилы. отдельно, потому что есть баг с датой в мобилах MOBDISK-23958
with description_key as
         (
             insert into tanker_keys (created_at, project, key_set, key)
                 values (now(), 'disk-ps-billing', 'promos', 'march_2022_mobile_promo') returning id
         )

insert
into promo_templates
(code, description, promo_name_tanker_key_id, from_date, to_date, application_area, application_type, duration,
 duration_measurement, activation_email_template_key, mobile_payload, created_at)
values ('march_mobile_2022', 'Мартовская акция 2022 для мобильных',
        (select id from description_key),
        '2022-03-09T00:00:00.000+0300' AT TIME ZONE 'UTC', '2022-03-21T23:59:59.000+0300' AT TIME ZONE 'UTC', -- двигаем дату на секунду назад, чтобы мобилы правильно отобразили дату конца акции
        'global'::promo_application_area, 'one_time'::promo_application_type, null, null, null,
        null, now());

insert into promo_product_lines(promo_template_id, product_line_id)
select pt.id, l.id
from promo_templates pt,
     product_lines l
where l.description in ('ios mail default line', 'android introductory line', 'ios disk default line')
  and pt.code = 'march_mobile_2022';

-- payload'ы для мобил
insert into promo_payload (promo_id, payload_type, version, created_at, content)
select id, 'mobile'::payload_type, 0, now(), '
[
    {
        "version": 1,
        "currency": "rub",
        "platform": "*",
        "owner": "disk",
        "disk_space_block": {
            "tooltip_text_tanker": {
                "tanker_project": "disk-ps-billing",
                "tanker_key_set": "promos",
                "tanker_key": "disk_mobile_tooltip_rub"
            }
        },
        "promo_page": {
            "title_tanker": {
                "tanker_project": "disk-ps-billing",
                "tanker_key_set": "promos",
                "tanker_key": "disk_mobile_purchases_title_rub"
            }
        },
        "onboarding": {
            "first": {
                "title_tanker": {
                    "tanker_project": "disk-ps-billing",
                    "tanker_key_set": "promos",
                    "tanker_key": "disk_mobile_onboarding_title_rub"
                },
                "description_tanker": {
                    "tanker_project": "disk-ps-billing",
                    "tanker_key_set": "promos",
                    "tanker_key": "disk_mobile_onboarding_text_rub"
                },
                "button_text_tanker": {
                    "tanker_project": "disk-ps-billing",
                    "tanker_key_set": "promos",
                    "tanker_key": "disk_mobile_onboarding_button_rub"
                }
            }
        }
    },
    {
        "version": 1,
        "currency": "*",
        "platform": "*",
        "owner": "disk",
        "disk_space_block": {
            "tooltip_text_tanker": {
                "tanker_project": "disk-ps-billing",
                "tanker_key_set": "promos",
                "tanker_key": "disk_mobile_tooltip_default"
            }
        },
        "promo_page": {
            "title_tanker": {
                "tanker_project": "disk-ps-billing",
                "tanker_key_set": "promos",
                "tanker_key": "disk_mobile_purchases_title_default"
            }
        },
        "onboarding": {
            "first": {
                "title_tanker": {
                    "tanker_project": "disk-ps-billing",
                    "tanker_key_set": "promos",
                    "tanker_key": "disk_mobile_onboarding_title_default"
                },
                "description_tanker": {
                    "tanker_project": "disk-ps-billing",
                    "tanker_key_set": "promos",
                    "tanker_key": "disk_mobile_onboarding_text_default"
                },
                "button_text_tanker": {
                    "tanker_project": "disk-ps-billing",
                    "tanker_key_set": "promos",
                    "tanker_key": "disk_mobile_onboarding_button_default"
                }
            }
        }
    },
    {
        "version": 1,
        "currency": "rub",
        "platform": "*",
        "owner": "mail",
        "promo_page": {
            "title_tanker": {
                "tanker_project": "disk-ps-billing",
                "tanker_key_set": "promos",
                "tanker_key": "mail_mobile_purchases_title_rub"
            }
        },
        "onboarding": {
            "first": {
                "title_tanker": {
                    "tanker_project": "disk-ps-billing",
                    "tanker_key_set": "promos",
                    "tanker_key": "mail_mobile_onboarding_title_rub"
                },
                "description_tanker": {
                    "tanker_project": "disk-ps-billing",
                    "tanker_key_set": "promos",
                    "tanker_key": "mail_mobile_onboarding_text_rub"
                },
                "button_text_tanker": {
                    "tanker_project": "disk-ps-billing",
                    "tanker_key_set": "promos",
                    "tanker_key": "mail_mobile_onboarding_button_rub"
                }
            }
        }
    },
    {
        "version": 1,
        "currency": "*",
        "platform": "*",
        "owner": "mail",
        "promo_page": {
            "title_tanker": {
                "tanker_project": "disk-ps-billing",
                "tanker_key_set": "promos",
                "tanker_key": "mail_mobile_purchases_title_default"
            }
        },
        "onboarding": {
            "first": {
                "title_tanker": {
                    "tanker_project": "disk-ps-billing",
                    "tanker_key_set": "promos",
                    "tanker_key": "mail_mobile_onboarding_title_default"
                },
                "description_tanker": {
                    "tanker_project": "disk-ps-billing",
                    "tanker_key_set": "promos",
                    "tanker_key": "mail_mobile_onboarding_text_default"
                },
                "button_text_tanker": {
                    "tanker_project": "disk-ps-billing",
                    "tanker_key_set": "promos",
                    "tanker_key": "mail_mobile_onboarding_button_default"
                }
            }
        }
    }
]
'
from promo_templates where code = 'march_mobile_2022';

insert into promo_payload (promo_id, payload_type, version, created_at, content)
select id, 'mobile'::payload_type, 1, now(), '
{
    "strings": [
        {
            "version": 1,
            "currency": "rub",
            "platform": "*",
            "owner": "disk",
            "disk_space_block": {
                "tooltip_text_tanker": {
                    "tanker_project": "disk-ps-billing",
                    "tanker_key_set": "promos",
                    "tanker_key": "disk_mobile_tooltip_rub"
                }
            },
            "promo_page": {
                "title_tanker": {
                    "tanker_project": "disk-ps-billing",
                    "tanker_key_set": "promos",
                    "tanker_key": "disk_mobile_purchases_title_rub"
                }
            },
            "onboarding": {
                "first": {
                    "title_tanker": {
                        "tanker_project": "disk-ps-billing",
                        "tanker_key_set": "promos",
                        "tanker_key": "disk_mobile_onboarding_title_rub"
                    },
                    "description_tanker": {
                        "tanker_project": "disk-ps-billing",
                        "tanker_key_set": "promos",
                        "tanker_key": "disk_mobile_onboarding_text_rub"
                    },
                    "button_text_tanker": {
                        "tanker_project": "disk-ps-billing",
                        "tanker_key_set": "promos",
                        "tanker_key": "disk_mobile_onboarding_button_rub"
                    }
                }
            }
        },
        {
            "version": 1,
            "currency": "*",
            "platform": "*",
            "owner": "disk",
            "disk_space_block": {
                "tooltip_text_tanker": {
                    "tanker_project": "disk-ps-billing",
                    "tanker_key_set": "promos",
                    "tanker_key": "disk_mobile_tooltip_default"
                }
            },
            "promo_page": {
                "title_tanker": {
                    "tanker_project": "disk-ps-billing",
                    "tanker_key_set": "promos",
                    "tanker_key": "disk_mobile_purchases_title_default"
                }
            },
            "onboarding": {
                "first": {
                    "title_tanker": {
                        "tanker_project": "disk-ps-billing",
                        "tanker_key_set": "promos",
                        "tanker_key": "disk_mobile_onboarding_title_default"
                    },
                    "description_tanker": {
                        "tanker_project": "disk-ps-billing",
                        "tanker_key_set": "promos",
                        "tanker_key": "disk_mobile_onboarding_text_default"
                    },
                    "button_text_tanker": {
                        "tanker_project": "disk-ps-billing",
                        "tanker_key_set": "promos",
                        "tanker_key": "disk_mobile_onboarding_button_default"
                    }
                }
            }
        },
        {
            "version": 1,
            "currency": "rub",
            "platform": "*",
            "owner": "mail",
            "promo_page": {
                "title_tanker": {
                    "tanker_project": "disk-ps-billing",
                    "tanker_key_set": "promos",
                    "tanker_key": "mail_mobile_purchases_title_rub"
                }
            },
            "onboarding": {
                "first": {
                    "title_tanker": {
                        "tanker_project": "disk-ps-billing",
                        "tanker_key_set": "promos",
                        "tanker_key": "mail_mobile_onboarding_title_rub"
                    },
                    "description_tanker": {
                        "tanker_project": "disk-ps-billing",
                        "tanker_key_set": "promos",
                        "tanker_key": "mail_mobile_onboarding_text_rub"
                    },
                    "button_text_tanker": {
                        "tanker_project": "disk-ps-billing",
                        "tanker_key_set": "promos",
                        "tanker_key": "mail_mobile_onboarding_button_rub"
                    }
                }
            }
        },
        {
            "version": 1,
            "currency": "*",
            "platform": "*",
            "owner": "mail",
            "promo_page": {
                "title_tanker": {
                    "tanker_project": "disk-ps-billing",
                    "tanker_key_set": "promos",
                    "tanker_key": "mail_mobile_purchases_title_default"
                }
            },
            "onboarding": {
                "first": {
                    "title_tanker": {
                        "tanker_project": "disk-ps-billing",
                        "tanker_key_set": "promos",
                        "tanker_key": "mail_mobile_onboarding_title_default"
                    },
                    "description_tanker": {
                        "tanker_project": "disk-ps-billing",
                        "tanker_key_set": "promos",
                        "tanker_key": "mail_mobile_onboarding_text_default"
                    },
                    "button_text_tanker": {
                        "tanker_project": "disk-ps-billing",
                        "tanker_key_set": "promos",
                        "tanker_key": "mail_mobile_onboarding_button_default"
                    }
                }
            }
        }
    ],
    "images": [
        {
            "device": "phone",
            "platform": "android",
            "owner": "disk",
            "background": {
                "light": "https://yastatic.net/s3/disk/promo/march-8-2022/disk-android/phone/purchases/background-light.jpg",
                "dark": "https://yastatic.net/s3/disk/promo/march-8-2022/disk-android/phone/purchases/background-dark.jpg"
            },
            "onboarding_image": {
                "light": "https://yastatic.net/s3/disk/promo/march-8-2022/disk-android/phone/onboarding/image-light.png",
                "dark": "https://yastatic.net/s3/disk/promo/march-8-2022/disk-android/phone/onboarding/image-dark.png"
            },
            "onboarding_background": {
                "light": "https://yastatic.net/s3/disk/promo/march-8-2022/disk-android/phone/onboarding/background-light.jpg",
                "dark": "https://yastatic.net/s3/disk/promo/march-8-2022/disk-android/phone/onboarding/background-dark.jpg"
            }
        },
        {
            "device": "tablet",
            "platform": "android",
            "owner": "disk",
            "background": {
                "light": "https://yastatic.net/s3/disk/promo/march-8-2022/disk-android/tablet/purchases/background-light.jpg",
                "dark": "https://yastatic.net/s3/disk/promo/march-8-2022/disk-android/tablet/purchases/background-dark.jpg"
            },
            "onboarding_image": {
                "light": "https://yastatic.net/s3/disk/promo/march-8-2022/disk-android/tablet/onboarding/image-light.png",
                "dark": "https://yastatic.net/s3/disk/promo/march-8-2022/disk-android/tablet/onboarding/image-dark.png"
            },
            "onboarding_background": {
                "light": "https://yastatic.net/s3/disk/promo/march-8-2022/disk-android/tablet/onboarding/background-light.jpg",
                "dark": "https://yastatic.net/s3/disk/promo/march-8-2022/disk-android/tablet/onboarding/background-dark.jpg"
            }
        },
        {
            "device": "*",
            "platform": "ios",
            "owner": "disk",
            "background": {
                "light": "https://yastatic.net/s3/disk/promo/march-8-2022/disk-ios/purchases/background-light.jpg",
                "dark": "https://yastatic.net/s3/disk/promo/march-8-2022/disk-ios/purchases/background-dark.jpg"
            },
            "onboarding_image": {
                "light": "https://yastatic.net/s3/disk/promo/march-8-2022/disk-ios/onboarding/image-light.png",
                "dark": "https://yastatic.net/s3/disk/promo/march-8-2022/disk-ios/onboarding/image-dark.png"
            },
            "onboarding_background": {
                "light": "https://yastatic.net/s3/disk/promo/march-8-2022/disk-ios/onboarding/background-light.jpg",
                "dark": "https://yastatic.net/s3/disk/promo/march-8-2022/disk-ios/onboarding/background-dark.jpg"
            }
        },
        {
            "device": "phone",
            "platform": "android",
            "owner": "mail",
            "background": {
                "light": "https://yastatic.net/s3/disk/promo/march-8-2022/mail-android/phone/purchases/background-light.jpg",
                "dark": "https://yastatic.net/s3/disk/promo/march-8-2022/mail-android/phone/purchases/background-dark.jpg"
            },
            "onboarding_image": {
                "light": "https://yastatic.net/s3/disk/promo/march-8-2022/mail-android/phone/onboarding/image-light.png",
                "dark": "https://yastatic.net/s3/disk/promo/march-8-2022/mail-android/phone/onboarding/image-dark.png"
            },
            "onboarding_background": {
                "light": "https://yastatic.net/s3/disk/promo/march-8-2022/mail-android/phone/onboarding/background-light.jpg",
                "dark": "https://yastatic.net/s3/disk/promo/march-8-2022/mail-android/phone/onboarding/background-dark.jpg"
            }
        },
        {
            "device": "tablet",
            "platform": "android",
            "owner": "mail",
            "background": {
                "light": "https://yastatic.net/s3/disk/promo/march-8-2022/mail-android/tablet/purchases/background-light.jpg",
                "dark": "https://yastatic.net/s3/disk/promo/march-8-2022/mail-android/tablet/purchases/background-dark.jpg"
            },
            "onboarding_image": {
                "light": "https://yastatic.net/s3/disk/promo/march-8-2022/mail-android/tablet/onboarding/image-light.png",
                "dark": "https://yastatic.net/s3/disk/promo/march-8-2022/mail-android/tablet/onboarding/image-dark.png"
            },
            "onboarding_background": {
                "light": "https://yastatic.net/s3/disk/promo/march-8-2022/mail-android/tablet/onboarding/background-light.jpg",
                "dark": "https://yastatic.net/s3/disk/promo/march-8-2022/mail-android/tablet/onboarding/background-dark.jpg"
            }
        },
        {
            "device": "*",
            "platform": "ios",
            "owner": "mail",
            "background": {
                "light": "https://yastatic.net/s3/disk/promo/march-8-2022/mail-ios/purchases/background-light.jpg",
                "dark": "https://yastatic.net/s3/disk/promo/march-8-2022/mail-ios/purchases/background-dark.jpg"
            },
            "onboarding_image": {
                "light": "https://yastatic.net/s3/disk/promo/march-8-2022/mail-ios/onboarding/image-light.png",
                "dark": "https://yastatic.net/s3/disk/promo/march-8-2022/mail-ios/onboarding/image-dark.png"
            },
            "onboarding_background": {
                "light": "https://yastatic.net/s3/disk/promo/march-8-2022/mail-ios/onboarding/background-light.jpg",
                "dark": "https://yastatic.net/s3/disk/promo/march-8-2022/mail-ios/onboarding/background-dark.jpg"
            }
        }
    ]
}
'
from promo_templates where code = 'march_mobile_2022';

insert into promo_payload (promo_id, payload_type, version, created_at, content)
select id, 'mobile_disk'::payload_type, 1, now(), '
{
    "strings": [
        {
            "version": 1,
            "currency": "rub",
            "platform": "*",
            "owner": "disk",
            "disk_space_block": {
                "tooltip_text_tanker": {
                    "tanker_project": "disk-ps-billing",
                    "tanker_key_set": "promos",
                    "tanker_key": "disk_mobile_tooltip_rub"
                }
            },
            "promo_page": {
                "title_tanker": {
                    "tanker_project": "disk-ps-billing",
                    "tanker_key_set": "promos",
                    "tanker_key": "disk_mobile_purchases_title_rub"
                }
            },
            "onboarding": {
                "first": {
                    "title_tanker": {
                        "tanker_project": "disk-ps-billing",
                        "tanker_key_set": "promos",
                        "tanker_key": "disk_mobile_onboarding_title_rub"
                    },
                    "description_tanker": {
                        "tanker_project": "disk-ps-billing",
                        "tanker_key_set": "promos",
                        "tanker_key": "disk_mobile_onboarding_text_rub"
                    },
                    "button_text_tanker": {
                        "tanker_project": "disk-ps-billing",
                        "tanker_key_set": "promos",
                        "tanker_key": "disk_mobile_onboarding_button_rub"
                    }
                }
            }
        },
        {
            "version": 1,
            "currency": "*",
            "platform": "*",
            "owner": "disk",
            "disk_space_block": {
                "tooltip_text_tanker": {
                    "tanker_project": "disk-ps-billing",
                    "tanker_key_set": "promos",
                    "tanker_key": "disk_mobile_tooltip_default"
                }
            },
            "promo_page": {
                "title_tanker": {
                    "tanker_project": "disk-ps-billing",
                    "tanker_key_set": "promos",
                    "tanker_key": "disk_mobile_purchases_title_default"
                }
            },
            "onboarding": {
                "first": {
                    "title_tanker": {
                        "tanker_project": "disk-ps-billing",
                        "tanker_key_set": "promos",
                        "tanker_key": "disk_mobile_onboarding_title_default"
                    },
                    "description_tanker": {
                        "tanker_project": "disk-ps-billing",
                        "tanker_key_set": "promos",
                        "tanker_key": "disk_mobile_onboarding_text_default"
                    },
                    "button_text_tanker": {
                        "tanker_project": "disk-ps-billing",
                        "tanker_key_set": "promos",
                        "tanker_key": "disk_mobile_onboarding_button_default"
                    }
                }
            }
        }
    ],
    "images": [
        {
            "device": "phone",
            "platform": "android",
            "owner": "disk",
            "background": {
                "light": "https://yastatic.net/s3/disk/promo/march-8-2022/disk-android/phone/purchases/background-light.jpg",
                "dark": "https://yastatic.net/s3/disk/promo/march-8-2022/disk-android/phone/purchases/background-dark.jpg"
            },
            "onboarding_image": {
                "light": "https://yastatic.net/s3/disk/promo/march-8-2022/disk-android/phone/onboarding/image-light.png",
                "dark": "https://yastatic.net/s3/disk/promo/march-8-2022/disk-android/phone/onboarding/image-dark.png"
            },
            "onboarding_background": {
                "light": "https://yastatic.net/s3/disk/promo/march-8-2022/disk-android/phone/onboarding/background-light.jpg",
                "dark": "https://yastatic.net/s3/disk/promo/march-8-2022/disk-android/phone/onboarding/background-dark.jpg"
            }
        },
        {
            "device": "tablet",
            "platform": "android",
            "owner": "disk",
            "background": {
                "light": "https://yastatic.net/s3/disk/promo/march-8-2022/disk-android/tablet/purchases/background-light.jpg",
                "dark": "https://yastatic.net/s3/disk/promo/march-8-2022/disk-android/tablet/purchases/background-dark.jpg"
            },
            "onboarding_image": {
                "light": "https://yastatic.net/s3/disk/promo/march-8-2022/disk-android/tablet/onboarding/image-light.png",
                "dark": "https://yastatic.net/s3/disk/promo/march-8-2022/disk-android/tablet/onboarding/image-dark.png"
            },
            "onboarding_background": {
                "light": "https://yastatic.net/s3/disk/promo/march-8-2022/disk-android/tablet/onboarding/background-light.jpg",
                "dark": "https://yastatic.net/s3/disk/promo/march-8-2022/disk-android/tablet/onboarding/background-dark.jpg"
            }
        },
        {
            "device": "*",
            "platform": "ios",
            "owner": "disk",
            "background": {
                "light": "https://yastatic.net/s3/disk/promo/march-8-2022/disk-ios/purchases/background-light.jpg",
                "dark": "https://yastatic.net/s3/disk/promo/march-8-2022/disk-ios/purchases/background-dark.jpg"
            },
            "onboarding_image": {
                "light": "https://yastatic.net/s3/disk/promo/march-8-2022/disk-ios/onboarding/image-light.png",
                "dark": "https://yastatic.net/s3/disk/promo/march-8-2022/disk-ios/onboarding/image-dark.png"
            },
            "onboarding_background": {
                "light": "https://yastatic.net/s3/disk/promo/march-8-2022/disk-ios/onboarding/background-light.jpg",
                "dark": "https://yastatic.net/s3/disk/promo/march-8-2022/disk-ios/onboarding/background-dark.jpg"
            }
        }
    ]
}
'
from promo_templates where code = 'march_mobile_2022';

insert into promo_payload (promo_id, payload_type, version, created_at, content)
select id, 'mobile_mail'::payload_type, 1, now(), '
{
    "strings": [
        {
            "version": 1,
            "currency": "rub",
            "platform": "*",
            "owner": "mail",
            "promo_page": {
                "title_tanker": {
                    "tanker_project": "disk-ps-billing",
                    "tanker_key_set": "promos",
                    "tanker_key": "mail_mobile_purchases_title_rub"
                }
            },
            "onboarding": {
                "first": {
                    "title_tanker": {
                        "tanker_project": "disk-ps-billing",
                        "tanker_key_set": "promos",
                        "tanker_key": "mail_mobile_onboarding_title_rub"
                    },
                    "description_tanker": {
                        "tanker_project": "disk-ps-billing",
                        "tanker_key_set": "promos",
                        "tanker_key": "mail_mobile_onboarding_text_rub"
                    },
                    "button_text_tanker": {
                        "tanker_project": "disk-ps-billing",
                        "tanker_key_set": "promos",
                        "tanker_key": "mail_mobile_onboarding_button_rub"
                    }
                }
            }
        },
        {
            "version": 1,
            "currency": "*",
            "platform": "*",
            "owner": "mail",
            "promo_page": {
                "title_tanker": {
                    "tanker_project": "disk-ps-billing",
                    "tanker_key_set": "promos",
                    "tanker_key": "mail_mobile_purchases_title_default"
                }
            },
            "onboarding": {
                "first": {
                    "title_tanker": {
                        "tanker_project": "disk-ps-billing",
                        "tanker_key_set": "promos",
                        "tanker_key": "mail_mobile_onboarding_title_default"
                    },
                    "description_tanker": {
                        "tanker_project": "disk-ps-billing",
                        "tanker_key_set": "promos",
                        "tanker_key": "mail_mobile_onboarding_text_default"
                    },
                    "button_text_tanker": {
                        "tanker_project": "disk-ps-billing",
                        "tanker_key_set": "promos",
                        "tanker_key": "mail_mobile_onboarding_button_default"
                    }
                }
            }
        }
    ],
    "images": [
        {
            "device": "phone",
            "platform": "android",
            "owner": "mail",
            "background": {
                "light": "https://yastatic.net/s3/disk/promo/march-8-2022/mail-android/phone/purchases/background-light.jpg",
                "dark": "https://yastatic.net/s3/disk/promo/march-8-2022/mail-android/phone/purchases/background-dark.jpg"
            },
            "onboarding_image": {
                "light": "https://yastatic.net/s3/disk/promo/march-8-2022/mail-android/phone/onboarding/image-light.png",
                "dark": "https://yastatic.net/s3/disk/promo/march-8-2022/mail-android/phone/onboarding/image-dark.png"
            },
            "onboarding_background": {
                "light": "https://yastatic.net/s3/disk/promo/march-8-2022/mail-android/phone/onboarding/background-light.jpg",
                "dark": "https://yastatic.net/s3/disk/promo/march-8-2022/mail-android/phone/onboarding/background-dark.jpg"
            }
        },
        {
            "device": "tablet",
            "platform": "android",
            "owner": "mail",
            "background": {
                "light": "https://yastatic.net/s3/disk/promo/march-8-2022/mail-android/tablet/purchases/background-light.jpg",
                "dark": "https://yastatic.net/s3/disk/promo/march-8-2022/mail-android/tablet/purchases/background-dark.jpg"
            },
            "onboarding_image": {
                "light": "https://yastatic.net/s3/disk/promo/march-8-2022/mail-android/tablet/onboarding/image-light.png",
                "dark": "https://yastatic.net/s3/disk/promo/march-8-2022/mail-android/tablet/onboarding/image-dark.png"
            },
            "onboarding_background": {
                "light": "https://yastatic.net/s3/disk/promo/march-8-2022/mail-android/tablet/onboarding/background-light.jpg",
                "dark": "https://yastatic.net/s3/disk/promo/march-8-2022/mail-android/tablet/onboarding/background-dark.jpg"
            }
        },
        {
            "device": "*",
            "platform": "ios",
            "owner": "mail",
            "background": {
                "light": "https://yastatic.net/s3/disk/promo/march-8-2022/mail-ios/purchases/background-light.jpg",
                "dark": "https://yastatic.net/s3/disk/promo/march-8-2022/mail-ios/purchases/background-dark.jpg"
            },
            "onboarding_image": {
                "light": "https://yastatic.net/s3/disk/promo/march-8-2022/mail-ios/onboarding/image-light.png",
                "dark": "https://yastatic.net/s3/disk/promo/march-8-2022/mail-ios/onboarding/image-dark.png"
            },
            "onboarding_background": {
                "light": "https://yastatic.net/s3/disk/promo/march-8-2022/mail-ios/onboarding/background-light.jpg",
                "dark": "https://yastatic.net/s3/disk/promo/march-8-2022/mail-ios/onboarding/background-dark.jpg"
            }
        }
    ]
}
'
from promo_templates where code = 'march_mobile_2022';

-- возвращаем best_offer 1 ТБ, меняли в акции на 14 февраля
-- для андроида
update user_products
set is_best_offer = true
where code = 'mail_pro_b2c_premium1000_introductory_inapp_google';

update user_products
set is_best_offer = false
where code = 'mail_pro_b2c_standard100_introductory_inapp_google';

-- для ios
-- для линейки 'ios mail default line'
update user_products
set is_best_offer = true
where code = 'mail_pro_b2c_premium1000_inapp_apple';

update user_products
set is_best_offer = false
where code = 'mail_pro_b2c_standard100_inapp_apple';

-- для линейки 'ios disk default line'
update user_products
set is_best_offer = true
where code = 'mail_pro_b2c_premium1000_inapp_apple_for_disk';

update user_products
set is_best_offer = false
where code = 'mail_pro_b2c_standard100_inapp_apple_for_disk';
