create or replace function copy_group_product(code_from text, code_to text)
    RETURNS int
    LANGUAGE plpgsql AS
$function$
BEGIN
    perform copy_products(code_from, code_from, code_to);
    insert
    into group_products(code, created_at, updated_at, user_product_id, balance_product_name, price, currency, singleton,
                        skip_transactions_export, trial_definition_id, available_to, hidden, title_tanker_key_id,
                        is_best_offer, payment_type)
    select code_to,
           now(),
           now(),
           (select id from user_products where code = code_to),
           g.balance_product_name,
           g.price,
           g.currency,
           g.singleton,
           g.skip_transactions_export,
           g.trial_definition_id,
           g.available_to,
           g.hidden,
           g.title_tanker_key_id,
           g.is_best_offer,
           g.payment_type
    from group_products g
    where g.code = code_from;

    -- copy buckets
    insert into bucket_content (bucket_code, group_product_id, updated_at)
    select bc.bucket_code, (select id from group_products where code = code_to), now()
    from bucket_content bc
             join group_products gp on gp.id = bc.group_product_id
    where gp.code = code_from;

    RETURN 0;
END
$function$;

update group_products
set payment_type = 'prepaid'::payment_type
where code like 'prepaid%'
  and payment_type != 'prepaid'::payment_type;
