with lost_products as
         (select *
          from (values ('prepaid_org_mail_pro_standard100_trial30'),
                       ('prepaid_org_mail_pro_optimal1000_trial30'),
                       ('prepaid_org_mail_pro_advanced3000_trial30'),
                       ('prepaid_org_mail_pro_edu_optimal1000_trial_1y')) s (code)
         ),
     groups as
         (select *
          from (values ('group1'),
                       ('group2')) s (code))
insert
into bucket_content (bucket_code, group_product_id, created_at, updated_at)
select g.code, gp.id, now(), now()
from groups g,
     group_products gp
         join lost_products lp on lp.code = gp.code
