/* pgmigrate-encoding: utf-8 */

insert into tanker_keys (created_at, project, key_set, key)
values (now(), 'mail-liza', 'custom-promo', '2022_March_8_Onboarding_Benefit_No_Ads');

update promo_payload
set content = '
{
  "onboarding": {
    "title_tanker": {
      "tanker_project": "mail-liza",
      "tanker_key_set": "custom-promo",
      "tanker_key": "2022_March_8_Onboarding_Header"
    },
    "background": "https://yastatic.net/s3/disk/promo/march-8-2022/web-disk/onboarding/bg.jpg",
    "illustration": "https://yastatic.net/s3/disk/promo/march-8-2022/web-disk/onboarding/pic.png",
    "benefits": [
      {
        "text_tanker": {
          "tanker_project": "mail-liza",
          "tanker_key_set": "custom-promo",
          "tanker_key": "2022_March_8_Onboarding_Benefit_Email"
        },
        "type": "domain"
      },
      {
        "text_tanker": {
          "tanker_project": "mail-liza",
          "tanker_key_set": "custom-promo",
          "tanker_key": "2022_March_8_Onboarding_Benefit_No_Ads"
        },
        "type": "ads"
      },
      {
        "text_tanker": {
          "tanker_project": "yandex_disk_web",
          "tanker_key_set": "view-subscription-onboarding",
          "tanker_key": "ufo_subscription_onboarding_M082022_benefit_space_size"
        },
        "type": "other",
        "url": "https://yastatic.net/s3/disk/promo/march-8-2022/web-disk/onboarding/cloud.svg"
      },
      {
        "text_tanker": {
          "tanker_project": "yandex_disk_web",
          "tanker_key_set": "view-subscription-onboarding",
          "tanker_key": "ufo_subscription_onboarding_M082022_benefit_other"
        },
        "type": "other"
      }
    ]
  },
  "tooltip": {
    "text_tanker": {
      "tanker_project": "mail-liza",
      "tanker_key_set": "custom-promo",
      "tanker_key": "2022_March_8_Tooltip_Text"
    },
    "img": "https://yastatic.net/s3/disk/promo/march-8-2022/web-disk/discount-tooltip/img.png",
    "background": "https://yastatic.net/s3/disk/promo/march-8-2022/web-disk/discount-tooltip/bg.jpg",
    "width": 90,
    "height": 90,
    "leftOffset": -52,
    "bottomOffset": -40,
    "opaque": true
  }
}
'
where promo_id = (select id from promo_templates where code = 'march_web_2022')
  and payload_type = 'web_mail'::payload_type;
