/* pgmigrate-encoding: utf-8 */

-- правим order_num для существующих единственных продуктов в линейках
update user_products_to_product_lines
set order_num = 1
where user_product_id in
      (select up.id from product_lines
          join user_products_to_product_lines uptpl on product_lines.id = uptpl.product_line_id
          join user_products up on uptpl.user_product_id = up.id
       where description like '% (beauty address exp)'
         and description != 'web start discount 50 (beauty address exp)'
         and up.code like '%standard100\_%');

-- добавляем недостающие продукты из оригинальных линеек
with exp_line_to_original_line as (
        select exp_pl.id as exp_id, pl.id as original_id from product_lines exp_pl
            join product_lines pl on pl.description = replace(exp_pl.description, ' (beauty address exp)', '')
        where exp_pl.description like '% (beauty address exp)'
          and exp_pl.description != 'web start discount 50 (beauty address exp)'
    )
insert into user_products_to_product_lines
    (product_line_id, user_product_id, order_num)
    (
        select eltol.exp_id, up.id, uptpl.order_num from product_lines
            join user_products_to_product_lines uptpl on product_lines.id = uptpl.product_line_id
            join user_products up on uptpl.user_product_id = up.id
            join exp_line_to_original_line eltol on product_lines.id = eltol.original_id
        where up.code not like '%standard100\_%'
    );
