/* pgmigrate-encoding: utf-8 */

-- копируем продукты, меняем цены
select copy_group_product('prepaid_org_mail_pro_standard100_trial30', 'prepaid_org_mail_pro_standard100_trial30_april_2022');
select copy_group_product('prepaid_org_mail_pro_optimal1000_trial30', 'prepaid_org_mail_pro_optimal1000_trial30_april_2022');
select copy_group_product('prepaid_org_mail_pro_advanced3000_trial30', 'prepaid_org_mail_pro_advanced3000_trial30_april_2022');

update group_products set price = 153
where code = 'prepaid_org_mail_pro_standard100_trial30_april_2022';

update group_products set price = 311
where code = 'prepaid_org_mail_pro_optimal1000_trial30_april_2022';

update group_products set price = 824
where code = 'prepaid_org_mail_pro_advanced3000_trial30_april_2022';

-- убираем фичу тайника из стандарта
delete from product_features
where code = 'mail_b2b_can_use_letters_archive'
  and user_product_id = (select id from user_products
                         where code = 'prepaid_org_mail_pro_standard100_trial30_april_2022');

-- создаём новые линейки с новыми продуктами
with promo_line_id as (
        insert into product_lines (product_set_id, created_at, order_num, selector_bean_el, description)
            values ((select product_set_id from product_lines where description = 'prepaid for b2b 360 (standard trial)'), now(), 210,
                    'productLineSelectorFactory.compositeAndSelector(productLineSelectorFactory.availableFromSelector("2022-04-02", productLineSelectorFactory.prepaidSelector()), productLineSelectorFactory.availableUntilSelector("2022-09-01", productLineSelectorFactory.prepaidSelector()), productLineSelectorFactory.experimentIsActiveSelector("auto_pay_standard_trial"))',
                    'prepaid for b2b 360 april 2022 (standard trial)')
        returning id
    ),
    order_num as (
        select code, order_num
        from (values ('prepaid_org_mail_pro_standard100_trial30_april_2022', 1),
                     ('prepaid_org_mail_pro_optimal1000_april_2022', 2),
                     ('prepaid_org_mail_pro_advanced3000_april_2022', 3)
             ) s(code, order_num)
    )
insert into group_products_to_product_lines
    (product_line_id, group_product_id, order_num)
    (select promo_line_id.id, gp.id, order_num
     from promo_line_id, group_products gp
         join order_num o on gp.code like o.code);


with promo_line_id as (
        insert into product_lines (product_set_id, created_at, order_num, selector_bean_el, description)
            values ((select product_set_id from product_lines where description = 'prepaid for b2b 360 (optimal trial)'), now(), 210,
                    'productLineSelectorFactory.compositeAndSelector(productLineSelectorFactory.availableFromSelector("2022-04-02", productLineSelectorFactory.prepaidSelector()), productLineSelectorFactory.availableUntilSelector("2022-09-01", productLineSelectorFactory.prepaidSelector()), productLineSelectorFactory.experimentIsActiveSelector("auto_pay_optimal_trial"))',
                    'prepaid for b2b 360 april 2022 (optimal trial)')
        returning id
    ),
    order_num as (
        select code, order_num
        from (values ('prepaid_org_mail_pro_standard100_april_2022', 1),
                     ('prepaid_org_mail_pro_optimal1000_trial30_april_2022', 2),
                     ('prepaid_org_mail_pro_advanced3000_april_2022', 3)
             ) s(code, order_num)
    )
insert into group_products_to_product_lines
    (product_line_id, group_product_id, order_num)
    (select promo_line_id.id, gp.id, order_num
     from promo_line_id, group_products gp
         join order_num o on gp.code like o.code);


with promo_line_id as (
        insert into product_lines (product_set_id, created_at, order_num, selector_bean_el, description)
            values ((select product_set_id from product_lines where description = 'prepaid for b2b 360 (advanced trial)'), now(), 210,
                    'productLineSelectorFactory.compositeAndSelector(productLineSelectorFactory.availableFromSelector("2022-04-02", productLineSelectorFactory.prepaidSelector()), productLineSelectorFactory.availableUntilSelector("2022-09-01", productLineSelectorFactory.prepaidSelector()), productLineSelectorFactory.experimentIsActiveSelector("auto_pay_advanced_trial"))',
                    'prepaid for b2b 360 april 2022 (advanced trial)')
        returning id
    ),
    order_num as (
        select code, order_num
        from (values ('prepaid_org_mail_pro_standard100_april_2022', 1),
                     ('prepaid_org_mail_pro_optimal1000_april_2022', 2),
                     ('prepaid_org_mail_pro_advanced3000_trial30_april_2022', 3)
             ) s(code, order_num)
    )
insert into group_products_to_product_lines
    (product_line_id, group_product_id, order_num)
    (select promo_line_id.id, gp.id, order_num
     from promo_line_id, group_products gp
         join order_num o on gp.code like o.code);


-- убираем тайничок из описания постоплатных базовых продуктов
update product_features
set description_tanker_key_id = null
where product_features.code = 'mail_b2b_can_use_letters_archive'
  and user_product_id in (select id from user_products
                          where code in ('mail_pro_b2b_standard100',
                                         'mail_pro_b2b_standard200',
                                         'mail_pro_b2b_edu_standard100'));

