/* pgmigrate-encoding: utf-8 */

-- копируем продукты
select copy_group_product('prepaid_org_mail_pro_optimal1000', 'prepaid_org_mail_pro_optimal1000_sso_enabled');
select copy_group_product('prepaid_org_mail_pro_advanced3000', 'prepaid_org_mail_pro_advanced3000_sso_enabled');
select copy_group_product('prepaid_org_mail_pro_optimal1000_april_2022', 'prepaid_org_mail_pro_optimal1000_april_2022_sso_enabled');
select copy_group_product('prepaid_org_mail_pro_advanced3000_april_2022', 'prepaid_org_mail_pro_advanced3000_april_2022_sso_enabled');


-- включаем фичу sso в новых продуктах
update product_features
set enabled = true
where code = 'sso'
  and user_product_id in (select id from user_products
                          where code in ('prepaid_org_mail_pro_optimal1000_sso_enabled',
                                         'prepaid_org_mail_pro_advanced3000_sso_enabled',
                                         'prepaid_org_mail_pro_optimal1000_april_2022_sso_enabled',
                                         'prepaid_org_mail_pro_advanced3000_april_2022_sso_enabled'));

-- создаём новые линейки с новыми продуктами
with promo_line_id as (
        insert into product_lines (product_set_id, created_at, order_num, selector_bean_el, description)
            values ((select product_set_id from product_lines where description = 'prepaid for b2b 360 april 2022'), now(), 248,
                    'productLineSelectorFactory.compositeAndSelector(productLineSelectorFactory.availableFromSelector("2022-04-02", productLineSelectorFactory.prepaidSelector()), productLineSelectorFactory.experimentByOwnerIsActiveSelector("b2b_360_sso_enabled"))',
                    'prepaid for b2b 360 april 2022 sso enabled')
        returning id
    ),
    order_num as (
        select code, order_num
        from (values ('prepaid_org_mail_pro_standard100_april_2022', 1),
                     ('prepaid_org_mail_pro_optimal1000_april_2022_sso_enabled', 2),
                     ('prepaid_org_mail_pro_advanced3000_april_2022_sso_enabled', 3)
             ) s(code, order_num)
    )
insert into group_products_to_product_lines
    (product_line_id, group_product_id, order_num)
    (select promo_line_id.id, gp.id, order_num
     from promo_line_id, group_products gp
        join order_num o on gp.code like o.code);


with promo_line_id as (
    insert into product_lines (product_set_id, created_at, order_num, selector_bean_el, description)
        values ((select product_set_id from product_lines where description = 'prepaid for b2b 360'), now(), 249,
                'productLineSelectorFactory.compositeAndSelector(productLineSelectorFactory.prepaidSelector(), productLineSelectorFactory.experimentByOwnerIsActiveSelector("b2b_360_sso_enabled"))',
                'prepaid for b2b 360 sso enabled')
        returning id
    ),
    order_num as (
        select code, order_num
        from (values ('prepaid_org_mail_pro_standard100', 1),
                     ('prepaid_org_mail_pro_optimal1000_sso_enabled', 2),
                     ('prepaid_org_mail_pro_advanced3000_sso_enabled', 3)
             ) s(code, order_num)
    )
insert into group_products_to_product_lines
    (product_line_id, group_product_id, order_num)
    (select promo_line_id.id, gp.id, order_num
     from promo_line_id, group_products gp
        join order_num o on gp.code like o.code);
