/* pgmigrate-encoding: utf-8 */

/**
  test with
  cd ~/arcadia/disk/admin/salt/pg/salt/components/pg-code
  sudo -u postgres psql -c 'drop database ps_billing_local;' && sudo -u postgres psql -c 'create database ps_billing_local;'
  pgmigrate migrate -c "host='localhost' port=5432 dbname='ps_billing_local' user='postgres' password='postgres'" -t latest -d ps_billing_db

  affected tables:
  tanker_keys
  product_templates
  product_lines
  user_products_to_product_lines
  promo_product_lines
  promo_payload
  promo_templates

  --copy_product_insert
  product_features
  user_products
  user_product_periods
  user_product_prices

  --update
  user_products
  product_lines
  product_features
  user_product_periods
  user_product_prices

  --update setup_start_discount
  user_product_periods
  user_product_prices
 */

----------------backup the affected tables

CREATE TABLE backup_CHEMODAN_83006_tanker_keys AS TABLE tanker_keys;
CREATE TABLE backup_CHEMODAN_83006_product_templates AS TABLE product_templates;
CREATE TABLE backup_CHEMODAN_83006_user_products_to_product_lines AS TABLE user_products_to_product_lines;
CREATE TABLE backup_CHEMODAN_83006_promo_product_lines AS TABLE promo_product_lines;
CREATE TABLE backup_CHEMODAN_83006_promo_payload AS TABLE promo_payload;
CREATE TABLE backup_CHEMODAN_83006_promo_templates AS TABLE promo_templates;
CREATE TABLE backup_CHEMODAN_83006_user_products AS TABLE user_products;
CREATE TABLE backup_CHEMODAN_83006_product_lines AS TABLE product_lines;
CREATE TABLE backup_CHEMODAN_83006_product_features AS TABLE product_features;
CREATE TABLE backup_CHEMODAN_83006_user_product_periods AS TABLE user_product_periods;
CREATE TABLE backup_CHEMODAN_83006_user_product_prices AS TABLE user_product_prices;

/**
  validation scripts:
select * from tanker_keys except select * from backup_CHEMODAN_83006_tanker_keys;
select * from product_templates except select * from backup_CHEMODAN_83006_product_templates;
select pl.description, p.code, p.is_best_offer, ppl.* from (
select * from user_products_to_product_lines except select * from backup_CHEMODAN_83006_user_products_to_product_lines) ppl
    left join user_products p on p.id = ppl.user_product_id
    left join product_lines pl on pl.id = ppl.product_line_id
order by product_line_id, order_num;
select * from promo_product_lines except select * from backup_CHEMODAN_83006_promo_product_lines;
select * from promo_payload except select * from backup_CHEMODAN_83006_promo_payload;
select * from promo_templates except select * from backup_CHEMODAN_83006_promo_templates;
select * from user_products except select * from backup_CHEMODAN_83006_user_products;
--no order num
select id, product_set_id, created_at, selector_bean_el, description from product_lines
except
select id, product_set_id, created_at, selector_bean_el, description from backup_CHEMODAN_83006_product_lines;
--check order num shift
select id, product_set_id, created_at, order_num, selector_bean_el, description from product_lines
except
select id, product_set_id, created_at, order_num, selector_bean_el, description from backup_CHEMODAN_83006_product_lines   order by order_num;

select f.code, dt.key, gt.key, vt.key,
       pf.* from (
    select *
    from product_features
    except select * from backup_CHEMODAN_83006_product_features
    ) pf left join features f on f.id = pf.feature_id
    left join tanker_keys dt on dt.id = pf.description_tanker_key_id
    left join tanker_keys gt on gt.id = pf.group_tanker_key_id
    left join tanker_keys vt on vt.id = pf.value_tanker_key_id
order by pf.user_product_id, pf.order_num;

select * from user_product_periods except select * from backup_CHEMODAN_83006_user_product_periods;
select * from user_product_prices except select * from backup_CHEMODAN_83006_user_product_prices;

select * from backup_CHEMODAN_83006_tanker_keys except select * from tanker_keys;
select * from backup_CHEMODAN_83006_product_templates except select * from product_templates;
select * from backup_CHEMODAN_83006_user_products_to_product_lines except select * from user_products_to_product_lines;
select * from backup_CHEMODAN_83006_promo_product_lines except select * from promo_product_lines;
select * from backup_CHEMODAN_83006_promo_payload except select * from promo_payload;
select * from backup_CHEMODAN_83006_promo_templates except select * from promo_templates;
select * from backup_CHEMODAN_83006_user_products except select * from user_products;
select * from backup_CHEMODAN_83006_product_lines except select * from product_lines;
select * from backup_CHEMODAN_83006_product_features except select * from product_features;
select * from backup_CHEMODAN_83006_user_product_periods except select * from user_product_periods;
select * from backup_CHEMODAN_83006_user_product_prices except select * from user_product_prices;
 */

----------------stored helper procedures

create or replace function clone_line(
    base_line_description text,
    new_line_description text,
    new_product_line_order numeric
) returns void
    language plpgsql
as
$$
declare
    new_product_line_id uuid;
    base_product_set_id uuid;
    base_product_line_id uuid;
    base_product_line_order_occupied boolean;
BEGIN
    select id, product_set_id into base_product_line_id, base_product_set_id
    from product_lines
    where description = base_line_description;

    assert base_product_line_id is not null, 'base product line id not resolved';
    assert base_product_set_id is not null, 'base product set id not resolved';

    select count(*) > 0 into base_product_line_order_occupied
    from product_lines
    where product_set_id = base_product_set_id
      and order_num = new_product_line_order;

    if base_product_line_order_occupied then
        update product_lines set order_num = order_num + 1
        where
                product_set_id = base_product_set_id
          and order_num >= new_product_line_order;
    end if;

    insert into product_lines (product_set_id, created_at, order_num, selector_bean_el, description)
    select
        product_set_id, now(), new_product_line_order, selector_bean_el, new_line_description
    from product_lines where description = base_line_description returning id into new_product_line_id;

    -- just clone the line. new product will be set here in clone_and_replace_product
    insert into user_products_to_product_lines (product_line_id, user_product_id, order_num)
    select
        new_product_line_id,
        user_product_id,
        order_num
    from user_products_to_product_lines where product_line_id = base_product_line_id;
END
$$;

create or replace function clone_and_replace_product(
    new_user_product_code text,
    new_user_product_title_tanker_key text,
    new_template_code text,
    base_user_product_code text,
    target_product_line_description text
) returns void
language plpgsql
as
$$
declare
    new_product_template_id uuid;
    target_product_line_id uuid;
    new_user_product_title_tanker_id uuid;
    new_user_product_id uuid;
    base_user_product_id uuid;
BEGIN
    select id into base_user_product_id
    from user_products
    where code = base_user_product_code;

    select id into target_product_line_id
    from product_lines
    where description = target_product_line_description;

    assert base_user_product_id is not null, 'base user product id not resolved';
    assert target_product_line_id is not null, 'new product line id not resolved';

    assert exists (
        select 1
        from user_products_to_product_lines
        where user_product_id = base_user_product_id
          and product_line_id = target_product_line_id
        ), 'base product is not part of base product line';

    perform copy_products(
       base_user_product_code,
       base_user_product_code,
       new_user_product_code
    );

    insert into tanker_keys(created_at, project, key_set, key)
    values (now(), 'disk-ps-billing', 'products', new_user_product_title_tanker_key)
    on conflict(project, key_set, key) do update
        set key = excluded.key --otherwise it won't return id
    returning id into new_user_product_title_tanker_id;

    insert into product_templates (code) values (new_template_code)
    on conflict (code)  DO UPDATE set code = EXCLUDED.code
    returning id into new_product_template_id;

    update user_products
    set
        product_template_id = new_product_template_id,
        title_tanker_key_id = new_user_product_title_tanker_id
    where code = new_user_product_code;

    select id into new_user_product_id from user_products where code = new_user_product_code;

    update user_products_to_product_lines
    set
        user_product_id = new_user_product_id
    where product_line_id = target_product_line_id and user_product_id = base_user_product_id;

END
$$;

create or replace function link_promo(
    product_line_desciption text,
    promo_template_code text
) returns void
    language plpgsql
as
$$
begin

    insert into promo_product_lines(promo_template_id, product_line_id)
    select t.id, l.id
    from
        promo_templates t,
        product_lines l
    where
        l.description = product_line_desciption
    and t.code = promo_template_code
    and not exists (select 1 from promo_product_lines pp where pp.promo_template_id = t.id and pp.product_line_id = l.id);
end;
$$;

create or replace function create_promo_payload(
    promo_template_code text,
    promo_payload_type payload_type,
    promo_content text,
    the_version numeric = 1
) returns void
language plpgsql
as
$$
declare
    promo_template_id uuid;
BEGIN
    select id into promo_template_id from promo_templates where code = promo_template_code;
    assert promo_template_id is not null, 'Failed to resolve promo template by ID';

    insert into promo_payload (promo_id, payload_type, version, created_at, content)
    values (
            promo_template_id,
            promo_payload_type,
            the_version,
            now(),
            promo_content
    );

    insert into tanker_keys (created_at, project, key_set, key)
    select now(),
           matches[1]    project,
           matches[2]    keyset,
           matches[3] as key
    from regexp_matches(
        promo_content,
        '"tanker_project":\s"([a-zA-Z0-9\-_]+)",\s*"tanker_key_set": "([a-zA-Z0-9\-_]+)",\s*"tanker_key": "([a-zA-Z0-9\-_]+)"',
        'g'
    ) matches
    where not exists (
        select 1
        from tanker_keys t
        where t.project = matches[1] and t.key_set = matches[2] and t.key = matches[3]
    );
end;
$$;

------------------------------web line
select clone_line(
           'web default line',
           'web 2TB 2 year discount line',
           1002
           );
select clone_and_replace_product(
           'mail_pro_b2c_premium2000_v20210610',
           'mail_pro_b2c_premium2000',
           'mail_pro_b2c_premium2000',
           'mail_pro_b2c_premium1000_v20210610',
           'web 2TB 2 year discount line'
           );

------------------------------google line
select clone_line(
           'android introductory line',
           'android 2TB 2 year discount line',
           1002
           );
select clone_and_replace_product(
           'mail_pro_b2c_premium2000_introductory_inapp_google',
           'mail_pro_b2c_premium2000_android',
           'mail_pro_b2c_premium2000_inapp_google',
           'mail_pro_b2c_premium1000_introductory_inapp_google',
           'android 2TB 2 year discount line'
           );

------------------------------apple mail line
select clone_line(
           'ios mail default line',
           'apple mail 2TB 2 year discount line',
           1002
           );
select clone_and_replace_product(
           'mail_pro_b2c_premium2000_inapp_apple',
           'mail_pro_b2c_premium2000_ios',
           'mail_pro_b2c_premium2000_inapp_apple',
           'mail_pro_b2c_premium1000_inapp_apple',
           'apple mail 2TB 2 year discount line'
           );
------------------------------apple disk line
select clone_line(
           'ios disk default line',
           'apple disk 2TB 2 year discount line',
           1002
           );
select clone_and_replace_product(
           'mail_pro_b2c_premium2000_inapp_apple_for_disk',
           'mail_pro_b2c_premium2000_ios',
           'mail_pro_b2c_premium2000_inapp_apple_for_disk',
           'mail_pro_b2c_premium1000_inapp_apple_for_disk',
           'apple disk 2TB 2 year discount line'
           );
do
$do$
declare
    products text[] := array[
        'mail_pro_b2c_premium2000_v20210610',
        'mail_pro_b2c_premium2000_introductory_inapp_google',
        'mail_pro_b2c_premium2000_inapp_apple',
        'mail_pro_b2c_premium2000_inapp_apple_for_disk'
        ];
    start_period_len numeric;
    pf_2gb_tanker_id uuid;
    april_2022_mobile_promo_tanker_id uuid;
begin
    for i in 1..array_upper(products, 1)
    loop
        perform change_price(products[i], 'month', 329, null, null, 'RUB');
        perform change_price(products[i], 'year', 2350, null, null, 'RUB');
        perform change_price(products[i], 'month', 4.49, null, null, 'USD');
        perform change_price(products[i], 'year', 31.99, null, null, 'USD');

        -- 2 года только для веба, для остальных 1 год
        if products[i] = 'mail_pro_b2c_premium2000_v20210610' then
            start_period_len := 2;
        else
            start_period_len := 1;
        end if;

        perform setup_start_discount(products[i], 'year', 'RUB', 'year', start_period_len, 1, 999);
        perform setup_start_discount(products[i], 'year', 'USD', 'year', start_period_len, 1, 13.49);

    end loop;

    insert into tanker_keys(created_at, project, key_set, key)
    values (now(), 'disk-ps-billing', 'features', 'mail_pro_add_2tb')
    on conflict(project, key_set, key) do update
        set key = excluded.key --otherwise it won't return id
    returning id into pf_2gb_tanker_id;

    insert into tanker_keys(created_at, project, key_set, key)
    values (now(), 'disk-ps-billing', 'promos', 'april_2022_mobile_promo')
    on conflict(project, key_set, key) do update
        set key = excluded.key --otherwise it won't return id
    returning id into april_2022_mobile_promo_tanker_id;

    update product_features
    set
        value_tanker_key_id = pf_2gb_tanker_id
    where user_product_id in (select id from user_products where code in (
                   'mail_pro_b2c_premium2000_v20210610',
                   'mail_pro_b2c_premium2000_introductory_inapp_google',
                   'mail_pro_b2c_premium2000_inapp_apple_for_disk',
                   'mail_pro_b2c_premium2000_inapp_apple'
        ))
        and value_tanker_key_id = (select id from tanker_keys where key = 'mail_pro_add_1tb')
    ;

    insert into promo_templates
    (code, description, promo_name_tanker_key_id, from_date, to_date, application_area, application_type, duration,
     duration_measurement, activation_email_template_key, created_at)
    values ('april_2022_web', 'web promo for CHEMODAN-83006', april_2022_mobile_promo_tanker_id,
            '2022-04-11T00:00:00.000+0300' AT TIME ZONE 'UTC',
            '2022-04-26T00:00:00.000+0300' AT TIME ZONE 'UTC',
               --rest of the params are defaulted for CHEMODAN_83006
            'global'::promo_application_area, 'multiple_time'::promo_application_type, null, null, null, now()
           );

    insert into promo_templates
    (code, description, promo_name_tanker_key_id, from_date, to_date, application_area, application_type, duration,
     duration_measurement, activation_email_template_key, created_at)
    values ('april_2022_mobile', 'mobile promo for CHEMODAN-83006', april_2022_mobile_promo_tanker_id,
            '2022-04-11T00:00:00.000+0300' AT TIME ZONE 'UTC',
            '2022-04-25T23:59:59.000+0300' AT TIME ZONE 'UTC',
               --rest of the params are defaulted for CHEMODAN_83006
            'global'::promo_application_area, 'multiple_time'::promo_application_type, null, null, null, now()
           );

    insert into promo_templates
    (code, description, promo_name_tanker_key_id, from_date, to_date, application_area, application_type, duration,
     duration_measurement, activation_email_template_key, created_at)
    values ('april_2022_audit', 'audit promo for CHEMODAN-83006', april_2022_mobile_promo_tanker_id,
            '2022-03-01T00:00:00.000+0300' AT TIME ZONE 'UTC', -- дата в прошлом. включаем эту акцию лично аудиторам
            '2022-04-26T00:00:00.000+0300' AT TIME ZONE 'UTC',
               --rest of the params are defaulted for CHEMODAN_83006
            'per_user'::promo_application_area, 'multiple_time'::promo_application_type,  14, 'day', null, now()
           );
end
$do$;

update user_products
set
    is_best_offer = true,
    code_family = 'mail_pro_b2c_premium2000'
where code in (
    'mail_pro_b2c_premium2000_v20210610',
    'mail_pro_b2c_premium2000_introductory_inapp_google',
    'mail_pro_b2c_premium2000_inapp_apple_for_disk',
    'mail_pro_b2c_premium2000_inapp_apple'
);

update product_features
set amount = 2199023255552
where user_product_id in (
    select id from user_products where  code in (
        'mail_pro_b2c_premium2000_v20210610',
        'mail_pro_b2c_premium2000_introductory_inapp_google',
        'mail_pro_b2c_premium2000_inapp_apple_for_disk',
        'mail_pro_b2c_premium2000_inapp_apple'
    )
    and amount = 1099511627776
);

update user_product_periods
set trust_fiscal_title =replace(trust_fiscal_title, '1 ТБ', '2 ТБ')
where user_product_id in (
    select id from user_products where  code in (
        'mail_pro_b2c_premium2000_v20210610',
        'mail_pro_b2c_premium2000_introductory_inapp_google',
        'mail_pro_b2c_premium2000_inapp_apple_for_disk',
        'mail_pro_b2c_premium2000_inapp_apple'
    )
);

select link_promo('web 2TB 2 year discount line',       'april_2022_web');
select link_promo('android 2TB 2 year discount line',   'april_2022_mobile');
select link_promo('apple mail 2TB 2 year discount line','april_2022_mobile');
select link_promo('apple disk 2TB 2 year discount line','april_2022_mobile');

select link_promo('web 2TB 2 year discount line',       'april_2022_audit');
select link_promo('android 2TB 2 year discount line',   'april_2022_audit');
select link_promo('apple mail 2TB 2 year discount line','april_2022_audit');
select link_promo('apple disk 2TB 2 year discount line','april_2022_audit');

------------------Promo payloads

select create_promo_payload( 'april_2022_web', 'web_mail'::payload_type ,
'{
  "onboarding": {
    "title_tanker": {
      "tanker_project": "mail-liza",
      "tanker_key_set": "custom-promo",
      "tanker_key": "2022_April_2_Onboarding_Header"
    },
    "background": "https://yastatic.net/s3/disk/promo/april-2-2022/web-disk/onboarding/bg.jpg",
    "illustration": "https://yastatic.net/s3/disk/promo/april-2-2022/web-disk/onboarding/pic.png",
    "benefits": [
      {
        "text_tanker": {
          "tanker_project": "mail-liza",
          "tanker_key_set": "custom-promo",
          "tanker_key": "2022_April_2_Onboarding_Benefit_space"
        },
        "type": "cloud",
        "url": "https://yastatic.net/s3/disk/promo/april-2-2022/web-disk/onboarding/benefit-cloud.svg"
      },
      {
        "text_tanker": {
          "tanker_project": "mail-liza",
          "tanker_key_set": "custom-promo",
          "tanker_key": "2022_April_2_Onboarding_Benefit_domain"
        },
        "type": "omain",
        "url": "https://yastatic.net/s3/disk/promo/april-2-2022/web-disk/onboarding/benefit-domain.svg"
      },
      {
        "text_tanker": {
          "tanker_project": "mail-liza",
          "tanker_key_set": "custom-promo",
          "tanker_key": "2022_April_2_Onboarding_Benefit_ads"
        },
        "type": "chat",
        "url": "https://yastatic.net/s3/disk/promo/april-2-2022/web-disk/onboarding/benefit-chat.svg"
      },
      {
        "text_tanker": {
          "tanker_project": "mail-liza",
          "tanker_key_set": "custom-promo",
          "tanker_key": "2022_April_2_Onboarding_Benefit_other"
        },
        "type": "other",
        "url": "https://yastatic.net/s3/disk/promo/april-2-2022/web-disk/onboarding/benefit-effects.svg"
      }
    ]
  },
  "tooltip": {
    "text_tanker": {
      "tanker_project": "mail-liza",
      "tanker_key_set": "custom-promo",
      "tanker_key": "2022_April_2_Tooltip_Text"
    },
    "img": "https://yastatic.net/s3/disk/promo/april-2-2022/web-disk/discount-tooltip/img.png",
    "background": "https://yastatic.net/s3/disk/promo/april-2-2022/web-disk/discount-tooltip/bg.jpg",
    "width": 90,
    "height": 90,
    "leftOffset": -52,
    "bottomOffset": -40,
    "opaque": true
  }
}');


select create_promo_payload( 'april_2022_web', 'web_disk'::payload_type ,
'{
 "infoSpaceBlock": {
   "text_tanker": { "tanker_project": "yandex_disk_web", "tanker_key_set": "custom-promo", "tanker_key": "ufo_promo_april_2_2022_info_space_block" },
   "background": "https://yastatic.net/s3/disk/promo/april-2-2022/web-disk/info-space-block/bg.png",
   "imgUrl": "https://yastatic.net/s3/disk/promo/april-2-2022/web-disk/info-space-block/main.png",
   "imgSmallUrl": "https://yastatic.net/s3/disk/promo/april-2-2022/web-disk/info-space-block/small.png"
 },
 "tooltip": {
  "text_tanker": { "tanker_project": "yandex_disk_web", "tanker_key_set": "custom-promo", "tanker_key": "ufo_promo_april_2_2022_tooltip" },
  "img": "https://yastatic.net/s3/disk/promo/april-2-2022/web-disk/discount-tooltip/pic.png",
  "background": "https://yastatic.net/s3/disk/promo/april-2-2022/web-disk/discount-tooltip/bg.png",
  "width": 90,
  "height": 90,
  "leftOffset": -52,
  "bottomOffset": -40,
  "opaque": true
 },
 "onboarding": {
     "title_tanker": { "tanker_project": "yandex_disk_web", "tanker_key_set": "custom-promo", "tanker_key": "ufo_subscription_onboarding_April_2_2022_heading" },
     "benefits": [
                    {
                        "text_tanker": { "tanker_project": "yandex_disk_web", "tanker_key_set": "custom-promo", "tanker_key": "ufo_subscription_onboarding_April_2_2022_benefit_space_size" },
                        "type": "cloud",
                        "url": "https://yastatic.net/s3/disk/promo/april-2-2022/web-disk/onboarding/benefit-cloud.svg"
                    },
                    {
                        "text_tanker": { "tanker_project": "yandex_disk_web", "tanker_key_set": "custom-promo", "tanker_key": "ufo_subscription_onboarding_April_2_2022_benefit_unlim" },
                        "type": "unlim",
                        "url": "https://yastatic.net/s3/disk/promo/april-2-2022/web-disk/onboarding/benefit-unlim.svg"
                    },
                    {
                        "text_tanker": { "tanker_project": "yandex_disk_web", "tanker_key_set": "custom-promo", "tanker_key": "ufo_subscription_onboarding_April_2_2022_benefit_ads" },
                        "type": "chat",
                        "url": "https://yastatic.net/s3/disk/promo/april-2-2022/web-disk/onboarding/benefit-chat.svg"
                    },
                    {
                       "text_tanker": { "tanker_project": "yandex_disk_web", "tanker_key_set": "custom-promo", "tanker_key": "ufo_subscription_onboarding_April_2_2022_benefit_other" },
                        "type": "effects",
                        "url": "https://yastatic.net/s3/disk/promo/april-2-2022/web-disk/onboarding/benefit-effects.svg"
                    }

                ],
       "background": "https://yastatic.net/s3/disk/promo/april-2-2022/web-disk/onboarding/bg.jpg",
       "illustration_tanker": { "tanker_project": "yandex_disk_web", "tanker_key_set": "custom-promo", "tanker_key": "ufo_subscription_onboarding_April_2_2022_image" }
  }
}');

select create_promo_payload( 'april_2022_web', 'web_tuning'::payload_type ,
'{
 "text_tanker": { "tanker_project": "front-ps-tuning", "tanker_key_set": "custom-promo", "tanker_key": "promo-2022-april-2-title" },
 "description_tanker": { "tanker_project": "front-ps-tuning", "tanker_key_set": "custom-promo", "tanker_key": "promo-2022-april-2-description" },
 "landing_tanker": { "tanker_project": "front-ps-tuning", "tanker_key_set": "custom-promo", "tanker_key": "promo-2022-april-2-landing" },
 "background": "https://yastatic.net/s3/disk/promo/april-2-2022/web-tuning/bg.jpg",
 "illustration": "https://yastatic.net/s3/disk/promo/april-2-2022/web-tuning/grid-promo.png",
 "gridPromoPaddingBottom": 10,
 "theme": "dark"
}');
