/* pgmigrate-encoding: utf-8 */

--drop and recreate to automate tankers
delete from promo_payload
where promo_id in (select id from promo_templates where code = 'april_2022_web')
and payload_type in ('web_mail'::payload_type, 'web_tuning'::payload_type);

--from https://st.yandex-team.ru/CHEMODAN-83204
select create_promo_payload('april_2022_web', 'web_tuning'::payload_type,
'{
  "text_tanker": { "tanker_project": "front-ps-tuning", "tanker_key_set": "custom-promo", "tanker_key": "promo-2022-april-2-title" },
  "description_tanker": { "tanker_project": "front-ps-tuning", "tanker_key_set": "custom-promo", "tanker_key": "promo-2022-april-2-description" },
  "landing": {
    "text_tanker": { "tanker_project": "front-ps-tuning", "tanker_key_set": "custom-promo", "tanker_key": "promo-2022-april-2-landing" },
    "background": "linear-gradient(340.23deg, #5400A9 11.16%, #5D09A5 18.44%, #FFA158 47.1%)"
  },
  "background": "https://yastatic.net/s3/disk/promo/april-2-2022/web-tuning/bg.jpg",
  "illustration": "https://yastatic.net/s3/disk/promo/april-2-2022/web-tuning/grid-promo.png",
  "gridPromoPaddingBottom": 10,
  "theme": "dark",
  "uiTheme": {
    "bestOfferBorder": "2px solid rgba(247, 247, 255, 0.5)"
  }
}'
);
select create_promo_payload('april_2022_web', 'web_mail'::payload_type,
'{
  "onboarding": {
    "title_tanker": {
      "tanker_project": "mail-liza",
      "tanker_key_set": "custom-promo",
      "tanker_key": "2022_April_2_Onboarding_Header"
    },
    "background": "https://yastatic.net/s3/disk/promo/april-2-2022/web-disk/onboarding/bg.jpg",
    "illustration_tanker": {
      "tanker_project": "yandex_disk_web",
      "tanker_key_set": "custom-promo",
      "tanker_key": "ufo_subscription_onboarding_April_2_2022_image"
    },
    "benefits": [
      {
        "text_tanker": {
          "tanker_project": "mail-liza",
          "tanker_key_set": "custom-promo",
          "tanker_key": "2022_April_2_Onboarding_Benefit_space"
        },
        "type": "cloud",
        "url": "https://yastatic.net/s3/disk/promo/april-2-2022/web-disk/onboarding/benefit-cloud.svg"
      },
      {
        "text_tanker": {
          "tanker_project": "mail-liza",
          "tanker_key_set": "custom-promo",
          "tanker_key": "2022_April_2_Onboarding_Benefit_domain"
        },
        "type": "omain",
        "url": "https://yastatic.net/s3/disk/promo/april-2-2022/web-disk/onboarding/benefit-domain.svg"
      },
      {
        "text_tanker": {
          "tanker_project": "mail-liza",
          "tanker_key_set": "custom-promo",
          "tanker_key": "2022_April_2_Onboarding_Benefit_ads"
        },
        "type": "chat",
        "url": "https://yastatic.net/s3/disk/promo/april-2-2022/web-disk/onboarding/benefit-chat.svg"
      },
      {
        "text_tanker": {
          "tanker_project": "mail-liza",
          "tanker_key_set": "custom-promo",
          "tanker_key": "2022_April_2_Onboarding_Benefit_other"
        },
        "type": "other",
        "url": "https://yastatic.net/s3/disk/promo/april-2-2022/web-disk/onboarding/benefit-effects.svg"
      }
    ]
  },
  "tooltip": {
    "text_tanker": {
      "tanker_project": "mail-liza",
      "tanker_key_set": "custom-promo",
      "tanker_key": "2022_April_2_Tooltip_Text"
    },
    "img": "https://yastatic.net/s3/disk/promo/april-2-2022/web-disk/discount-tooltip/pic.png",
    "background": "https://yastatic.net/s3/disk/promo/april-2-2022/web-disk/discount-tooltip/bg.png",
    "width": 90,
    "height": 90,
    "leftOffset": -52,
    "bottomOffset": -40,
    "opaque": true
  }
}'
);

--mobile payloads from https://st.yandex-team.ru/CHEMODAN-83115
select create_promo_payload('april_2022_web', 'mobile_disk'::payload_type,
'{
    "strings": [
        {
            "version": 1,
            "currency": "rub",
            "platform": "*",
            "owner": "disk",
            "disk_space_block": {
                "tooltip_text_tanker": {
                    "tanker_project": "disk-ps-billing",
                    "tanker_key_set": "promos",
                    "tanker_key": "disk_mobile_tooltip_rub"
                }
            },
            "promo_page": {
                "title_tanker": {
                    "tanker_project": "disk-ps-billing",
                    "tanker_key_set": "promos",
                    "tanker_key": "disk_mobile_purchases_title_rub"
                }
            },
            "onboarding": {
                "first": {
                    "title_tanker": {
                        "tanker_project": "disk-ps-billing",
                        "tanker_key_set": "promos",
                        "tanker_key": "disk_mobile_onboarding_title_rub"
                    },
                    "description_tanker": {
                        "tanker_project": "disk-ps-billing",
                        "tanker_key_set": "promos",
                        "tanker_key": "disk_mobile_onboarding_text_rub"
                    },
                    "button_text_tanker": {
                        "tanker_project": "disk-ps-billing",
                        "tanker_key_set": "promos",
                        "tanker_key": "disk_mobile_onboarding_button_rub"
                    }
                }
            }
        },
        {
            "version": 1,
            "currency": "*",
            "platform": "*",
            "owner": "disk",
            "disk_space_block": {
                "tooltip_text_tanker": {
                    "tanker_project": "disk-ps-billing",
                    "tanker_key_set": "promos",
                    "tanker_key": "disk_mobile_tooltip_default"
                }
            },
            "promo_page": {
                "title_tanker": {
                    "tanker_project": "disk-ps-billing",
                    "tanker_key_set": "promos",
                    "tanker_key": "disk_mobile_purchases_title_default"
                }
            },
            "onboarding": {
                "first": {
                    "title_tanker": {
                        "tanker_project": "disk-ps-billing",
                        "tanker_key_set": "promos",
                        "tanker_key": "disk_mobile_onboarding_title_default"
                    },
                    "description_tanker": {
                        "tanker_project": "disk-ps-billing",
                        "tanker_key_set": "promos",
                        "tanker_key": "disk_mobile_onboarding_text_default"
                    },
                    "button_text_tanker": {
                        "tanker_project": "disk-ps-billing",
                        "tanker_key_set": "promos",
                        "tanker_key": "disk_mobile_onboarding_button_default"
                    }
                }
            }
        }
    ],
    "images": []
}',
1
);

select create_promo_payload('april_2022_web', 'mobile_mail'::payload_type,
'{
    "strings": [
        {
            "version": 1,
            "currency": "rub",
            "platform": "*",
            "owner": "mail",
            "promo_page": {
                "title_tanker": {
                    "tanker_project": "disk-ps-billing",
                    "tanker_key_set": "promos",
                    "tanker_key": "mail_mobile_purchases_title_rub"
                }
            },
            "onboarding": {
                "first": {
                    "title_tanker": {
                        "tanker_project": "disk-ps-billing",
                        "tanker_key_set": "promos",
                        "tanker_key": "mail_mobile_onboarding_title_rub"
                    },
                    "description_tanker": {
                        "tanker_project": "disk-ps-billing",
                        "tanker_key_set": "promos",
                        "tanker_key": "mail_mobile_onboarding_text_rub"
                    },
                    "button_text_tanker": {
                        "tanker_project": "disk-ps-billing",
                        "tanker_key_set": "promos",
                        "tanker_key": "mail_mobile_onboarding_button_rub"
                    }
                }
            }
        },
        {
            "version": 1,
            "currency": "*",
            "platform": "*",
            "owner": "mail",
            "promo_page": {
                "title_tanker": {
                    "tanker_project": "disk-ps-billing",
                    "tanker_key_set": "promos",
                    "tanker_key": "mail_mobile_purchases_title_default"
                }
            },
            "onboarding": {
                "first": {
                    "title_tanker": {
                        "tanker_project": "disk-ps-billing",
                        "tanker_key_set": "promos",
                        "tanker_key": "mail_mobile_onboarding_title_default"
                    },
                    "description_tanker": {
                        "tanker_project": "disk-ps-billing",
                        "tanker_key_set": "promos",
                        "tanker_key": "mail_mobile_onboarding_text_default"
                    },
                    "button_text_tanker": {
                        "tanker_project": "disk-ps-billing",
                        "tanker_key_set": "promos",
                        "tanker_key": "mail_mobile_onboarding_button_default"
                    }
                }
            }
        }
    ],
    "images": []
}',
1
);

select create_promo_payload('april_2022_web', 'mobile'::payload_type,
'[
    {
        "version": 1,
        "currency": "rub",
        "platform": "*",
        "owner": "disk",
        "disk_space_block": {
            "tooltip_text_tanker": {
                "tanker_project": "disk-ps-billing",
                "tanker_key_set": "promos",
                "tanker_key": "disk_mobile_tooltip_rub"
            }
        },
        "promo_page": {
            "title_tanker": {
                "tanker_project": "disk-ps-billing",
                "tanker_key_set": "promos",
                "tanker_key": "disk_mobile_purchases_title_rub"
            }
        },
        "onboarding": {
            "first": {
                "title_tanker": {
                    "tanker_project": "disk-ps-billing",
                    "tanker_key_set": "promos",
                    "tanker_key": "disk_mobile_onboarding_title_rub"
                },
                "description_tanker": {
                    "tanker_project": "disk-ps-billing",
                    "tanker_key_set": "promos",
                    "tanker_key": "disk_mobile_onboarding_text_rub"
                },
                "button_text_tanker": {
                    "tanker_project": "disk-ps-billing",
                    "tanker_key_set": "promos",
                    "tanker_key": "disk_mobile_onboarding_button_rub"
                }
            }
        }
    },
    {
        "version": 1,
        "currency": "*",
        "platform": "*",
        "owner": "disk",
        "disk_space_block": {
            "tooltip_text_tanker": {
                "tanker_project": "disk-ps-billing",
                "tanker_key_set": "promos",
                "tanker_key": "disk_mobile_tooltip_default"
            }
        },
        "promo_page": {
            "title_tanker": {
                "tanker_project": "disk-ps-billing",
                "tanker_key_set": "promos",
                "tanker_key": "disk_mobile_purchases_title_default"
            }
        },
        "onboarding": {
            "first": {
                "title_tanker": {
                    "tanker_project": "disk-ps-billing",
                    "tanker_key_set": "promos",
                    "tanker_key": "disk_mobile_onboarding_title_default"
                },
                "description_tanker": {
                    "tanker_project": "disk-ps-billing",
                    "tanker_key_set": "promos",
                    "tanker_key": "disk_mobile_onboarding_text_default"
                },
                "button_text_tanker": {
                    "tanker_project": "disk-ps-billing",
                    "tanker_key_set": "promos",
                    "tanker_key": "disk_mobile_onboarding_button_default"
                }
            }
        }
    },
    {
        "version": 1,
        "currency": "rub",
        "platform": "*",
        "owner": "mail",
        "promo_page": {
            "title_tanker": {
                "tanker_project": "disk-ps-billing",
                "tanker_key_set": "promos",
                "tanker_key": "mail_mobile_purchases_title_rub"
            }
        },
        "onboarding": {
            "first": {
                "title_tanker": {
                    "tanker_project": "disk-ps-billing",
                    "tanker_key_set": "promos",
                    "tanker_key": "mail_mobile_onboarding_title_rub"
                },
                "description_tanker": {
                    "tanker_project": "disk-ps-billing",
                    "tanker_key_set": "promos",
                    "tanker_key": "mail_mobile_onboarding_text_rub"
                },
                "button_text_tanker": {
                    "tanker_project": "disk-ps-billing",
                    "tanker_key_set": "promos",
                    "tanker_key": "mail_mobile_onboarding_button_rub"
                }
            }
        }
    },
    {
        "version": 1,
        "currency": "*",
        "platform": "*",
        "owner": "mail",
        "promo_page": {
            "title_tanker": {
                "tanker_project": "disk-ps-billing",
                "tanker_key_set": "promos",
                "tanker_key": "mail_mobile_purchases_title_default"
            }
        },
        "onboarding": {
            "first": {
                "title_tanker": {
                    "tanker_project": "disk-ps-billing",
                    "tanker_key_set": "promos",
                    "tanker_key": "mail_mobile_onboarding_title_default"
                },
                "description_tanker": {
                    "tanker_project": "disk-ps-billing",
                    "tanker_key_set": "promos",
                    "tanker_key": "mail_mobile_onboarding_text_default"
                },
                "button_text_tanker": {
                    "tanker_project": "disk-ps-billing",
                    "tanker_key_set": "promos",
                    "tanker_key": "mail_mobile_onboarding_button_default"
                }
            }
        }
    }
]',
0
);

select create_promo_payload('april_2022_web', 'mobile'::payload_type,
'{
    "strings": [
        {
            "version": 1,
            "currency": "rub",
            "platform": "*",
            "owner": "disk",
            "disk_space_block": {
                "tooltip_text_tanker": {
                    "tanker_project": "disk-ps-billing",
                    "tanker_key_set": "promos",
                    "tanker_key": "disk_mobile_tooltip_rub"
                }
            },
            "promo_page": {
                "title_tanker": {
                    "tanker_project": "disk-ps-billing",
                    "tanker_key_set": "promos",
                    "tanker_key": "disk_mobile_purchases_title_rub"
                }
            },
            "onboarding": {
                "first": {
                    "title_tanker": {
                        "tanker_project": "disk-ps-billing",
                        "tanker_key_set": "promos",
                        "tanker_key": "disk_mobile_onboarding_title_rub"
                    },
                    "description_tanker": {
                        "tanker_project": "disk-ps-billing",
                        "tanker_key_set": "promos",
                        "tanker_key": "disk_mobile_onboarding_text_rub"
                    },
                    "button_text_tanker": {
                        "tanker_project": "disk-ps-billing",
                        "tanker_key_set": "promos",
                        "tanker_key": "disk_mobile_onboarding_button_rub"
                    }
                }
            }
        },
        {
            "version": 1,
            "currency": "*",
            "platform": "*",
            "owner": "disk",
            "disk_space_block": {
                "tooltip_text_tanker": {
                    "tanker_project": "disk-ps-billing",
                    "tanker_key_set": "promos",
                    "tanker_key": "disk_mobile_tooltip_default"
                }
            },
            "promo_page": {
                "title_tanker": {
                    "tanker_project": "disk-ps-billing",
                    "tanker_key_set": "promos",
                    "tanker_key": "disk_mobile_purchases_title_default"
                }
            },
            "onboarding": {
                "first": {
                    "title_tanker": {
                        "tanker_project": "disk-ps-billing",
                        "tanker_key_set": "promos",
                        "tanker_key": "disk_mobile_onboarding_title_default"
                    },
                    "description_tanker": {
                        "tanker_project": "disk-ps-billing",
                        "tanker_key_set": "promos",
                        "tanker_key": "disk_mobile_onboarding_text_default"
                    },
                    "button_text_tanker": {
                        "tanker_project": "disk-ps-billing",
                        "tanker_key_set": "promos",
                        "tanker_key": "disk_mobile_onboarding_button_default"
                    }
                }
            }
        },
        {
            "version": 1,
            "currency": "rub",
            "platform": "*",
            "owner": "mail",
            "promo_page": {
                "title_tanker": {
                    "tanker_project": "disk-ps-billing",
                    "tanker_key_set": "promos",
                    "tanker_key": "mail_mobile_purchases_title_rub"
                }
            },
            "onboarding": {
                "first": {
                    "title_tanker": {
                        "tanker_project": "disk-ps-billing",
                        "tanker_key_set": "promos",
                        "tanker_key": "mail_mobile_onboarding_title_rub"
                    },
                    "description_tanker": {
                        "tanker_project": "disk-ps-billing",
                        "tanker_key_set": "promos",
                        "tanker_key": "mail_mobile_onboarding_text_rub"
                    },
                    "button_text_tanker": {
                        "tanker_project": "disk-ps-billing",
                        "tanker_key_set": "promos",
                        "tanker_key": "mail_mobile_onboarding_button_rub"
                    }
                }
            }
        },
        {
            "version": 1,
            "currency": "*",
            "platform": "*",
            "owner": "mail",
            "promo_page": {
                "title_tanker": {
                    "tanker_project": "disk-ps-billing",
                    "tanker_key_set": "promos",
                    "tanker_key": "mail_mobile_purchases_title_default"
                }
            },
            "onboarding": {
                "first": {
                    "title_tanker": {
                        "tanker_project": "disk-ps-billing",
                        "tanker_key_set": "promos",
                        "tanker_key": "mail_mobile_onboarding_title_default"
                    },
                    "description_tanker": {
                        "tanker_project": "disk-ps-billing",
                        "tanker_key_set": "promos",
                        "tanker_key": "mail_mobile_onboarding_text_default"
                    },
                    "button_text_tanker": {
                        "tanker_project": "disk-ps-billing",
                        "tanker_key_set": "promos",
                        "tanker_key": "mail_mobile_onboarding_button_default"
                    }
                }
            }
        }
    ],
    "images": []
}',
1
);

--since web only likes version 0 but we tested with both 1 and 0 before
insert into promo_payload (promo_id, payload_type, content, version, created_at)
select promo_id, payload_type, content, 0, created_at
from promo_payload
where version = 1
  and promo_id in (
    select id from promo_templates
    where code = 'april_2022_web'
      and payload_type in ('web_mail'::payload_type, 'web_tuning'::payload_type)
);

