/* pgmigrate-encoding: utf-8 */

/**
  test with
  select pt.code, pl.*
  from promo_payload pl, promo_templates pt
  where pl.promo_id = pt.id
   and pt.code in ('april_2022_web', 'april_2022_ios', 'april_2022_mobile')
  order by pl.payload_type, pl.version, pt.code ;

    select pt.code, pl.description
    from product_lines pl,
         promo_product_lines ppl,
         promo_templates pt
    where pl.id = ppl.product_line_id
      and pt.id = ppl.promo_template_id
      and pt.code in ('april_2022_web', 'april_2022_ios', 'april_2022_mobile', 'april_2022_audit')
 */

--ios promo should be enabled only on wednesday. hence new promo
insert into promo_templates
(code, description, promo_name_tanker_key_id, from_date, to_date, application_area, application_type, duration,
 duration_measurement, activation_email_template_key, created_at)
values ('april_2022_ios', 'ios promo for april 2022',
        (select id from tanker_keys where project = 'disk-ps-billing' and key_set = 'promos' and key = 'april_2022_mobile_promo'),
        '2022-04-13T00:00:00.000+0300' AT TIME ZONE 'UTC',
        '2022-04-25T23:59:59.000+0300' AT TIME ZONE 'UTC',
           --rest of the params are defaulted for CHEMODAN_83006
        'global'::promo_application_area, 'one_time'::promo_application_type, null, null, null, now()
       );

select link_promo('apple mail 2TB 2 year discount line','april_2022_ios');
select link_promo('apple disk 2TB 2 year discount line','april_2022_ios');

--unlink the mobile line because it remais only for android
delete from promo_product_lines
where promo_template_id in (select id from promo_templates where code = 'april_2022_mobile')
  and product_line_id in (select id from product_lines where description in (
    'apple mail 2TB 2 year discount line',
    'apple disk 2TB 2 year discount line'
    ));

insert into promo_payload (promo_id, payload_type, content, version, created_at)
with to_populate as (
    (select id from promo_templates where code = 'april_2022_mobile')
    union
    (select id from promo_templates where code = 'april_2022_ios')
    union
    (select id from promo_templates where code = 'april_2022_audit')
)
select
    promoids.id,
    ps.payload_type,
    ps.content,
    ps.version,
    now()
from promo_payload ps,to_populate promoids
where ps.promo_id in (select id from promo_templates where code = 'april_2022_web')
  and not exists (
      select 1 from promo_payload pe
      where pe.promo_id = promoids.id
        and pe.payload_type = ps.payload_type
        and pe.version = ps.version
      );
