insert into user_product_buckets
(code, created_at, user_product_id)
select distinct
    'mail360_trust' as code,
    now() as created_at,
    up.id as user_product_id
from product_sets ps
         join
     product_lines pl on ps.id = pl.product_set_id
         join
     user_products_to_product_lines uptpl on pl.id = uptpl.product_line_id
         join
     user_products up on uptpl.user_product_id = up.id
         join
     product_features pf on up.id = pf.user_product_id
         join
     features f on pf.feature_id = f.id
where ps.key = 'mail_pro_b2c'
  and f.code = 'mpfs_disk_space_for_mail_360'
  and pf.amount >= 5497558138880;


ALTER TABLE public.user_products_to_product_lines
    DISABLE TRIGGER delete_product_from_product_line_trigger;

delete
from user_products_to_product_lines
where user_product_id in (
    select distinct up.id
    from product_sets ps
             join
         product_lines pl on ps.id = pl.product_set_id
             join
         user_products_to_product_lines uptpl on pl.id = uptpl.product_line_id
             join
         user_products up on uptpl.user_product_id = up.id
             join
         product_features pf on up.id = pf.user_product_id
             join
         features f on pf.feature_id = f.id
    where ps.key = 'mail_pro_b2c'
      and f.code = 'mpfs_disk_space_for_mail_360'
      and pf.amount >= 5497558138880
);

ALTER TABLE public.user_products_to_product_lines
    ENABLE TRIGGER delete_product_from_product_line_trigger;

