/* pgmigrate-encoding: utf-8 */

insert into tanker_keys (created_at, project, key_set, key)
values
    (now(), 'disk-ps-billing', 'products', 'mail_pro_b2c_premium200');

insert into
    product_lines
(product_set_id, created_at, order_num, selector_bean_el, description)
values
    ((select id from public.product_sets where key = 'mail_pro_b2c'), now(), -1, 'productLineSelectorFactory.experimentIsActiveSelector("mail_360_exp_prices_1")', 'web default line exp v1'),
    ((select id from public.product_sets where key = 'mail_pro_b2c'), now(), 0, 'productLineSelectorFactory.experimentIsActiveSelector("mail_360_exp_prices_2")', 'web default line exp v2'),
    ((select id from public.product_sets where key = 'mail_pro_b2c'), now(), 1, 'productLineSelectorFactory.experimentIsActiveSelector("mail_360_exp_prices_3")', 'web default line exp v3'),
    ((select id from public.product_sets where key = 'mail_pro_b2c'), now(), 1019, 'productLineSelectorFactory.experimentIsActiveSelector("mail_360_exp_prices_1")', 'web discount 20% exp v1'),
    ((select id from public.product_sets where key = 'mail_pro_b2c'), now(), 1020, 'productLineSelectorFactory.experimentIsActiveSelector("mail_360_exp_prices_2")', 'web discount 20% exp v2'),
    ((select id from public.product_sets where key = 'mail_pro_b2c'), now(), 1021, 'productLineSelectorFactory.experimentIsActiveSelector("mail_360_exp_prices_3")', 'web discount 20% exp v3'),
    ((select id from public.product_sets where key = 'mail_pro_b2c'), now(), 1022, 'productLineSelectorFactory.experimentIsActiveSelector("mail_360_exp_prices_1")', 'web start discount 20% exp v1'),
    ((select id from public.product_sets where key = 'mail_pro_b2c'), now(), 1023, 'productLineSelectorFactory.experimentIsActiveSelector("mail_360_exp_prices_2")', 'web start discount 20% exp v2'),
    ((select id from public.product_sets where key = 'mail_pro_b2c'), now(), 1024, 'productLineSelectorFactory.experimentIsActiveSelector("mail_360_exp_prices_3")', 'web start discount 20% exp v3');

update product_lines set order_num = 1500 where order_num = 1017; -- update default promo newbie line
update product_lines set order_num = 1501 where order_num = 1018;-- update default promo please_come_back line

-- Копируем основные продукты
select copy_products('mail_pro_b2c_premium3000_v20210610', 'mail_pro_b2c_premium3000_v20210610','mail_pro_b2c_premium3000_v20220414_exp1');
select copy_products('mail_pro_b2c_premium3000_v20210610', 'mail_pro_b2c_premium3000_v20210610','mail_pro_b2c_premium3000_v20220414_exp2');
select copy_products('mail_pro_b2c_premium3000_v20210610', 'mail_pro_b2c_premium3000_v20210610','mail_pro_b2c_premium3000_v20220414_exp3');

select copy_products('mail_pro_b2c_premium1000_v20210610', 'mail_pro_b2c_premium1000_v20210610','mail_pro_b2c_premium1000_v20220414_exp1');
select copy_products('mail_pro_b2c_premium1000_v20210610', 'mail_pro_b2c_premium1000_v20210610','mail_pro_b2c_premium1000_v20220414_exp2');
select copy_products('mail_pro_b2c_premium1000_v20210610', 'mail_pro_b2c_premium1000_v20210610','mail_pro_b2c_premium1000_v20220414_exp3');

select copy_products('mail_pro_b2c_premium3000_v20210610', 'mail_pro_b2c_premium3000_v20210610','mail_pro_b2c_premium3000_discount20_v20220414_exp1');
select copy_products('mail_pro_b2c_premium3000_v20210610', 'mail_pro_b2c_premium3000_v20210610','mail_pro_b2c_premium3000_discount20_v20220414_exp2');
select copy_products('mail_pro_b2c_premium3000_v20210610', 'mail_pro_b2c_premium3000_v20210610','mail_pro_b2c_premium3000_discount20_v20220414_exp3');

select copy_products('mail_pro_b2c_premium1000_v20210610', 'mail_pro_b2c_premium1000_v20210610','mail_pro_b2c_premium1000_discount20_v20220414_exp1');
select copy_products('mail_pro_b2c_premium1000_v20210610', 'mail_pro_b2c_premium1000_v20210610','mail_pro_b2c_premium1000_discount20_v20220414_exp2');
select copy_products('mail_pro_b2c_premium1000_v20210610', 'mail_pro_b2c_premium1000_v20210610','mail_pro_b2c_premium1000_discount20_v20220414_exp3');

select copy_products('mail_pro_b2c_premium3000_v20210610', 'mail_pro_b2c_premium3000_v20210610','mail_pro_b2c_premium3000_start_discount20_v20220414_exp1');
select copy_products('mail_pro_b2c_premium3000_v20210610', 'mail_pro_b2c_premium3000_v20210610','mail_pro_b2c_premium3000_start_discount20_v20220414_exp2');
select copy_products('mail_pro_b2c_premium3000_v20210610', 'mail_pro_b2c_premium3000_v20210610','mail_pro_b2c_premium3000_start_discount20_v20220414_exp3');

select copy_products('mail_pro_b2c_premium1000_v20210610', 'mail_pro_b2c_premium1000_v20210610','mail_pro_b2c_premium1000_start_discount20_v20220414_exp1');
select copy_products('mail_pro_b2c_premium1000_v20210610', 'mail_pro_b2c_premium1000_v20210610','mail_pro_b2c_premium1000_start_discount20_v20220414_exp2');
select copy_products('mail_pro_b2c_premium1000_v20210610', 'mail_pro_b2c_premium1000_v20210610','mail_pro_b2c_premium1000_start_discount20_v20220414_exp3');

-- Добавляем шаблон для 200гб и копируем фичи
insert into
    product_templates
(code, created_at)
values
    ('mail_pro_b2c_premium200', now());

insert into
    product_template_features
(product_template_id, feature_id, amount, created_at, description_tanker_key_id, group_tanker_key_id, value_tanker_key_id, enabled, order_num, code)
select
    (select id from product_templates where code = 'mail_pro_b2c_premium200'),
    feature_id, amount, now(), description_tanker_key_id, group_tanker_key_id, value_tanker_key_id, enabled, order_num, ptf.code
from product_template_features ptf
         join product_templates pt on ptf.product_template_id = pt.id
where pt.code = 'mail_pro_b2c_premium1000';

update
    product_template_features
set
    amount = 214748364800
where
        product_template_id = (select id from product_templates where code = 'mail_pro_b2c_premium200') and
        code = 'mpfs_disk_space';

-- копируем 1тб продукт и применяем для него шаблон 200гб и меняем фичу
select copy_products('mail_pro_b2c_premium1000_v20210610', 'mail_pro_b2c_premium1000_v20210610','mail_pro_b2c_premium200_v20220414_exp1');
select copy_products('mail_pro_b2c_premium1000_v20210610', 'mail_pro_b2c_premium1000_v20210610','mail_pro_b2c_premium200_v20220414_exp2');
select copy_products('mail_pro_b2c_premium1000_v20210610', 'mail_pro_b2c_premium1000_v20210610','mail_pro_b2c_premium200_v20220414_exp3');
select copy_products('mail_pro_b2c_premium1000_v20210610', 'mail_pro_b2c_premium1000_v20210610','mail_pro_b2c_premium200_discount20_v20220414_exp1');
select copy_products('mail_pro_b2c_premium1000_v20210610', 'mail_pro_b2c_premium1000_v20210610','mail_pro_b2c_premium200_discount20_v20220414_exp2');
select copy_products('mail_pro_b2c_premium1000_v20210610', 'mail_pro_b2c_premium1000_v20210610','mail_pro_b2c_premium200_discount20_v20220414_exp3');
select copy_products('mail_pro_b2c_premium1000_v20210610', 'mail_pro_b2c_premium1000_v20210610','mail_pro_b2c_premium200_start_discount20_v20220414_exp1');
select copy_products('mail_pro_b2c_premium1000_v20210610', 'mail_pro_b2c_premium1000_v20210610','mail_pro_b2c_premium200_start_discount20_v20220414_exp2');
select copy_products('mail_pro_b2c_premium1000_v20210610', 'mail_pro_b2c_premium1000_v20210610','mail_pro_b2c_premium200_start_discount20_v20220414_exp3');

update user_products
set
    code_family = 'mail_pro_b2c_premium200',
    title_tanker_key_id = (select id from tanker_keys where project = 'disk-ps-billing' and key_set = 'products' and key = 'mail_pro_b2c_premium200'),
    product_template_id = (select id from product_templates where code = 'mail_pro_b2c_premium200'),
    is_best_offer = false
where code like 'mail_pro_b2c_premium200%v20220414_exp%';

update user_product_periods
set trust_fiscal_title = 'Яндекс 360 Премиум 200 ГБ на месяц'
where user_product_id in (select id from user_products where code like 'mail_pro_b2c_premium200_v20220414_exp%') and period = 'month';
update user_product_periods
set trust_fiscal_title = 'Яндекс 360 Премиум 200 ГБ на год'
where user_product_id in (select id from user_products where code like 'mail_pro_b2c_premium200_v20220414_exp%') and period = 'year';

update user_product_periods
set trust_fiscal_title = 'Яндекс 360 Премиум 200 ГБ на месяц'
where user_product_id in (select id from user_products where code like 'mail_pro_b2c_premium200%discount20_v20220414_exp%') and period = 'month';
update user_product_periods
set trust_fiscal_title = 'Яндекс 360 Премиум 200 ГБ на год'
where user_product_id in (select id from user_products where code like 'mail_pro_b2c_premium200%discount20_v20220414_exp%') and period = 'year';

update user_product_periods
set trust_fiscal_title = 'Яндекс 360 Премиум 1 ТБ на месяц'
where user_product_id in (select id from user_products where code like 'mail_pro_b2c_premium1000%discount20_v20220414_exp%') and period = 'month';
update user_product_periods
set trust_fiscal_title = 'Яндекс 360 Премиум 1 ТБ на год'
where user_product_id in (select id from user_products where code like 'mail_pro_b2c_premium1000%discount20_v20220414_exp%') and period = 'year';

update user_product_periods
set trust_fiscal_title = 'Яндекс 360 Премиум 3 ТБ на месяц'
where user_product_id in (select id from user_products where code like 'mail_pro_b2c_premium3000%discount20_v20220414_exp%') and period = 'month';
update user_product_periods
set trust_fiscal_title = 'Яндекс 360 Премиум 3 ТБ на год'
where user_product_id in (select id from user_products where code like 'mail_pro_b2c_premium3000%discount20_v20220414_exp%') and period = 'year';

update
    product_features
set
    amount = 214748364800,
    value_tanker_key_id = (select id from tanker_keys where project = 'disk-ps-billing' and key_set = 'features' and key = 'mail_pro_add_200gb')
where
        user_product_id in (select id from user_products where code like 'mail_pro_b2c_premium200%v20220414_exp%') and
        code in ('mpfs_disk_space', 'mail_pro_b2c_add_disk_space');

-- Устанавливаем цены
update user_product_prices set price = 149 where user_product_period_id = (select upp.id from user_product_periods upp join user_products up on upp.user_product_id = up.id where up.code = 'mail_pro_b2c_premium200_v20220414_exp1' and upp.period = 'month') and currency = 'RUB';
update user_product_prices set price = 999 where user_product_period_id = (select upp.id from user_product_periods upp join user_products up on upp.user_product_id = up.id where up.code = 'mail_pro_b2c_premium200_v20220414_exp1' and upp.period = 'year') and currency = 'RUB';
update user_product_prices set display_discount_percent = 20, display_original_price = 149, price = 129 where user_product_period_id = (select upp.id from user_product_periods upp join user_products up on upp.user_product_id = up.id where up.code = 'mail_pro_b2c_premium200_discount20_v20220414_exp1' and upp.period = 'month') and currency = 'RUB';
update user_product_prices set display_discount_percent = 20, display_original_price = 149, price = 129 where user_product_period_id = (select upp.id from user_product_periods upp join user_products up on upp.user_product_id = up.id where up.code = 'mail_pro_b2c_premium200_start_discount20_v20220414_exp1' and upp.period = 'month') and currency = 'RUB';
update user_product_prices set display_discount_percent = 20, display_original_price = 999, price = 799 where user_product_period_id = (select upp.id from user_product_periods upp join user_products up on upp.user_product_id = up.id where up.code = 'mail_pro_b2c_premium200_discount20_v20220414_exp1' and upp.period = 'year') and currency = 'RUB';
update user_product_prices set display_discount_percent = 20, display_original_price = 999, price = 799 where user_product_period_id = (select upp.id from user_product_periods upp join user_products up on upp.user_product_id = up.id where up.code = 'mail_pro_b2c_premium200_start_discount20_v20220414_exp1' and upp.period = 'year') and currency = 'RUB';
update user_product_prices set price = 1.99 where user_product_period_id = (select upp.id from user_product_periods upp join user_products up on upp.user_product_id = up.id where up.code = 'mail_pro_b2c_premium200_v20220414_exp1' and upp.period = 'month') and currency = 'USD';
update user_product_prices set price = 12.49 where user_product_period_id = (select upp.id from user_product_periods upp join user_products up on upp.user_product_id = up.id where up.code = 'mail_pro_b2c_premium200_v20220414_exp1' and upp.period = 'year') and currency = 'USD';
update user_product_prices set display_discount_percent = 20, display_original_price = 1.99, price = 1.49 where user_product_period_id = (select upp.id from user_product_periods upp join user_products up on upp.user_product_id = up.id where up.code = 'mail_pro_b2c_premium200_discount20_v20220414_exp1' and upp.period = 'month') and currency = 'USD';
update user_product_prices set display_discount_percent = 20, display_original_price = 1.99, price = 1.49 where user_product_period_id = (select upp.id from user_product_periods upp join user_products up on upp.user_product_id = up.id where up.code = 'mail_pro_b2c_premium200_start_discount20_v20220414_exp1' and upp.period = 'month') and currency = 'USD';
update user_product_prices set display_discount_percent = 20, display_original_price = 12.49, price = 9.99 where user_product_period_id = (select upp.id from user_product_periods upp join user_products up on upp.user_product_id = up.id where up.code = 'mail_pro_b2c_premium200_discount20_v20220414_exp1' and upp.period = 'year') and currency = 'USD';
update user_product_prices set display_discount_percent = 20, display_original_price = 12.49, price = 9.99 where user_product_period_id = (select upp.id from user_product_periods upp join user_products up on upp.user_product_id = up.id where up.code = 'mail_pro_b2c_premium200_start_discount20_v20220414_exp1' and upp.period = 'year') and currency = 'USD';

update user_product_prices set price = 169 where user_product_period_id = (select upp.id from user_product_periods upp join user_products up on upp.user_product_id = up.id where up.code = 'mail_pro_b2c_premium200_v20220414_exp2' and upp.period = 'month') and currency = 'RUB';
update user_product_prices set price = 1090 where user_product_period_id = (select upp.id from user_product_periods upp join user_products up on upp.user_product_id = up.id where up.code = 'mail_pro_b2c_premium200_v20220414_exp2' and upp.period = 'year') and currency = 'RUB';
update user_product_prices set display_discount_percent = 20, display_original_price = 169, price = 129 where user_product_period_id = (select upp.id from user_product_periods upp join user_products up on upp.user_product_id = up.id where up.code = 'mail_pro_b2c_premium200_discount20_v20220414_exp2' and upp.period = 'month') and currency = 'RUB';
update user_product_prices set display_discount_percent = 20, display_original_price = 169, price = 129 where user_product_period_id = (select upp.id from user_product_periods upp join user_products up on upp.user_product_id = up.id where up.code = 'mail_pro_b2c_premium200_start_discount20_v20220414_exp2' and upp.period = 'month') and currency = 'RUB';
update user_product_prices set display_discount_percent = 20, display_original_price = 1090, price = 849 where user_product_period_id = (select upp.id from user_product_periods upp join user_products up on upp.user_product_id = up.id where up.code = 'mail_pro_b2c_premium200_discount20_v20220414_exp2' and upp.period = 'year') and currency = 'RUB';
update user_product_prices set display_discount_percent = 20, display_original_price = 1090, price = 849 where user_product_period_id = (select upp.id from user_product_periods upp join user_products up on upp.user_product_id = up.id where up.code = 'mail_pro_b2c_premium200_start_discount20_v20220414_exp2' and upp.period = 'year') and currency = 'RUB';
update user_product_prices set price = 1.99 where user_product_period_id = (select upp.id from user_product_periods upp join user_products up on upp.user_product_id = up.id where up.code = 'mail_pro_b2c_premium200_v20220414_exp2' and upp.period = 'month') and currency = 'USD';
update user_product_prices set price = 13.99 where user_product_period_id = (select upp.id from user_product_periods upp join user_products up on upp.user_product_id = up.id where up.code = 'mail_pro_b2c_premium200_v20220414_exp2' and upp.period = 'year') and currency = 'USD';
update user_product_prices set display_discount_percent = 20, display_original_price = 1.99, price = 1.49 where user_product_period_id = (select upp.id from user_product_periods upp join user_products up on upp.user_product_id = up.id where up.code = 'mail_pro_b2c_premium200_discount20_v20220414_exp2' and upp.period = 'month') and currency = 'USD';
update user_product_prices set display_discount_percent = 20, display_original_price = 1.99, price = 1.49 where user_product_period_id = (select upp.id from user_product_periods upp join user_products up on upp.user_product_id = up.id where up.code = 'mail_pro_b2c_premium200_start_discount20_v20220414_exp2' and upp.period = 'month') and currency = 'USD';
update user_product_prices set display_discount_percent = 20, display_original_price = 13.99, price = 10.99 where user_product_period_id = (select upp.id from user_product_periods upp join user_products up on upp.user_product_id = up.id where up.code = 'mail_pro_b2c_premium200_discount20_v20220414_exp2' and upp.period = 'year') and currency = 'USD';
update user_product_prices set display_discount_percent = 20, display_original_price = 13.99, price = 10.99 where user_product_period_id = (select upp.id from user_product_periods upp join user_products up on upp.user_product_id = up.id where up.code = 'mail_pro_b2c_premium200_start_discount20_v20220414_exp2' and upp.period = 'year') and currency = 'USD';

update user_product_prices set price = 199 where user_product_period_id = (select upp.id from user_product_periods upp join user_products up on upp.user_product_id = up.id where up.code = 'mail_pro_b2c_premium200_v20220414_exp3' and upp.period = 'month') and currency = 'RUB';
update user_product_prices set price = 1290 where user_product_period_id = (select upp.id from user_product_periods upp join user_products up on upp.user_product_id = up.id where up.code = 'mail_pro_b2c_premium200_v20220414_exp3' and upp.period = 'year') and currency = 'RUB';
update user_product_prices set display_discount_percent = 20, display_original_price = 199, price = 149 where user_product_period_id = (select upp.id from user_product_periods upp join user_products up on upp.user_product_id = up.id where up.code = 'mail_pro_b2c_premium200_discount20_v20220414_exp3' and upp.period = 'month') and currency = 'RUB';
update user_product_prices set display_discount_percent = 20, display_original_price = 199, price = 149 where user_product_period_id = (select upp.id from user_product_periods upp join user_products up on upp.user_product_id = up.id where up.code = 'mail_pro_b2c_premium200_start_discount20_v20220414_exp3' and upp.period = 'month') and currency = 'RUB';
update user_product_prices set display_discount_percent = 20, display_original_price = 1290, price = 999 where user_product_period_id = (select upp.id from user_product_periods upp join user_products up on upp.user_product_id = up.id where up.code = 'mail_pro_b2c_premium200_discount20_v20220414_exp3' and upp.period = 'year') and currency = 'RUB';
update user_product_prices set display_discount_percent = 20, display_original_price = 1290, price = 999 where user_product_period_id = (select upp.id from user_product_periods upp join user_products up on upp.user_product_id = up.id where up.code = 'mail_pro_b2c_premium200_start_discount20_v20220414_exp3' and upp.period = 'year') and currency = 'RUB';
update user_product_prices set price = 2.49 where user_product_period_id = (select upp.id from user_product_periods upp join user_products up on upp.user_product_id = up.id where up.code = 'mail_pro_b2c_premium200_v20220414_exp3' and upp.period = 'month') and currency = 'USD';
update user_product_prices set price = 16.49 where user_product_period_id = (select upp.id from user_product_periods upp join user_products up on upp.user_product_id = up.id where up.code = 'mail_pro_b2c_premium200_v20220414_exp3' and upp.period = 'year') and currency = 'USD';
update user_product_prices set display_discount_percent = 20, display_original_price = 2.49, price = 1.99 where user_product_period_id = (select upp.id from user_product_periods upp join user_products up on upp.user_product_id = up.id where up.code = 'mail_pro_b2c_premium200_discount20_v20220414_exp3' and upp.period = 'month') and currency = 'USD';
update user_product_prices set display_discount_percent = 20, display_original_price = 2.49, price = 1.99 where user_product_period_id = (select upp.id from user_product_periods upp join user_products up on upp.user_product_id = up.id where up.code = 'mail_pro_b2c_premium200_start_discount20_v20220414_exp3' and upp.period = 'month') and currency = 'USD';
update user_product_prices set display_discount_percent = 20, display_original_price = 16.49, price = 12.99 where user_product_period_id = (select upp.id from user_product_periods upp join user_products up on upp.user_product_id = up.id where up.code = 'mail_pro_b2c_premium200_discount20_v20220414_exp3' and upp.period = 'year') and currency = 'USD';
update user_product_prices set display_discount_percent = 20, display_original_price = 16.49, price = 12.99 where user_product_period_id = (select upp.id from user_product_periods upp join user_products up on upp.user_product_id = up.id where up.code = 'mail_pro_b2c_premium200_start_discount20_v20220414_exp3' and upp.period = 'year') and currency = 'USD';


update user_product_prices set price = 269 where user_product_period_id = (select upp.id from user_product_periods upp join user_products up on upp.user_product_id = up.id where up.code = 'mail_pro_b2c_premium1000_v20220414_exp1' and upp.period = 'month') and currency = 'RUB';
update user_product_prices set price = 1790 where user_product_period_id = (select upp.id from user_product_periods upp join user_products up on upp.user_product_id = up.id where up.code = 'mail_pro_b2c_premium1000_v20220414_exp1' and upp.period = 'year') and currency = 'RUB';
update user_product_prices set display_discount_percent = 20, display_original_price = 269, price = 199 where user_product_period_id = (select upp.id from user_product_periods upp join user_products up on upp.user_product_id = up.id where up.code = 'mail_pro_b2c_premium1000_discount20_v20220414_exp1' and upp.period = 'month') and currency = 'RUB';
update user_product_prices set display_discount_percent = 20, display_original_price = 269, price = 199 where user_product_period_id = (select upp.id from user_product_periods upp join user_products up on upp.user_product_id = up.id where up.code = 'mail_pro_b2c_premium1000_start_discount20_v20220414_exp1' and upp.period = 'month') and currency = 'RUB';
update user_product_prices set display_discount_percent = 20, display_original_price = 1790, price = 1390 where user_product_period_id = (select upp.id from user_product_periods upp join user_products up on upp.user_product_id = up.id where up.code = 'mail_pro_b2c_premium1000_discount20_v20220414_exp1' and upp.period = 'year') and currency = 'RUB';
update user_product_prices set display_discount_percent = 20, display_original_price = 1790, price = 1390 where user_product_period_id = (select upp.id from user_product_periods upp join user_products up on upp.user_product_id = up.id where up.code = 'mail_pro_b2c_premium1000_start_discount20_v20220414_exp1' and upp.period = 'year') and currency = 'RUB';
update user_product_prices set price = 3.49 where user_product_period_id = (select upp.id from user_product_periods upp join user_products up on upp.user_product_id = up.id where up.code = 'mail_pro_b2c_premium1000_v20220414_exp1' and upp.period = 'month') and currency = 'USD';
update user_product_prices set price = 22.49 where user_product_period_id = (select upp.id from user_product_periods upp join user_products up on upp.user_product_id = up.id where up.code = 'mail_pro_b2c_premium1000_v20220414_exp1' and upp.period = 'year') and currency = 'USD';
update user_product_prices set display_discount_percent = 20, display_original_price = 3.49, price = 2.99 where user_product_period_id = (select upp.id from user_product_periods upp join user_products up on upp.user_product_id = up.id where up.code = 'mail_pro_b2c_premium1000_discount20_v20220414_exp1' and upp.period = 'month') and currency = 'USD';
update user_product_prices set display_discount_percent = 20, display_original_price = 3.49, price = 2.99 where user_product_period_id = (select upp.id from user_product_periods upp join user_products up on upp.user_product_id = up.id where up.code = 'mail_pro_b2c_premium1000_start_discount20_v20220414_exp1' and upp.period = 'month') and currency = 'USD';
update user_product_prices set display_discount_percent = 20, display_original_price = 22.49, price = 17.49 where user_product_period_id = (select upp.id from user_product_periods upp join user_products up on upp.user_product_id = up.id where up.code = 'mail_pro_b2c_premium1000_discount20_v20220414_exp1' and upp.period = 'year') and currency = 'USD';
update user_product_prices set display_discount_percent = 20, display_original_price = 22.49, price = 17.49 where user_product_period_id = (select upp.id from user_product_periods upp join user_products up on upp.user_product_id = up.id where up.code = 'mail_pro_b2c_premium1000_start_discount20_v20220414_exp1' and upp.period = 'year') and currency = 'USD';

update user_product_prices set price = 299 where user_product_period_id = (select upp.id from user_product_periods upp join user_products up on upp.user_product_id = up.id where up.code = 'mail_pro_b2c_premium1000_v20220414_exp2' and upp.period = 'month') and currency = 'RUB';
update user_product_prices set price = 2090 where user_product_period_id = (select upp.id from user_product_periods upp join user_products up on upp.user_product_id = up.id where up.code = 'mail_pro_b2c_premium1000_v20220414_exp2' and upp.period = 'year') and currency = 'RUB';
update user_product_prices set display_discount_percent = 20, display_original_price = 299, price = 229 where user_product_period_id = (select upp.id from user_product_periods upp join user_products up on upp.user_product_id = up.id where up.code = 'mail_pro_b2c_premium1000_discount20_v20220414_exp2' and upp.period = 'month') and currency = 'RUB';
update user_product_prices set display_discount_percent = 20, display_original_price = 299, price = 229 where user_product_period_id = (select upp.id from user_product_periods upp join user_products up on upp.user_product_id = up.id where up.code = 'mail_pro_b2c_premium1000_start_discount20_v20220414_exp2' and upp.period = 'month') and currency = 'RUB';
update user_product_prices set display_discount_percent = 20, display_original_price = 2090, price = 1650 where user_product_period_id = (select upp.id from user_product_periods upp join user_products up on upp.user_product_id = up.id where up.code = 'mail_pro_b2c_premium1000_discount20_v20220414_exp2' and upp.period = 'year') and currency = 'RUB';
update user_product_prices set display_discount_percent = 20, display_original_price = 2090, price = 1650 where user_product_period_id = (select upp.id from user_product_periods upp join user_products up on upp.user_product_id = up.id where up.code = 'mail_pro_b2c_premium1000_start_discount20_v20220414_exp2' and upp.period = 'year') and currency = 'RUB';
update user_product_prices set price = 3.99 where user_product_period_id = (select upp.id from user_product_periods upp join user_products up on upp.user_product_id = up.id where up.code = 'mail_pro_b2c_premium1000_v20220414_exp2' and upp.period = 'month') and currency = 'USD';
update user_product_prices set price = 26.49 where user_product_period_id = (select upp.id from user_product_periods upp join user_products up on upp.user_product_id = up.id where up.code = 'mail_pro_b2c_premium1000_v20220414_exp2' and upp.period = 'year') and currency = 'USD';
update user_product_prices set display_discount_percent = 20, display_original_price = 3.99, price = 2.99 where user_product_period_id = (select upp.id from user_product_periods upp join user_products up on upp.user_product_id = up.id where up.code = 'mail_pro_b2c_premium1000_discount20_v20220414_exp2' and upp.period = 'month') and currency = 'USD';
update user_product_prices set display_discount_percent = 20, display_original_price = 3.99, price = 2.99 where user_product_period_id = (select upp.id from user_product_periods upp join user_products up on upp.user_product_id = up.id where up.code = 'mail_pro_b2c_premium1000_start_discount20_v20220414_exp2' and upp.period = 'month') and currency = 'USD';
update user_product_prices set display_discount_percent = 20, display_original_price = 26.49, price = 20.99 where user_product_period_id = (select upp.id from user_product_periods upp join user_products up on upp.user_product_id = up.id where up.code = 'mail_pro_b2c_premium1000_discount20_v20220414_exp2' and upp.period = 'year') and currency = 'USD';
update user_product_prices set display_discount_percent = 20, display_original_price = 26.49, price = 20.99 where user_product_period_id = (select upp.id from user_product_periods upp join user_products up on upp.user_product_id = up.id where up.code = 'mail_pro_b2c_premium1000_start_discount20_v20220414_exp2' and upp.period = 'year') and currency = 'USD';

update user_product_prices set price = 399 where user_product_period_id = (select upp.id from user_product_periods upp join user_products up on upp.user_product_id = up.id where up.code = 'mail_pro_b2c_premium1000_v20220414_exp3' and upp.period = 'month') and currency = 'RUB';
update user_product_prices set price = 2290 where user_product_period_id = (select upp.id from user_product_periods upp join user_products up on upp.user_product_id = up.id where up.code = 'mail_pro_b2c_premium1000_v20220414_exp3' and upp.period = 'year') and currency = 'RUB';
update user_product_prices set display_discount_percent = 20, display_original_price = 399, price = 299 where user_product_period_id = (select upp.id from user_product_periods upp join user_products up on upp.user_product_id = up.id where up.code = 'mail_pro_b2c_premium1000_discount20_v20220414_exp3' and upp.period = 'month') and currency = 'RUB';
update user_product_prices set display_discount_percent = 20, display_original_price = 399, price = 299 where user_product_period_id = (select upp.id from user_product_periods upp join user_products up on upp.user_product_id = up.id where up.code = 'mail_pro_b2c_premium1000_start_discount20_v20220414_exp3' and upp.period = 'month') and currency = 'RUB';
update user_product_prices set display_discount_percent = 20, display_original_price = 2290, price = 1790 where user_product_period_id = (select upp.id from user_product_periods upp join user_products up on upp.user_product_id = up.id where up.code = 'mail_pro_b2c_premium1000_discount20_v20220414_exp3' and upp.period = 'year') and currency = 'RUB';
update user_product_prices set display_discount_percent = 20, display_original_price = 2290, price = 1790 where user_product_period_id = (select upp.id from user_product_periods upp join user_products up on upp.user_product_id = up.id where up.code = 'mail_pro_b2c_premium1000_start_discount20_v20220414_exp3' and upp.period = 'year') and currency = 'RUB';
update user_product_prices set price = 4.99 where user_product_period_id = (select upp.id from user_product_periods upp join user_products up on upp.user_product_id = up.id where up.code = 'mail_pro_b2c_premium1000_v20220414_exp3' and upp.period = 'month') and currency = 'USD';
update user_product_prices set price = 28.99 where user_product_period_id = (select upp.id from user_product_periods upp join user_products up on upp.user_product_id = up.id where up.code = 'mail_pro_b2c_premium1000_v20220414_exp3' and upp.period = 'year') and currency = 'USD';
update user_product_prices set display_discount_percent = 20, display_original_price = 4.99, price = 3.99 where user_product_period_id = (select upp.id from user_product_periods upp join user_products up on upp.user_product_id = up.id where up.code = 'mail_pro_b2c_premium1000_discount20_v20220414_exp3' and upp.period = 'month') and currency = 'USD';
update user_product_prices set display_discount_percent = 20, display_original_price = 4.99, price = 3.99 where user_product_period_id = (select upp.id from user_product_periods upp join user_products up on upp.user_product_id = up.id where up.code = 'mail_pro_b2c_premium1000_start_discount20_v20220414_exp3' and upp.period = 'month') and currency = 'USD';
update user_product_prices set display_discount_percent = 20, display_original_price = 28.99, price = 22.99 where user_product_period_id = (select upp.id from user_product_periods upp join user_products up on upp.user_product_id = up.id where up.code = 'mail_pro_b2c_premium1000_discount20_v20220414_exp3' and upp.period = 'year') and currency = 'USD';
update user_product_prices set display_discount_percent = 20, display_original_price = 28.99, price = 22.99 where user_product_period_id = (select upp.id from user_product_periods upp join user_products up on upp.user_product_id = up.id where up.code = 'mail_pro_b2c_premium1000_start_discount20_v20220414_exp3' and upp.period = 'year') and currency = 'USD';


update user_product_prices set price = 599 where user_product_period_id = (select upp.id from user_product_periods upp join user_products up on upp.user_product_id = up.id where up.code = 'mail_pro_b2c_premium3000_v20220414_exp1' and upp.period = 'month') and currency = 'RUB';
update user_product_prices set price = 4290 where user_product_period_id = (select upp.id from user_product_periods upp join user_products up on upp.user_product_id = up.id where up.code = 'mail_pro_b2c_premium3000_v20220414_exp1' and upp.period = 'year') and currency = 'RUB';
update user_product_prices set display_discount_percent = 20, display_original_price = 599, price = 459 where user_product_period_id = (select upp.id from user_product_periods upp join user_products up on upp.user_product_id = up.id where up.code = 'mail_pro_b2c_premium3000_discount20_v20220414_exp1' and upp.period = 'month') and currency = 'RUB';
update user_product_prices set display_discount_percent = 20, display_original_price = 599, price = 459 where user_product_period_id = (select upp.id from user_product_periods upp join user_products up on upp.user_product_id = up.id where up.code = 'mail_pro_b2c_premium3000_start_discount20_v20220414_exp1' and upp.period = 'month') and currency = 'RUB';
update user_product_prices set display_discount_percent = 20, display_original_price = 4290, price = 3390 where user_product_period_id = (select upp.id from user_product_periods upp join user_products up on upp.user_product_id = up.id where up.code = 'mail_pro_b2c_premium3000_discount20_v20220414_exp1' and upp.period = 'year') and currency = 'RUB';
update user_product_prices set display_discount_percent = 20, display_original_price = 4290, price = 3390 where user_product_period_id = (select upp.id from user_product_periods upp join user_products up on upp.user_product_id = up.id where up.code = 'mail_pro_b2c_premium3000_start_discount20_v20220414_exp1' and upp.period = 'year') and currency = 'RUB';
update user_product_prices set price = 7.49 where user_product_period_id = (select upp.id from user_product_periods upp join user_products up on upp.user_product_id = up.id where up.code = 'mail_pro_b2c_premium3000_v20220414_exp1' and upp.period = 'month') and currency = 'USD';
update user_product_prices set price = 53.99 where user_product_period_id = (select upp.id from user_product_periods upp join user_products up on upp.user_product_id = up.id where up.code = 'mail_pro_b2c_premium3000_v20220414_exp1' and upp.period = 'year') and currency = 'USD';
update user_product_prices set display_discount_percent = 20, display_original_price = 7.49, price = 5.99 where user_product_period_id = (select upp.id from user_product_periods upp join user_products up on upp.user_product_id = up.id where up.code = 'mail_pro_b2c_premium3000_discount20_v20220414_exp1' and upp.period = 'month') and currency = 'USD';
update user_product_prices set display_discount_percent = 20, display_original_price = 7.49, price = 5.99 where user_product_period_id = (select upp.id from user_product_periods upp join user_products up on upp.user_product_id = up.id where up.code = 'mail_pro_b2c_premium3000_start_discount20_v20220414_exp1' and upp.period = 'month') and currency = 'USD';
update user_product_prices set display_discount_percent = 20, display_original_price = 53.99, price = 42.99 where user_product_period_id = (select upp.id from user_product_periods upp join user_products up on upp.user_product_id = up.id where up.code = 'mail_pro_b2c_premium3000_discount20_v20220414_exp1' and upp.period = 'year') and currency = 'USD';
update user_product_prices set display_discount_percent = 20, display_original_price = 53.99, price = 42.99 where user_product_period_id = (select upp.id from user_product_periods upp join user_products up on upp.user_product_id = up.id where up.code = 'mail_pro_b2c_premium3000_start_discount20_v20220414_exp1' and upp.period = 'year') and currency = 'USD';

update user_product_prices set price = 699 where user_product_period_id = (select upp.id from user_product_periods upp join user_products up on upp.user_product_id = up.id where up.code = 'mail_pro_b2c_premium3000_v20220414_exp2' and upp.period = 'month') and currency = 'RUB';
update user_product_prices set price = 4990 where user_product_period_id = (select upp.id from user_product_periods upp join user_products up on upp.user_product_id = up.id where up.code = 'mail_pro_b2c_premium3000_v20220414_exp2' and upp.period = 'year') and currency = 'RUB';
update user_product_prices set display_discount_percent = 20, display_original_price = 699, price = 549 where user_product_period_id = (select upp.id from user_product_periods upp join user_products up on upp.user_product_id = up.id where up.code = 'mail_pro_b2c_premium3000_discount20_v20220414_exp2' and upp.period = 'month') and currency = 'RUB';
update user_product_prices set display_discount_percent = 20, display_original_price = 699, price = 549 where user_product_period_id = (select upp.id from user_product_periods upp join user_products up on upp.user_product_id = up.id where up.code = 'mail_pro_b2c_premium3000_start_discount20_v20220414_exp2' and upp.period = 'month') and currency = 'RUB';
update user_product_prices set display_discount_percent = 20, display_original_price = 4990, price = 3990 where user_product_period_id = (select upp.id from user_product_periods upp join user_products up on upp.user_product_id = up.id where up.code = 'mail_pro_b2c_premium3000_discount20_v20220414_exp2' and upp.period = 'year') and currency = 'RUB';
update user_product_prices set display_discount_percent = 20, display_original_price = 4990, price = 3990 where user_product_period_id = (select upp.id from user_product_periods upp join user_products up on upp.user_product_id = up.id where up.code = 'mail_pro_b2c_premium3000_start_discount20_v20220414_exp2' and upp.period = 'year') and currency = 'RUB';
update user_product_prices set price = 8.99 where user_product_period_id = (select upp.id from user_product_periods upp join user_products up on upp.user_product_id = up.id where up.code = 'mail_pro_b2c_premium3000_v20220414_exp2' and upp.period = 'month') and currency = 'USD';
update user_product_prices set price = 62.99 where user_product_period_id = (select upp.id from user_product_periods upp join user_products up on upp.user_product_id = up.id where up.code = 'mail_pro_b2c_premium3000_v20220414_exp2' and upp.period = 'year') and currency = 'USD';
update user_product_prices set display_discount_percent = 20, display_original_price = 8.99, price = 6.99 where user_product_period_id = (select upp.id from user_product_periods upp join user_products up on upp.user_product_id = up.id where up.code = 'mail_pro_b2c_premium3000_discount20_v20220414_exp2' and upp.period = 'month') and currency = 'USD';
update user_product_prices set display_discount_percent = 20, display_original_price = 8.99, price = 6.99 where user_product_period_id = (select upp.id from user_product_periods upp join user_products up on upp.user_product_id = up.id where up.code = 'mail_pro_b2c_premium3000_start_discount20_v20220414_exp2' and upp.period = 'month') and currency = 'USD';
update user_product_prices set display_discount_percent = 20, display_original_price = 62.99, price = 50.99 where user_product_period_id = (select upp.id from user_product_periods upp join user_products up on upp.user_product_id = up.id where up.code = 'mail_pro_b2c_premium3000_discount20_v20220414_exp2' and upp.period = 'year') and currency = 'USD';
update user_product_prices set display_discount_percent = 20, display_original_price = 62.99, price = 50.99 where user_product_period_id = (select upp.id from user_product_periods upp join user_products up on upp.user_product_id = up.id where up.code = 'mail_pro_b2c_premium3000_start_discount20_v20220414_exp2' and upp.period = 'year') and currency = 'USD';

update user_product_prices set price = 799 where user_product_period_id = (select upp.id from user_product_periods upp join user_products up on upp.user_product_id = up.id where up.code = 'mail_pro_b2c_premium3000_v20220414_exp3' and upp.period = 'month') and currency = 'RUB';
update user_product_prices set price = 5690 where user_product_period_id = (select upp.id from user_product_periods upp join user_products up on upp.user_product_id = up.id where up.code = 'mail_pro_b2c_premium3000_v20220414_exp3' and upp.period = 'year') and currency = 'RUB';
update user_product_prices set display_discount_percent = 20, display_original_price = 799, price = 599 where user_product_period_id = (select upp.id from user_product_periods upp join user_products up on upp.user_product_id = up.id where up.code = 'mail_pro_b2c_premium3000_discount20_v20220414_exp3' and upp.period = 'month') and currency = 'RUB';
update user_product_prices set display_discount_percent = 20, display_original_price = 799, price = 599 where user_product_period_id = (select upp.id from user_product_periods upp join user_products up on upp.user_product_id = up.id where up.code = 'mail_pro_b2c_premium3000_start_discount20_v20220414_exp3' and upp.period = 'month') and currency = 'RUB';
update user_product_prices set display_discount_percent = 20, display_original_price = 5690, price = 4550 where user_product_period_id = (select upp.id from user_product_periods upp join user_products up on upp.user_product_id = up.id where up.code = 'mail_pro_b2c_premium3000_discount20_v20220414_exp3' and upp.period = 'year') and currency = 'RUB';
update user_product_prices set display_discount_percent = 20, display_original_price = 5690, price = 4550 where user_product_period_id = (select upp.id from user_product_periods upp join user_products up on upp.user_product_id = up.id where up.code = 'mail_pro_b2c_premium3000_start_discount20_v20220414_exp3' and upp.period = 'year') and currency = 'RUB';
update user_product_prices set price = 9.99 where user_product_period_id = (select upp.id from user_product_periods upp join user_products up on upp.user_product_id = up.id where up.code = 'mail_pro_b2c_premium3000_v20220414_exp3' and upp.period = 'month') and currency = 'USD';
update user_product_prices set price = 71.99 where user_product_period_id = (select upp.id from user_product_periods upp join user_products up on upp.user_product_id = up.id where up.code = 'mail_pro_b2c_premium3000_v20220414_exp3' and upp.period = 'year') and currency = 'USD';
update user_product_prices set display_discount_percent = 20, display_original_price = 9.99, price = 7.99 where user_product_period_id = (select upp.id from user_product_periods upp join user_products up on upp.user_product_id = up.id where up.code = 'mail_pro_b2c_premium3000_discount20_v20220414_exp3' and upp.period = 'month') and currency = 'USD';
update user_product_prices set display_discount_percent = 20, display_original_price = 9.99, price = 7.99 where user_product_period_id = (select upp.id from user_product_periods upp join user_products up on upp.user_product_id = up.id where up.code = 'mail_pro_b2c_premium3000_start_discount20_v20220414_exp3' and upp.period = 'month') and currency = 'USD';
update user_product_prices set display_discount_percent = 20, display_original_price = 71.99, price = 57.99 where user_product_period_id = (select upp.id from user_product_periods upp join user_products up on upp.user_product_id = up.id where up.code = 'mail_pro_b2c_premium3000_discount20_v20220414_exp3' and upp.period = 'year') and currency = 'USD';
update user_product_prices set display_discount_percent = 20, display_original_price = 71.99, price = 57.99 where user_product_period_id = (select upp.id from user_product_periods upp join user_products up on upp.user_product_id = up.id where up.code = 'mail_pro_b2c_premium3000_start_discount20_v20220414_exp3' and upp.period = 'year') and currency = 'USD';

-- Добавляем в линейки
insert into user_products_to_product_lines
(product_line_id, user_product_id, order_num)
values
    ((select id from product_lines where description = 'web default line exp v1'), (select id from user_products where code = 'mail_pro_b2c_premium200_v20220414_exp1'), 1),
    ((select id from product_lines where description = 'web default line exp v1'), (select id from user_products where code = 'mail_pro_b2c_premium1000_v20220414_exp1'), 2),
    ((select id from product_lines where description = 'web default line exp v1'), (select id from user_products where code = 'mail_pro_b2c_premium3000_v20220414_exp1'), 3),
    ((select id from product_lines where description = 'web default line exp v2'), (select id from user_products where code = 'mail_pro_b2c_premium200_v20220414_exp2'), 1),
    ((select id from product_lines where description = 'web default line exp v2'), (select id from user_products where code = 'mail_pro_b2c_premium1000_v20220414_exp2'), 2),
    ((select id from product_lines where description = 'web default line exp v2'), (select id from user_products where code = 'mail_pro_b2c_premium3000_v20220414_exp2'), 3),
    ((select id from product_lines where description = 'web default line exp v3'), (select id from user_products where code = 'mail_pro_b2c_premium200_v20220414_exp3'), 1),
    ((select id from product_lines where description = 'web default line exp v3'), (select id from user_products where code = 'mail_pro_b2c_premium1000_v20220414_exp3'), 2),
    ((select id from product_lines where description = 'web default line exp v3'), (select id from user_products where code = 'mail_pro_b2c_premium3000_v20220414_exp3'), 3),

    ((select id from product_lines where description = 'web discount 20% exp v1'), (select id from user_products where code = 'mail_pro_b2c_premium200_discount20_v20220414_exp1'), 1),
    ((select id from product_lines where description = 'web discount 20% exp v1'), (select id from user_products where code = 'mail_pro_b2c_premium1000_discount20_v20220414_exp1'), 2),
    ((select id from product_lines where description = 'web discount 20% exp v1'), (select id from user_products where code = 'mail_pro_b2c_premium3000_discount20_v20220414_exp1'), 3),
    ((select id from product_lines where description = 'web discount 20% exp v2'), (select id from user_products where code = 'mail_pro_b2c_premium200_discount20_v20220414_exp2'), 1),
    ((select id from product_lines where description = 'web discount 20% exp v2'), (select id from user_products where code = 'mail_pro_b2c_premium1000_discount20_v20220414_exp2'), 2),
    ((select id from product_lines where description = 'web discount 20% exp v2'), (select id from user_products where code = 'mail_pro_b2c_premium3000_discount20_v20220414_exp2'), 3),
    ((select id from product_lines where description = 'web discount 20% exp v3'), (select id from user_products where code = 'mail_pro_b2c_premium200_discount20_v20220414_exp3'), 1),
    ((select id from product_lines where description = 'web discount 20% exp v3'), (select id from user_products where code = 'mail_pro_b2c_premium1000_discount20_v20220414_exp3'), 2),
    ((select id from product_lines where description = 'web discount 20% exp v3'), (select id from user_products where code = 'mail_pro_b2c_premium3000_discount20_v20220414_exp3'), 3),

    ((select id from product_lines where description = 'web start discount 20% exp v1'), (select id from user_products where code = 'mail_pro_b2c_premium200_start_discount20_v20220414_exp1'), 1),
    ((select id from product_lines where description = 'web start discount 20% exp v1'), (select id from user_products where code = 'mail_pro_b2c_premium1000_start_discount20_v20220414_exp1'), 2),
    ((select id from product_lines where description = 'web start discount 20% exp v1'), (select id from user_products where code = 'mail_pro_b2c_premium3000_start_discount20_v20220414_exp1'), 3),
    ((select id from product_lines where description = 'web start discount 20% exp v2'), (select id from user_products where code = 'mail_pro_b2c_premium200_start_discount20_v20220414_exp2'), 1),
    ((select id from product_lines where description = 'web start discount 20% exp v2'), (select id from user_products where code = 'mail_pro_b2c_premium1000_start_discount20_v20220414_exp2'), 2),
    ((select id from product_lines where description = 'web start discount 20% exp v2'), (select id from user_products where code = 'mail_pro_b2c_premium3000_start_discount20_v20220414_exp2'), 3),
    ((select id from product_lines where description = 'web start discount 20% exp v3'), (select id from user_products where code = 'mail_pro_b2c_premium200_start_discount20_v20220414_exp3'), 1),
    ((select id from product_lines where description = 'web start discount 20% exp v3'), (select id from user_products where code = 'mail_pro_b2c_premium1000_start_discount20_v20220414_exp3'), 2),
    ((select id from product_lines where description = 'web start discount 20% exp v3'), (select id from user_products where code = 'mail_pro_b2c_premium3000_start_discount20_v20220414_exp3'), 3);

insert into promo_product_lines
(promo_template_id, product_line_id)
values
    ((select id from promo_templates where code = 'please_come_back_promo'), (select id from product_lines where description = 'web discount 20% exp v1')),
    ((select id from promo_templates where code = 'please_come_back_promo'), (select id from product_lines where description = 'web discount 20% exp v2')),
    ((select id from promo_templates where code = 'please_come_back_promo'), (select id from product_lines where description = 'web discount 20% exp v3')),

    ((select id from promo_templates where code = 'please_come_back_promo_product_set_request'), (select id from product_lines where description = 'web discount 20% exp v1')),
    ((select id from promo_templates where code = 'please_come_back_promo_product_set_request'), (select id from product_lines where description = 'web discount 20% exp v2')),
    ((select id from promo_templates where code = 'please_come_back_promo_product_set_request'), (select id from product_lines where description = 'web discount 20% exp v3')),

    ((select id from promo_templates where code = 'newbie'), (select id from product_lines where description = 'web start discount 20% exp v1')),
    ((select id from promo_templates where code = 'newbie'), (select id from product_lines where description = 'web start discount 20% exp v2')),
    ((select id from promo_templates where code = 'newbie'), (select id from product_lines where description = 'web start discount 20% exp v3'));
