/* pgmigrate-encoding: utf-8 */

-- обычные продукты
select copy_group_product('prepaid_org_mail_pro_standard100_april_2022', 'prepaid_org_mail_pro_standard100_late_april_2022');
select copy_group_product('prepaid_org_mail_pro_optimal1000_april_2022', 'prepaid_org_mail_pro_optimal1000_late_april_2022');
select copy_group_product('prepaid_org_mail_pro_advanced3000_april_2022', 'prepaid_org_mail_pro_advanced3000_late_april_2022');

-- создаём новую линейку с новыми продуктами
with promo_line_id as (
         insert into product_lines (product_set_id, created_at, order_num, selector_bean_el, description)
             values ((select product_set_id from product_lines where description = 'prepaid for b2b 360 april 2022'), now(), 241,
                     'productLineSelectorFactory.availableFromSelector("2022-04-29", productLineSelectorFactory.prepaidSelector())',
                     'prepaid for b2b 360 late april 2022')
             returning id
     ),
     order_num as (
         select code, order_num
         from (values ('prepaid_org_mail_pro_standard100_late_april_2022', 1),
                      ('prepaid_org_mail_pro_optimal1000_late_april_2022', 2),
                      ('prepaid_org_mail_pro_advanced3000_late_april_2022', 3)
              ) s(code, order_num)
     )
insert into group_products_to_product_lines
    (product_line_id, group_product_id, order_num)
    (select promo_line_id.id, gp.id, order_num
     from promo_line_id, group_products gp
         join order_num o on gp.code like o.code);

-- продукты для образования
select copy_group_product('prepaid_org_mail_pro_edu_standard100', 'prepaid_org_mail_pro_edu_standard100_late_april_2022');
select copy_group_product('prepaid_org_mail_pro_edu_optimal1000_trial_1y', 'prepaid_org_mail_pro_edu_optimal1000_late_april_2022_trial_1y');
select copy_group_product('prepaid_org_mail_pro_edu_advanced3000', 'prepaid_org_mail_pro_edu_advanced3000_late_april_2022');

with promo_line_id as (
         insert into product_lines (product_set_id, created_at, order_num, selector_bean_el, description)
             values ((select product_set_id from product_lines where description = 'edu prepaid for b2b 360'), now(), 100,
                     'productLineSelectorFactory.compositeAndSelector(productLineSelectorFactory.availableFromSelector("2022-04-29", productLineSelectorFactory.prepaidSelector()), productLineSelectorFactory.educationalGroupProductSelector())',
                     'edu prepaid for b2b 360 late april 2022')
         returning id
     ),
     order_num as (
         select code, order_num
         from (values ('prepaid_org_mail_pro_edu_standard100_late_april_2022', 1),
                      ('prepaid_org_mail_pro_edu_optimal1000_late_april_2022_trial_1y', 2),
                      ('prepaid_org_mail_pro_edu_advanced3000_late_april_2022', 3)
              ) s(code, order_num)
     )
insert into group_products_to_product_lines
    (product_line_id, group_product_id, order_num)
    (select promo_line_id.id, gp.id, order_num
     from promo_line_id, group_products gp
         join order_num o on gp.code like o.code);


-- триальные продукты
select copy_group_product('prepaid_org_mail_pro_standard100_trial30_april_2022', 'prepaid_org_mail_pro_standard100_trial30_late_april_2022');
select copy_group_product('prepaid_org_mail_pro_optimal1000_trial30_april_2022', 'prepaid_org_mail_pro_optimal1000_trial30_late_april_2022');
select copy_group_product('prepaid_org_mail_pro_advanced3000_trial30_april_2022', 'prepaid_org_mail_pro_advanced3000_trial30_late_april_2022');

with promo_line_id as (
         insert into product_lines (product_set_id, created_at, order_num, selector_bean_el, description)
             values ((select product_set_id from product_lines where description = 'prepaid for b2b 360 april 2022 (standard trial)'), now(), 209,
                     'productLineSelectorFactory.compositeAndSelector(productLineSelectorFactory.availableFromSelector("2022-04-29", productLineSelectorFactory.prepaidSelector()), productLineSelectorFactory.availableUntilSelector("2022-09-01", productLineSelectorFactory.prepaidSelector()), productLineSelectorFactory.experimentByOwnerIsActiveSelector("auto_pay_standard_trial"))',
                     'prepaid for b2b 360 late april 2022 (standard trial)')
         returning id
     ),
     order_num as (
         select code, order_num
         from (values ('prepaid_org_mail_pro_standard100_trial30_late_april_2022', 1),
                      ('prepaid_org_mail_pro_optimal1000_late_april_2022', 2),
                      ('prepaid_org_mail_pro_advanced3000_late_april_2022', 3)
              ) s(code, order_num)
     )
insert into group_products_to_product_lines
(product_line_id, group_product_id, order_num)
    (select promo_line_id.id, gp.id, order_num
     from promo_line_id, group_products gp
         join order_num o on gp.code like o.code);


with promo_line_id as (
         insert into product_lines (product_set_id, created_at, order_num, selector_bean_el, description)
             values ((select product_set_id from product_lines where description = 'prepaid for b2b 360 april 2022 (optimal trial)'), now(), 209,
                     'productLineSelectorFactory.compositeAndSelector(productLineSelectorFactory.availableFromSelector("2022-04-29", productLineSelectorFactory.prepaidSelector()), productLineSelectorFactory.availableUntilSelector("2022-09-01", productLineSelectorFactory.prepaidSelector()), productLineSelectorFactory.experimentByOwnerIsActiveSelector("auto_pay_optimal_trial"))',
                     'prepaid for b2b 360 late april 2022 (optimal trial)')
         returning id
     ),
     order_num as (
         select code, order_num
         from (values ('prepaid_org_mail_pro_standard100_late_april_2022', 1),
                      ('prepaid_org_mail_pro_optimal1000_trial30_late_april_2022', 2),
                      ('prepaid_org_mail_pro_advanced3000_late_april_2022', 3)
              ) s(code, order_num)
     )
insert into group_products_to_product_lines
    (product_line_id, group_product_id, order_num)
    (select promo_line_id.id, gp.id, order_num
     from promo_line_id, group_products gp
         join order_num o on gp.code like o.code);


with promo_line_id as (
         insert into product_lines (product_set_id, created_at, order_num, selector_bean_el, description)
             values ((select product_set_id from product_lines where description = 'prepaid for b2b 360 april 2022 (advanced trial)'), now(), 209,
                     'productLineSelectorFactory.compositeAndSelector(productLineSelectorFactory.availableFromSelector("2022-04-29", productLineSelectorFactory.prepaidSelector()), productLineSelectorFactory.availableUntilSelector("2022-09-01", productLineSelectorFactory.prepaidSelector()), productLineSelectorFactory.experimentByOwnerIsActiveSelector("auto_pay_advanced_trial"))',
                     'prepaid for b2b 360 late april 2022 (advanced trial)')
         returning id
     ),
     order_num as (
         select code, order_num
         from (values ('prepaid_org_mail_pro_standard100_late_april_2022', 1),
                      ('prepaid_org_mail_pro_optimal1000_late_april_2022', 2),
                      ('prepaid_org_mail_pro_advanced3000_trial30_late_april_2022', 3)
              ) s(code, order_num)
     )
insert into group_products_to_product_lines
    (product_line_id, group_product_id, order_num)
    (select promo_line_id.id, gp.id, order_num
     from promo_line_id, group_products gp
         join order_num o on gp.code like o.code);


-- экспериментальные продукты с sso
select copy_group_product('prepaid_org_mail_pro_optimal1000_april_2022_sso_enabled', 'prepaid_org_mail_pro_optimal1000_late_april_2022_sso_enabled');
select copy_group_product('prepaid_org_mail_pro_advanced3000_april_2022_sso_enabled', 'prepaid_org_mail_pro_advanced3000_late_april_2022_sso_enabled');

with promo_line_id as (
         insert into product_lines (product_set_id, created_at, order_num, selector_bean_el, description)
             values ((select product_set_id from product_lines where description = 'prepaid for b2b 360 april 2022 sso enabled'), now(), 240,
                     'productLineSelectorFactory.compositeAndSelector(productLineSelectorFactory.availableFromSelector("2022-04-29", productLineSelectorFactory.prepaidSelector()), productLineSelectorFactory.experimentByOwnerIsActiveSelector("b2b_360_sso_enabled"))',
                     'prepaid for b2b 360 late april 2022 sso enabled')
         returning id
     ),
     order_num as (
         select code, order_num
         from (values ('prepaid_org_mail_pro_standard100_late_april_2022', 1),
                      ('prepaid_org_mail_pro_optimal1000_late_april_2022_sso_enabled', 2),
                      ('prepaid_org_mail_pro_advanced3000_late_april_2022_sso_enabled', 3)
              ) s(code, order_num)
     )
insert into group_products_to_product_lines
    (product_line_id, group_product_id, order_num)
    (select promo_line_id.id, gp.id, order_num
     from promo_line_id, group_products gp
         join order_num o on gp.code like o.code);


-- меняем цены на новые продукты
update group_products set price = 249
where code = 'prepaid_org_mail_pro_standard100_late_april_2022'
   or code = 'prepaid_org_mail_pro_standard100_trial30_late_april_2022';

update group_products set price = 469
where code = 'prepaid_org_mail_pro_optimal1000_late_april_2022'
   or code = 'prepaid_org_mail_pro_optimal1000_trial30_late_april_2022'
   or code = 'prepaid_org_mail_pro_optimal1000_late_april_2022_sso_enabled';

update group_products set price = 1399
where code = 'prepaid_org_mail_pro_advanced3000_late_april_2022'
   or code = 'prepaid_org_mail_pro_advanced3000_trial30_late_april_2022'
   or code = 'prepaid_org_mail_pro_advanced3000_late_april_2022_sso_enabled';

update group_products set price = 124
where code = 'prepaid_org_mail_pro_edu_standard100_late_april_2022';

update group_products set price = 279
where code = 'prepaid_org_mail_pro_edu_optimal1000_late_april_2022_trial_1y';

update group_products set price = 699
where code = 'prepaid_org_mail_pro_edu_advanced3000_late_april_2022';
