/* pgmigrate-encoding: utf-8 */

update product_lines
set selector_bean_el = 'productLineSelectorFactory.availableSelector()'
where description in (
    'web default line exp v3',
    'web discount 20% exp v3',
    'web start discount 20% exp v3'
);

insert into
    product_lines
(product_set_id, created_at, order_num, selector_bean_el, description)
values
    ((select id from product_sets where key = 'mail_pro_b2c'), now(), -2, 'productLineSelectorFactory.experimentIsActiveSelector("mail_360_exp_prices_control")', 'web default line exp control'),
    ((select id from product_sets where key = 'mail_pro_b2c'), now(), 1018, 'productLineSelectorFactory.experimentIsActiveSelector("mail_360_exp_prices_control")', 'web default line exp control discount 20'),
    ((select id from product_sets where key = 'mail_pro_b2c'), now(), 1022, 'productLineSelectorFactory.experimentIsActiveSelector("mail_360_exp_prices_control")', 'web default line exp control start discount 20');

update product_lines set order_num = order_num + 1 where description like 'web start discount 20% exp v%';

insert into
    user_products_to_product_lines
select
    (select id from product_lines where description = 'web default line exp control'),
    user_product_id,
    order_num
from user_products_to_product_lines
where product_line_id = (select id from product_lines where description = 'web default line' limit 1);

insert into
    user_products_to_product_lines
select
    (select id from product_lines where description = 'web default line exp control start discount 20'),
    user_product_id,
    order_num
from user_products_to_product_lines
where product_line_id = (select id from product_lines where description = 'web start discount 20' limit 1);

insert into
    user_products_to_product_lines
select
    (select id from product_lines where description = 'web default line exp control discount 20'),
    user_product_id,
    order_num
from user_products_to_product_lines
where product_line_id = (select id from product_lines where description = 'web start discount 20' limit 1);


insert into promo_product_lines
(promo_template_id, product_line_id)
values
    ((select id from promo_templates where code = 'please_come_back_promo'), (select id from product_lines where description = 'web default line exp control discount 20')),

    ((select id from promo_templates where code = 'please_come_back_promo_product_set_request'), (select id from product_lines where description = 'web default line exp control discount 20')),

    ((select id from promo_templates where code = 'newbie'), (select id from product_lines where description = 'web default line exp control start discount 20'));

update user_product_prices
set
    start_period_price = price,
    price = display_original_price,
    display_discount_percent = null,
    display_original_price = null
where
    user_product_period_id in (
        select
            upp.id
        from
             user_product_periods upp
        join
             user_products up on upp.user_product_id = up.id
        where
             up.code like 'mail_pro_b2c_premium%_discount20_v20220414_exp%'
    );

update user_product_periods
set
    start_period_count = 5,
    start_period_discount_duration_length = 1,
    start_period_discount_duration_measurement = 'month'
where
    id in (
        select
            upp.id
        from
            user_product_periods upp
        join
            user_products up on upp.user_product_id = up.id
        where
            up.code like 'mail_pro_b2c_premium%_discount20_v20220414_exp%'
    ) and period = 'month';

update user_product_periods
set
    start_period_count = 1,
    start_period_discount_duration_length = 1,
    start_period_discount_duration_measurement = 'year'
where
    id in (
        select
            upp.id
        from
            user_product_periods upp
        join
            user_products up on upp.user_product_id = up.id
        where
            up.code like 'mail_pro_b2c_premium%_discount20_v20220414_exp%'
    ) and period = 'year';
