/* pgmigrate-encoding: utf-8 */
--INAPP GOOGLE products
select * from copy_products('mail_pro_b2c_premium1000_v20220414_exp3',
    'mail_pro_b2c_premium1000_v20220414_exp3',
    'b2c_1000_v2_inapp_google');

select * from copy_products('mail_pro_b2c_premium200_v20220414_exp3',
                            'mail_pro_b2c_premium200_v20220414_exp3',
                            'b2c_200_v2_inapp_google');

select * from copy_products('mail_pro_b2c_premium3000_v20220414_exp3',
                            'mail_pro_b2c_premium3000_v20220414_exp3',
                            'b2c_3000_v2_inapp_google');

--INAPP GOOGLE discount products
select * from copy_products('mail_pro_b2c_premium1000_discount20_v20220414_exp3',
                            'mail_pro_b2c_premium1000_discount20_v20220414_exp3',
                            'b2c_1000_discount_v2_inapp_google');

select * from copy_products('mail_pro_b2c_premium200_discount20_v20220414_exp3',
                            'mail_pro_b2c_premium200_discount20_v20220414_exp3',
                            'b2c_200_discount_v2_inapp_google');

select * from copy_products('mail_pro_b2c_premium3000_discount20_v20220414_exp3',
                            'mail_pro_b2c_premium3000_discount20_v20220414_exp3',
                            'b2c_3000_discount_v2_inapp_google');

update user_products set billing_type = 'inapp_google',
                         trust_subs_retry_charging_delay = null,
                         trust_subs_retry_charging_limit = null,
                         trust_subs_grace_period = null,
                         trust_service_id = 116,
                         code_family = code_family || '_inapp_google'
where code like 'b2c_%_v2_inapp_google';

--INAPP APPLE products
select * from copy_products('mail_pro_b2c_premium1000_v20220414_exp3',
                            'mail_pro_b2c_premium1000_v20220414_exp3',
                            'b2c_1000_v2_inapp_apple');

select * from copy_products('mail_pro_b2c_premium200_v20220414_exp3',
                            'mail_pro_b2c_premium200_v20220414_exp3',
                            'b2c_200_v2_inapp_apple');


select * from copy_products('mail_pro_b2c_premium3000_v20220414_exp3',
                            'mail_pro_b2c_premium3000_v20220414_exp3',
                            'b2c_3000_v2_inapp_apple');

update user_products set billing_type = 'inapp_apple',
                         trust_subs_retry_charging_delay = null,
                         trust_subs_retry_charging_limit = null,
                         trust_subs_grace_period = null,
                         trust_service_id = 116,
                         code_family = code_family || '_inapp_apple'
where code like 'b2c_%_v2_inapp_apple';

--INAPP APPLE FOR DISK products
select * from copy_products('mail_pro_b2c_premium1000_v20220414_exp3',
                            'mail_pro_b2c_premium1000_v20220414_exp3',
                            'b2c_1000_v2_inapp_apple_for_disk');

select * from copy_products('mail_pro_b2c_premium200_v20220414_exp3',
                            'mail_pro_b2c_premium200_v20220414_exp3',
                            'b2c_200_v2_inapp_apple_for_disk');


select * from copy_products('mail_pro_b2c_premium3000_v20220414_exp3',
                            'mail_pro_b2c_premium3000_v20220414_exp3',
                            'b2c_3000_v2_inapp_apple_for_disk');

update user_products set billing_type = 'inapp_apple',
                         trust_subs_retry_charging_delay = null,
                         trust_subs_retry_charging_limit = null,
                         trust_subs_grace_period = null,
                         trust_service_id = 116,
                         code_family = code_family || '_inapp_apple_for_disk'
where code like 'b2c_%_v2_inapp_apple_for_disk';

--shorten period code to fit 40 symbols for google play restriction
update user_product_periods
set code = replace(replace(code, 'PS_BILLING_', ''), '_subs', '')
where id in (select id
             from user_product_periods
             where code like 'PS_BILLING_b2c_%_v2_inapp_%');


--REMOVE trust fiscal title and ADD package_name
update user_product_periods
    set trust_fiscal_title = null,
    package_name = CASE WHEN code like '%for_disk%' THEN 'ru.yandex.disk' ELSE 'ru.yandex.mail' END
where user_product_id in (select id from user_products where code like 'b2c_%v2_inapp%');

--move existing product_line
update product_lines
set order_num = 3
where description in (
                      'android default line',
                      'ios mail default line',
                      'ios disk default line');

insert into product_lines
select uuid_generate_v4(),
       pl.product_set_id,
       now(),
       2,
       'productLineSelectorFactory.experimentIsActiveSelector("inapp_new_prices_2022")',
       pl.description || ' 2022'
from product_lines pl
where description in (
                      'android default line',
                      'ios mail default line',
                      'ios disk default line');


insert into user_products_to_product_lines
select (select id
        from product_lines
        where description =
              case
                  when up.code like '%v2_inapp_apple_for_disk' then 'ios disk default line 2022'
                  when up.code like '%v2_inapp_apple' then 'ios mail default line 2022'
                  when up.code like '%v2_inapp_google' then 'android default line 2022'
                end
       ),
       up.id,
       case
           when code like '%200%' then 1
           when code like '%1000%' then 2
           when code like '%3000%' then 3
           end
from user_products up
where code like 'b2c%v2_inapp%';

