/* pgmigrate-encoding: utf-8 */

create or replace function create_mpfs_space_feature(
    feature_code text,
    feature_description text
) returns uuid language plpgsql
as
$$
declare
    promocode_space_feature_id uuid;
begin
    WITH mpfs(host) AS (
        select case
                   when (select (select value from environment where key = 'env') in ('prod', 'prestable'))
                       then 'mpfs.disk.yandex.net'
                   else 'mpfs-stable.dst.yandex.net'
                   end
    )
    insert
    into features
    (code,
     created_at,
     updated_at,
     type,
     description,
     system_name,
     activation_url_http_method,
     activation_url_template,
     set_amount_url_http_method,
     set_amount_url_template,
     deactivation_url_http_method,
     deactivation_url_template,
     call_set_amount_on_activation,
     call_set_amount_on_deactivation,
     error_processor_name)
    values (feature_code,
            now(),
            now(),
            'additive',
            feature_description,
            'mpfs',
            'GET',
            'https://' || (select host from mpfs) ||
            '/billing/service_create_for_ps_billing?uid=#{uid}&line=partner&pid=yandex_b2c_mail_pro_promo&product.amount=#{amount}&auto_init_user=1&ip=127.0.0.1',
            'GET',
            'https://' || (select host from mpfs) ||
            '/billing/service_set_attribute?uid=#{uid}&sid=#{context[''sid'']}&key=product.amount&value=#{amount}&ip=127.0.0.1',
            'GET',
            'https://' || (select host from mpfs) ||
            '/billing/service_delete?uid=#{uid}&sid=#{context[''sid'']}&ip=127.0.0.1&send_email=0',
            false,
            false,
            'mpfs')
    returning id into promocode_space_feature_id;
    return promocode_space_feature_id;
end;
$$;

create or replace function create_free_space_product(
    new_code text,
    the_title_tanker_key_id uuid,
    duration_period_val text,
    duration_period_count numeric,
    the_amount numeric,
    space_feature_code text
) returns uuid language plpgsql
as
$$
declare
    the_user_product_id uuid;
    the_user_product_period_id uuid;
    the_user_product_price_id uuid;
    the_product_feature_id uuid;
begin
    select id into the_product_feature_id from features where code = space_feature_code;

    insert into public.user_products
    (
        code,
        created_at,
        updated_at,
        title_tanker_key_id,
        is_best_offer,
        product_owner_id,
        available_from,
        billing_type,
        allow_auto_prolong,
        trust_subs_retry_charging_limit,
        trust_subs_retry_charging_delay,
        trust_subs_grace_period,
        singleton,
        trust_service_id,
        trial_definition_id,
        code_family,
        product_template_id
    ) values
        (
            new_code,
            now(),
            now(),
            the_title_tanker_key_id,
            true,
            (select id from product_owners where code = 'yandex_mail'),
            null,
            'free',
            false,
            null,
            null,
            null,
            false,
            0,
            null,
            new_code,
            null
        ) returning id into the_user_product_id;

    insert into user_product_periods
        (
         user_product_id,
         period,
         code,
         trust_fiscal_title,
         created_at,
         package_name,
         start_period_discount_duration_measurement,
         start_period_discount_duration_length,
         start_period_count,
         period_count
         ) values (
                   the_user_product_id,
                   duration_period_val,
                   new_code || '_' || duration_period_val  || '_' || duration_period_count,
                   null,
                   now(),
                   null,
                   null,
                   null,
                   null,
                   duration_period_count
                   ) returning id into the_user_product_period_id;

    insert into public.user_product_prices
        (
         created_at,
         region_id,
         price,
         currency,
         display_discount_percent,
         display_original_price,
         user_product_period_id,
         start_period_price
         ) values (
                   now(),
                   '10000',
                   0,
                   'RUB',
                   null,
                   null,
                   the_user_product_period_id,
                   null
                   ) returning id into the_user_product_price_id;

    insert into public.product_features
        (
         user_product_id,
         feature_id,
         amount,
         created_at,
         description_tanker_key_id,
         enabled,
         group_tanker_key_id,
         value_tanker_key_id,
         order_num,
         code,
         scope
         ) values (
                   the_user_product_id,
                   the_product_feature_id,
                   the_amount,
                   now(),
                   (select tanker_key_id('disk-ps-billing','features','mail_pro_b2c_add_disk_space')),
                   true,
                   (select tanker_key_id('disk-ps-billing','features','mail_pro_b2c_group_disk')),
                   the_title_tanker_key_id,
                   7,
                   space_feature_code,
                   'user'
                   );
    return the_user_product_price_id;
end
$$;

create or replace function tanker_key_id(
    the_project text,
    the_key_set text,
    the_key text
) returns uuid language plpgsql
as
$$
declare
    result uuid;
begin
    insert into tanker_keys(created_at, project, key_set, key)
    values (now(), the_project, the_key_set, the_key)
    on conflict(project, key_set, key) do update
        set key = excluded.key --otherwise it won't return id
    returning id into result;
    return result;
end
$$;

-- on base of mail_pro_b2c_premium1000_v20210610
select create_mpfs_space_feature(
    'mpfs_disk_space_for_mail_360_promo',
    'Предоставление места в Яндекс.Диске с названием сервиса под почту 360 по B2C промокодам, измеряется в байтах'
    );
select create_free_space_product(
    'mail_pro_b2c_test_promocode_131_KB',
    (select tanker_key_id('disk-ps-billing', 'promos', 'mail_pro_b2c_test_promocode_131_KB')),
    'minute',
    '10',
    134144, --131 KB
    'mpfs_disk_space_for_mail_360_promo'
    );
