/* pgmigrate-encoding: utf-8 */

create or replace function create_mpfs_space_feature(
    feature_code text,
    feature_description text,
    mpfs_line text,
    mpfs_pid text,
    do_set_amount boolean,
    do_disable boolean
) returns uuid language plpgsql
as
$$
declare
    promocode_space_feature_id uuid;
begin
    WITH mpfs(host) AS (
        select case
                   when (select (select value from environment where key = 'env') in ('prod', 'prestable'))
                       then 'mpfs.disk.yandex.net'
                   else 'mpfs-stable.dst.yandex.net'
                   end
    )
    insert
    into features
    (code,
     created_at,
     updated_at,
     type,
     description,
     system_name,
     activation_url_http_method,
     activation_url_template,
     set_amount_url_http_method,
     set_amount_url_template,
     deactivation_url_http_method,
     deactivation_url_template,
     call_set_amount_on_activation,
     call_set_amount_on_deactivation,
     error_processor_name)
    values (feature_code,
            now(),
            now(),
            'additive',
            feature_description,
            'mpfs',
            'GET',
            'https://' || (select host from mpfs) ||
            '/billing/service_create_for_ps_billing?uid=#{uid}&line=' || mpfs_line || '&pid=' || mpfs_pid || '&product.amount=#{amount}&auto_init_user=1&ip=127.0.0.1',
            case when do_set_amount then 'GET' end,
            case when do_set_amount then 'https://' || (select host from mpfs) ||
            '/billing/service_set_attribute?uid=#{uid}&sid=#{context[''sid'']}&key=product.amount&value=#{amount}&ip=127.0.0.1' end,
            case when do_disable then 'GET' end,
            case when do_disable then 'https://' || (select host from mpfs) ||
            '/billing/service_delete?uid=#{uid}&sid=#{context[''sid'']}&ip=127.0.0.1&send_email=0' end,
            false,
            false,
            'mpfs')
    returning id into promocode_space_feature_id;
    return promocode_space_feature_id;
end;
$$;

select create_mpfs_space_feature(
           'mpfs_disk_space_for_beeline_256gb_1_year',
           'Предоставление места в Яндекс Диске. 256 Гб по промокоду диск.про',
           'promo_code',
           'beeline_256gb_1_year',
           false,
           false
           );

select create_mpfs_space_feature(
           'mpfs_disk_space_for_promo_code_blat_100',
           'Предоставление места в Яндекс Диске. 100 Гб по промокоду диск.про',
           'promo_code',
           'promo_code_blat_100',
           false,
           false
           );

select create_free_space_product(
           'mpfs_disk_space_for_beeline_256gb_1_year',
           null,
           'year',
           '1',
           274877906944, --won't affect MPFS but placed correct value just in case
           'mpfs_disk_space_for_beeline_256gb_1_year'
           );

select create_free_space_product(
           'mpfs_disk_space_for_promo_code_blat_100',
           null,
           'year',
           '100',
           107374182400, --won't affect MPFS but placed correct value just in case
           'mpfs_disk_space_for_promo_code_blat_100'
           );
