/* pgmigrate-encoding: utf-8 */

-- https://st.yandex-team.ru/CHEMODAN-84106
do
$$
    declare
        new_product_sets_key text = 'mobile_web_pro_b2c';
        old_product_sets_key text = 'mail_pro_b2c';
        new_product_sets_id  uuid;
        pl                   record;
        new_pl_id            uuid;
        uptpl                record;
    begin

        -- Вставка нового кода в product_sets
        insert into product_sets (key, created_at)
        values (new_product_sets_key, now())
        on conflict (key) do nothing
        returning id into new_product_sets_id;

        -- Если такой продукт сет есть, то значит ничего делать не надо.
        if new_product_sets_id is null then
            return;
        end if;

        for pl in select *
                  from product_lines
                  where product_set_id = (select id from product_sets where key = old_product_sets_key)
            loop

                -- Вставляем аналогичную продуктовую линию
                insert into product_lines (product_set_id, created_at, order_num, selector_bean_el, description)
                values (new_product_sets_id, now(), pl.order_num, pl.selector_bean_el, pl.description || ' for mobile')
                returning id into new_pl_id;

                for uptpl in
                    select * from user_products_to_product_lines where product_line_id = pl.id
                    loop

                        -- Вставляем аналогичную связь продуктовой линии с продуктом
                        insert into user_products_to_product_lines (product_line_id, user_product_id, order_num)
                        values (new_pl_id, uptpl.user_product_id, uptpl.order_num);

                    end loop;
            end loop;

        -- Вставляем в бакет по product_set
        insert into user_product_buckets (code, created_at, user_product_id, product_line_id, product_set_id)
        select code,
               now(),
               user_product_id,
               product_line_id,
               new_product_sets_id
        from user_product_buckets
        where 1 = 1
          and user_product_id is null
          and product_line_id is null
          and product_set_id = pl.product_set_id;
    end;
$$
