/* pgmigrate-encoding: utf-8 */

create or replace function create_mpfs_space_feature(
    feature_code text,
    feature_description text,
    mpfs_line text,
    mpfs_pid text,
    do_set_amount boolean,
    do_disable boolean,
    do_specify_amount_on_create boolean
) returns uuid language plpgsql
as
$$
declare
    promocode_space_feature_id uuid;
    amount_url_parameter text := '';
begin
    if do_specify_amount_on_create then
        amount_url_parameter = 'product.amount=#{amount}&';
    end if;

    WITH mpfs(host) AS (
        select case
                   when (select (select value from environment where key = 'env') in ('prod', 'prestable'))
                       then 'mpfs.disk.yandex.net'
                   else 'mpfs-stable.dst.yandex.net'
                   end
    )
    insert
    into features
    (code,
     created_at,
     updated_at,
     type,
     description,
     system_name,
     activation_url_http_method,
     activation_url_template,
     set_amount_url_http_method,
     set_amount_url_template,
     deactivation_url_http_method,
     deactivation_url_template,
     call_set_amount_on_activation,
     call_set_amount_on_deactivation,
     error_processor_name)
    values (feature_code,
            now(),
            now(),
            'additive',
            feature_description,
            'mpfs',
            'GET',
            'https://' || (select host from mpfs) ||
            '/billing/service_create_for_ps_billing?uid=#{uid}&line=' || mpfs_line || '&pid=' || mpfs_pid || '&' || amount_url_parameter || 'auto_init_user=1&ip=127.0.0.1',
            case when do_set_amount then 'GET' end,
            case when do_set_amount then 'https://' || (select host from mpfs) ||
                                         '/billing/service_set_attribute?uid=#{uid}&sid=#{context[''sid'']}&key=product.amount&value=#{amount}&ip=127.0.0.1' end,
            case when do_disable then 'GET' end,
            case when do_disable then 'https://' || (select host from mpfs) ||
                                      '/billing/service_delete?uid=#{uid}&sid=#{context[''sid'']}&ip=127.0.0.1&send_email=0' end,
            false,
            false,
            'mpfs')
    returning id into promocode_space_feature_id;
    return promocode_space_feature_id;
end;
$$;

WITH mpfs(host) AS (
    select case
               when (select (select value from environment where key = 'env') in ('prod', 'prestable'))
                   then 'mpfs.disk.yandex.net'
               else 'mpfs-stable.dst.yandex.net'
               end
)
update features set activation_url_template = 'https://' || (select host from mpfs) || '/billing/service_create_for_ps_billing?uid=#{uid}&line=promo_code&pid=beeline_256gb_1_year&auto_init_user=1&ip=127.0.0.1'
where code = 'mpfs_disk_space_for_beeline_256gb_1_year';

WITH mpfs(host) AS (
    select case
               when (select (select value from environment where key = 'env') in ('prod', 'prestable'))
                   then 'mpfs.disk.yandex.net'
               else 'mpfs-stable.dst.yandex.net'
               end
)
update features set activation_url_template = 'https://' || (select host from mpfs) || '/billing/service_create_for_ps_billing?uid=#{uid}&line=promo_code&pid=promo_code_blat_100&auto_init_user=1&ip=127.0.0.1'
where code = 'mpfs_disk_space_for_promo_code_blat_100';
