/* pgmigrate-encoding: utf-8 */

CREATE TYPE group_promo_status AS ENUM ('active','used');

CREATE TABLE group_promos
(
    id                UUID DEFAULT uuid_generate_v4()                        NOT NULL PRIMARY KEY,
    created_at        TIMESTAMP                                              NOT NULL,
    updated_at        TIMESTAMP                                              NOT NULL,
    status            group_promo_status                                     NOT NULL,
    promo_template_id UUID REFERENCES promo_templates (id) ON DELETE CASCADE NOT NULL,
    group_id          UUID REFERENCES groups (id) ON DELETE CASCADE          NOT NULL,
    from_date         TIMESTAMP                                              NOT NULL,
    to_date           TIMESTAMP,
    UNIQUE (promo_template_id, group_id)
);

COMMENT
ON TABLE group_promos IS 'Список активированных промо акций для группы';

COMMENT
ON COLUMN group_promos.id IS 'Идентификатор';
COMMENT
ON COLUMN group_promos.created_at IS 'Дата создания';
COMMENT
ON COLUMN group_promos.updated_at IS 'Дата обновления';
COMMENT
ON COLUMN group_promos.status IS 'Статус применения промо акции';
COMMENT
ON COLUMN group_promos.promo_template_id IS 'Промо акция';
COMMENT
ON COLUMN group_promos.group_id IS 'Группа';
COMMENT
ON COLUMN group_promos.from_date IS 'Дата начала действия промо акции для группы';
COMMENT
ON COLUMN group_promos.to_date IS 'Дата окончания действия промо акции для группы';

CREATE INDEX group_promos_group_id_idx ON group_promos (group_id);

