/* pgmigrate-encoding: utf-8 */
create or replace function change_start_price(product_code text, period_code text, start_price numeric,
                                   currency_val text) returns integer
    language plpgsql
as
$$
BEGIN
    update user_product_prices
    set start_period_price = start_price
    where id = (select u.id
                from user_products up
                         join user_product_periods upp on up.id = upp.user_product_id
                         join user_product_prices u on upp.id = u.user_product_period_id
                where up.code = product_code
                  and upp.period = period_code
                  and u.currency = currency_val);
    RETURN 0;
END
$$;

create or replace function create_product_line(
    product_set_key text,
    new_line_description text,
    new_product_line_order numeric,
    product_codes text[],
    selector text default 'productLineSelectorFactory.availableSelector()'
) returns void
    language plpgsql
as
$$
declare
    new_product_line_id              uuid;
    target_product_set_id              uuid;
    base_product_line_order_occupied boolean;
BEGIN
    target_product_set_id := (select id from product_sets where key = product_set_key);

    ASSERT target_product_set_id is not null, 'base product line id not resolved';

    select count(*) > 0
    into base_product_line_order_occupied
    from product_lines
    where product_set_id = target_product_set_id
      and order_num = new_product_line_order;

    if base_product_line_order_occupied then
        update product_lines
        set order_num = order_num + 1
        where product_set_id = target_product_set_id
          and order_num >= new_product_line_order;
    end if;

    insert into product_lines (product_set_id, created_at, order_num, selector_bean_el, description)
    values (target_product_set_id,
            now(),
            new_product_line_order,
            selector,
            new_line_description)
    returning id into new_product_line_id;

    -- add products
    for i in 1..array_upper(product_codes, 1)
        loop
            insert into user_products_to_product_lines (product_line_id, user_product_id, order_num)
            values (new_product_line_id,
                   (select id from user_products where code = product_codes[i]),
                   i);
        end loop;
END
$$;

do
$$
    declare
        new_products_count  int;
        before_products_count  int;
        after_products_count  int;
        new_product_line_id UUID;
    begin
        before_products_count = (select count(*) from user_products);
        perform copy_products('mail_pro_b2c_premium200_start_discount20_v20220414_exp3', 'discount20', 'discount30');
        perform copy_products('mail_pro_b2c_premium1000_start_discount20_v20220414_exp3', 'discount20', 'discount30');
        perform copy_products('mail_pro_b2c_premium3000_start_discount20_v20220414_exp3', 'discount20', 'discount30');


        perform change_start_price('mail_pro_b2c_premium200_start_discount30_v20220414_exp3', 'month', 129, 'RUB');
        perform change_start_price('mail_pro_b2c_premium200_start_discount30_v20220414_exp3', 'year', 899, 'RUB');
        perform change_start_price('mail_pro_b2c_premium1000_start_discount30_v20220414_exp3', 'month', 269, 'RUB');
        perform change_start_price('mail_pro_b2c_premium1000_start_discount30_v20220414_exp3', 'year', 1590, 'RUB');
        perform change_start_price('mail_pro_b2c_premium3000_start_discount30_v20220414_exp3', 'month', 549, 'RUB');
        perform change_start_price('mail_pro_b2c_premium3000_start_discount30_v20220414_exp3', 'year', 3950, 'RUB');

        perform change_start_price('mail_pro_b2c_premium200_start_discount30_v20220414_exp3', 'month', 1.49, 'USD');
        perform change_start_price('mail_pro_b2c_premium200_start_discount30_v20220414_exp3', 'year', 11.49, 'USD');
        perform change_start_price('mail_pro_b2c_premium1000_start_discount30_v20220414_exp3', 'month', 3.49, 'USD');
        perform change_start_price('mail_pro_b2c_premium1000_start_discount30_v20220414_exp3', 'year', 19.99, 'USD');
        perform change_start_price('mail_pro_b2c_premium3000_start_discount30_v20220414_exp3', 'month', 6.99, 'USD');
        perform change_start_price('mail_pro_b2c_premium3000_start_discount30_v20220414_exp3', 'year', 49.99, 'USD');

        perform create_product_line('mail_pro_b2c',
                                   'web start discount 30% exp v3',
                                   (select order_num from product_lines where description = 'web start discount 20% exp v3'),
                                   array ['mail_pro_b2c_premium200_start_discount30_v20220414_exp3',
                                       'mail_pro_b2c_premium1000_start_discount30_v20220414_exp3',
                                       'mail_pro_b2c_premium3000_start_discount30_v20220414_exp3']);

        insert into promo_templates
        (code, description, promo_name_tanker_key_id, from_date, to_date, application_area, application_type, duration,
         duration_measurement, activation_email_template_key, created_at)
        values ('june_web_2022', 'Акция июнь 2022', null,
                '2022-06-20T00:00:00.000+0300' AT TIME ZONE 'UTC', '2022-06-28T00:00:00.000+0300' AT TIME ZONE 'UTC',
                'global'::promo_application_area, 'multiple_time'::promo_application_type, null, null, null, now());

        perform link_promo('web start discount 30% exp v3', 'june_web_2022');

        perform create_promo_payload('june_web_2022', 'web_mail'::payload_type, '{
 "onboarding": {
    "title_tanker": {
      "tanker_project": "mail-liza",
      "tanker_key_set": "custom-promo",
      "tanker_key": "2022_June_20_Onboarding_Header"
    },
    "background": "https://yastatic.net/s3/disk/promo/june-2022/web-disk/onboarding/bg.jpg",
    "illustration": "https://yastatic.net/s3/disk/promo/june-2022/web-disk/onboarding/pic.png",
    "benefits": [
      {
        "text_tanker": {
          "tanker_project": "mail-liza",
          "tanker_key_set": "custom-promo",
          "tanker_key": "2022_June_20_Onboarding_Benefit_domain"
        },
        "url": "https://yastatic.net/s3/disk/promo/common/web-disk/onboarding/benefit-domain.svg"
      },
      {
        "text_tanker": {
          "tanker_project": "mail-liza",
          "tanker_key_set": "custom-promo",
          "tanker_key": "2022_June_20_Onboarding_Benefit_ads"
        },
        "url": "https://yastatic.net/s3/disk/promo/common/web-disk/onboarding/benefit-chat.svg"
      },
      {
        "text_tanker": {
          "tanker_project": "mail-liza",
          "tanker_key_set": "custom-promo",
          "tanker_key": "2022_June_20_Onboarding_Benefit_space"
        },
        "url": "https://yastatic.net/s3/disk/promo/common/web-disk/onboarding/benefit-cloud.svg"
      },
      {
        "text_tanker": {
          "tanker_project": "mail-liza",
          "tanker_key_set": "custom-promo",
          "tanker_key": "2022_June_20_Onboarding_Benefit_other"
        },
        "url": "https://yastatic.net/s3/disk/promo/common/web-disk/onboarding/benefit-effects.svg"
      }
    ]
  }
}', 0);

        perform create_promo_payload('june_web_2022', 'web_disk'::payload_type,'{
 "onboarding": {
    "title_tanker": {
      "tanker_project": "yandex_disk_web",
      "tanker_key_set": "custom-promo",
      "tanker_key": "ufo_subscription_onboarding_June_20_2022_heading"
    },
    "background": "https://yastatic.net/s3/disk/promo/june-2022/web-disk/onboarding/bg.jpg",
    "illustration": "https://yastatic.net/s3/disk/promo/june-2022/web-disk/onboarding/pic.png",
    "benefits": [
      {
        "text_tanker": {
          "tanker_project": "yandex_disk_web",
          "tanker_key_set": "custom-promo",
          "tanker_key": "ufo_subscription_onboarding_June_20_2022_benefit_space"
        },
        "url": "https://yastatic.net/s3/disk/promo/common/web-disk/onboarding/benefit-cloud.svg"
      },
      {
        "text_tanker": {
          "tanker_project": "yandex_disk_web",
          "tanker_key_set": "custom-promo",
          "tanker_key": "ufo_subscription_onboarding_June_20_2022_benefit_unlim"
        },
        "url": "https://yastatic.net/s3/disk/promo/common/web-disk/onboarding/benefit-unlim.svg"
      },
      {
        "text_tanker": {
          "tanker_project": "yandex_disk_web",
          "tanker_key_set": "custom-promo",
          "tanker_key": "ufo_subscription_onboarding_June_20_2022_benefit_ads"
        },
        "url": "https://yastatic.net/s3/disk/promo/common/web-disk/onboarding/benefit-chat.svg"
      },
      {
        "text_tanker": {
          "tanker_project": "yandex_disk_web",
          "tanker_key_set": "custom-promo",
          "tanker_key": "ufo_subscription_onboarding_June_20_2022_benefit_other"
        },
        "url": "https://yastatic.net/s3/disk/promo/common/web-disk/onboarding/benefit-effects.svg"
      }
    ]
  }
}
',0);
            --checks
        after_products_count = (select count(*) from user_products);
        new_products_count = after_products_count - before_products_count;
        ASSERT new_products_count = 3;
        ASSERT exists(select * from product_lines where description = 'web start discount 30% exp v3');
        new_product_line_id := (select id
                                from product_lines
                                where description = 'web start discount 30% exp v3');

        ASSERT new_products_count = (select count(*)
                                     from user_products
                                     where code like 'mail_pro_b2c_premium%_start_discount30_v20220414_exp3');

        ASSERT new_products_count = (select count(*)
                                     from user_products_to_product_lines
                                     where product_line_id = new_product_line_id);
        ASSERT exists(select *
                      from promo_product_lines
                      where product_line_id = new_product_line_id
                      and promo_template_id = (select id from promo_templates where code = 'june_web_2022'));
    end;
$$ LANGUAGE plpgsql;
