insert into tanker_keys (project, key_set, key, created_at)
values ('sarah', 'products', 'features-200gb-disk-value', now()),
       ('sarah', 'products', 'features-2tb-disk-value', now());

with data as (
    select *
    from (values ('b2b_disk_200gb', 'sarah', 'products', 'features-200gb-disk-value'),
                 ('b2b_disk_2tb', 'sarah', 'products', 'features-2tb-disk-value'),
                 ('mail_pro_b2b_edu_premium1000', 'sarah', 'products', 'features-1tb-disk-value'),
                 ('mail_pro_b2b_edu_premium3000', 'sarah', 'products', 'features-3tb-disk-value'),
                 ('mail_pro_b2b_edu_standard100', 'sarah', 'products', 'features-100gb-disk-value'),
                 ('mail_pro_b2b_premium1000', 'sarah', 'products', 'features-1tb-disk-value'),
                 ('mail_pro_b2b_premium3000', 'sarah', 'products', 'features-3tb-disk-value'),
                 ('mail_pro_b2b_standard100', 'sarah', 'products',
                  'features-100gb-disk-value')) s (code_family, project, key_set, key)
),
     to_update as (
         select pf.id as product_feature_id, tk.id as new_value_id
         from user_products up
                  join data d on d.code_family = up.code_family
                  join product_features pf on up.id = pf.user_product_id
                  join tanker_keys tk on tk.project = d.project and tk.key_set = d.key_set and tk.key = d.key
         where pf.code in ('mpfs_disk_space', 'mpfs_disk_space_for_b2b_mail_360')
           and pf.enabled = true
     )
update product_features
set value_tanker_key_id = (select new_value_id from to_update where product_feature_id = product_features.id)
where id in (select product_feature_id from to_update)
